#!/usr/bin/env -S 64tass -i -o 'diamond.prg'

; Copyright (C) 2023 by Krill/Plush

; Permission to use, copy, modify, and/or distribute this software for any
; purpose with or without fee is hereby granted.

; THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
; REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
; INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
; LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
; OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
; PERFORMANCE OF THIS SOFTWARE.

GOCR  = $aad7

STAH  = $c2 ; value is assumed to be $a0 at entry, value left from start-up RAM check
PNT   = $d1 ; current row address

            * = $032c   ; CLALL vector, executed when closing this loaded file

            ; 4 bytes header
           ;.word $032c ; load address
            .word entry ; run address

            ; 29 bytes payload
nextrow     jsr GOCR    ; go to the next row

entry      ;ldy #10     ; the initial column index is conveniently almost right
            dey         ; go one column left on the new row
            bne nobump  ; branch if the left screen edge is not touched
                        ; otherwise start new row in the right-hand half of the graph

next        tya         ; need accu for arithmetic
           ;clc         ; carry flag is always clear here
            sbc #6 - 1  ; go to the next position in left-hand direction
            bcs nowrap  ; branch if not beyond the left screen edge
            eor #$ff    ; set position to go on in the ...
            adc #12 + 1 ; ... right-hand half of the graph
nowrap      tay         ; set column index

nobump      lda #'*'    ; that little star
            cmp (PNT),y ; was it printed at the current column already?
            sta (PNT),y ; (re-)print it regardless
            beq nextrow ; go to the next row if previously printed already

            isb STAH    ; update loop counter, implicitly clear carry flag
            bcc next    ; branch until done

            rts         ; exit to BASIC
