; ==========================================================================
; FAIRLY BAD SOLUTION FOR THE 2023 CHRISTMAS CONTEST 
; VERSION 2, THE BETTER-ER OPTIMIZATION OF SCREEN MEMORY.
;
; Kenneth Jennings
;
; Written for Atari 8-bit computers.
; Should work on any model.
; Should work on any memory size capable of running DOS to load an XEX.
;
; Assembly source intended for MADS assembler.
;
; This program exploits  Atari 8-bit computers' structured load format to 
; create a custom display list and screen data screen in memory.
;
; Total file size is 140 bytes.  
; 116 bytes loaded into Page 0:
; == 3  bytes of 6502 code (JMP to prevent returnning to DOS)
; == 63 bytes of screen data in memory
; == 50 bytes of display list in memory
; File also contains:
; == 6  bytes of miscellaneous data loaded in OS registers.
; == 18 bytes of load file format overhead.
; ==========================================================================

; OS values for graphics 
SDMCTL       = $022F ; DMACTL
SDLSTL       = $0230 ; DLISTL

PLAYFIELD_WIDTH_NORMAL = %00000010 ; Normal, 160 color clocks screen width
ENABLE_DL_DMA          = %00100000 ; Enable running the display list

DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Enable Reload Memory Scan address for this graphics line
DL_TEXT_6  = $06       ; 5 Color text, 20 Columns X 8 Scan lines, 20 bytes/line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

DOS_RUN_ADDR = $02E0 ; Execute here when file loading completes.

	ORG $0080 ; Uses the last half of page 0.  (116 bytes of data and 6502 code.)

; SCREEN RAM 
FOURSTAR
	.sb "*  "                  ;  (3) Rest of line borrowed from THREESTAR
THREESTAR
	.sb "   *     *     *    " ; (20) 
SIXSTAR
	.sb "  * *   * *   * *   " ; (20) 
MORESTAR
	.sb " *   * *   * *   *  " ; (20)  20 + 20 + 20 + 3 == 63 bytes Total Screen RAM

; DISPLAY LIST
DISPLAY_LIST
	.byte DL_BLANK_8
	.byte DL_BLANK_8          ; (2)                       
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
	.byte DL_TEXT_6   ; SIXSTAR (1)
	.byte DL_TEXT_6  ; MORESTAR (1)
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
	.byte DL_TEXT_6   ; SIXSTAR (1)
	.byte DL_TEXT_6  ; MORESTAR (1)
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
	.byte DL_TEXT_6   ; SIXSTAR (1)
	.byte DL_TEXT_6  ; MORESTAR (1)
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
	.byte DL_JUMP_VB          ; (3)
	.word DISPLAY_LIST

PROGRAM_START         ; The only 6502 code executed -
	jmp PROGRAM_START ; Just a jump to prevent going back to DOS

; Poke memory from disk to start things up...
	ORG SDMCTL
		.byte 0   ; turn off DMA in case the disk load does not finish in the same frame.

	ORG SDLSTL
		.word DISPLAY_LIST   ; Set Display List Pointer

	ORG SDMCTL
		.byte ENABLE_DL_DMA|PLAYFIELD_WIDTH_NORMAL ; Set Display DMA control to display screen

	ORG DOS_RUN_ADDR
		.word PROGRAM_START  ; Tell DOS where to begin the program execution.
		
	END
