comment +
Vintage Computing Christmas Challenge 2023

see https://logiker.com/Vintage-Computing-Christmas-Challenge-2023

Target: print following image with minimal executable code as possible

   *     *     *
  * *   * *   * *  
 *   * *   * *   * 
*     *     *     *
 *   * *   * *   * 
  * *   * *   * *  
   *     *     *   
  * *   * *   * *  
 *   * *   * *   * 
*     *     *     *
 *   * *   * *   * 
  * *   * *   * *  
   *     *     *   
  * *   * *   * *  
 *   * *   * *   * 
*     *     *     *
 *   * *   * *   * 
  * *   * *   * *  
   *     *     *   


    +


.model tiny                     ; generate .com program
.code                           ; code segment
org 100h                        ; code starts at offset 100h	
main proc near                  ; main procedure
      mov   cx,3                ; 3 figures
loop1:                          ; calculate start column
      mov   al,6                ; load 6
      mul   cl                  ; multiply with counter
      mov   dl,al               ; this is the start column
      mov   dh,17               ; set start row
      mov   bx,0ff01h           ; directions go up/right first
figure_loop:
      push  bx                  ; save directions
      call  set_position        ; position cursor
      mov   ax,0e2ah            ; function 'teletype output', character asterisk
      int   10h                 ; go!
      pop   bx                  ; restore directions
      add   dh,bh               ; address next row
      cmp   dh,18               ; figure done?
      ja    figure_done         ; yes, check for next figure
      cmp   dh,0                ; first row reached?
      jnz   @f                  ; no
      mov   bh,1                ; change vertical direction to down
@@: 
      add   dl,bl               ; address next column
      cmp   dl,2                ; first column reached?
      jnz   @f                  ; no
      mov   bl,1                ; change horizontal direction to right
@@:   
      cmp   dl,20               ; last column done?
      jnz   @f                  ; no
      mov   bl,-1               ; change horizontal direction to left
@@:
      jmp   figure_loop         ; set next asterisk
figure_done:
      loop loop1                ; next figure if not done yet
set_position:
      mov   ah,02h              ; function 'set cursor posisiot'
      mov   bh,00h              ; page no. 0 
      int   10h                 ; go!
      ret                       ; return to caller / OS
main endp 
end main

