;
; diamonds.asm
;
;
; Created by Stefan Koch on 11.12.23.
;

	ORG	2A13H		; start address

	; Initial register state
	;
	; A  = 0CH	cassette control bits
	; HL = 2A13H	start address (H = star ascii code, L = width and heigth)
	; BC = 0000H	left zero from ldir
	; DE = 2A33H	end address

	LD	B,L		; initialize B with start row
	LD	C,18-3		; initialize C with start column

LOOP:	LD	(0B7A0H),BC	; set cursor position
	LD	A,H		; store '*' in A (parameter value for system routine call that follows)
	CALL	0E329H		; call system routine "CRT"

	LD	A,18		; mirror horizontal
	SUB	C

	LD	(0B7A0H),A	; set cursor position
	LD	A,H		; store '*' in A (parameter value for system routine call that follows)
	CALL	0E329H		; call system routine "CRT"

	LD	A,C		; next horizontal step
	SUB	6
	LD	C,A
	JR	NC,LOOP

	ADD	L		; wrap horizontal
	LD	C,A

	DJNZ	LOOP		; next row

	RET
