
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                          ;;
;; A Vintage Computing Christmas Challenge 2023 entry from Christopher Jam  ;;
;;                                                                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; assemble with ca65, using a rule like
;	cl65 -o $@ --start-addr 812 -t c64 -C c64-asm.cfg $<
;
; (overwites the CLALL vector to autostart.  Cheers Krill for the tip)

set_cursor = $e50c  ; writes X to xp, Y to yp
clr = $e544

xp = $d6
yp = $d3

    .word start
start:
    jsr clr

    ldy#15
stripeloop:

    ldx#19
yloop:
    jsr plot4
    dex
    dey
    bpl yloop

    lda#13
    sbc xp
    tay

    bpl stripeloop
stop:
    bmi stop


plot4:
    jsr plot2
plot2:
    jsr plot1
plot1:

    sty yp
    txa
    eor#$ff ; emulate rsub, rather than storing xp and subtracing it from A
    adc#19  ; carry is set
    tay
    ldx yp

    jsr set_cursor
    lda#$2a ; asterisk
    jmp $e716 ; print knowing the destination is screen.

