run:
	lea		cp+12(pc),a2	; end position of table
	lea		cp+10(pc),a3	; position data
	moveq	#19-1,d7		; 19 loops clr. d7 - OUTER loop counter
	moveq	#0,d6			; and d6  - INNER loop counter
	
.ol							; fetch the next two data points to compare	
	move.b	(a3)+,d4		; the first column info
	move.b	(a3)+,d3		; the second column info
.inner		
	move.l	d6,d5			; scratch of INNER loop counter
	divu	#6,d5	
	swap	d5				; fetch the div-rest, i.e., the modulo
	cmp.b	d4,d5			; first column found?
	bne.s	.scnd			; nah, then check second
	bra.s	.ws				; write star
.scnd		
	cmp.b	d3,d5			; second column found?
	beq.s	.ws				; write star
.wb							; if not write blank
	moveq	#0,d0;			; offset for blank is 0
	bra.s	.wrt
.ws
	moveq	#2,d0			; load offset for star to d0
.wrt
	bsr.s	.w				; write star; OR blank or new-line
.non	
	cmpa.l	a2,a3			; compare addresses - already at the end of pos table?
	blt		.nor			; nah, then don't reset yet
	lea		cp(pc),a3		; ok reset address for data points
.nor
	addq	#1,d6			; increase the inner loop counter
	cmp.b	#19,d6			 
	bne.s	.inner
	moveq	#4,d0			; offset for new-line
	bsr.s	.w				; write new-line
	moveq	#0,d6			; clear the inner loop counter d6
	dbra	d7, .ol			; next outer loop
	rts
	
; ---
; ATTENTION these output routines trashes
; a1, d1
; ---
.w	
	lea		blnk(pc,d0),a1
	move.l	a1,d1
	jsr		$FA5AD6			; absolute rom-addr. destination  of Dosbase-948=_LVOPutStr;
	rts
	
blnk:
	dc.b	' ',0
star:
	dc.b	'*',0
nl:	
	dc.b	10,0
cp:	dc.b 2,4,1,5,0,6,1,5,2,4,3,3


