#version 330 core

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2DRect tex_over;
uniform sampler2DRect tex_under;
uniform vec4 opasity;

in vec2 texcoord0;
in vec2 texcoord1;

//note: [0;1]
vec3 rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* vec3( 43758.5453, 26387.2917, 15467.147) );
}

vec3 lin2srgb( vec3 cl )
{
	cl = clamp( cl, 0.0, 1.0 );
	vec3 c_lo = 12.92 * cl;
	vec3 c_hi = 1.055 * pow(cl,vec3(0.41666)) - 0.055;
	vec3 t = step( vec3(0.0031308), cl );
	return mix( c_lo, c_hi, t );
}

void main()
{
	vec4 col_over = texture( tex_over, texcoord0 );
	vec4 col_under = texture( tex_under, texcoord1 );

	outcol = mix( vec4(1,1,1,1), col_over, opasity.x ) * col_under;

	vec3 rnd = rand( gl_FragCoord.xy ); //TODO: + time
	//outcol.rgb = lin2srgb(outcol.rgb);
	outcol.rgb -= rnd / 255.0f;
}
