#!/usr/bin/env python

#
# Creates (*.KCC) file format from binary file.
#
# http://hc-ddr.hucki.net/wiki/doku.php/z9001:kassettenformate
#

import sys
import ntpath

# command line parameters

USAGE = "USAGE: " + ntpath.basename(sys.argv[0]) + " <TAP file> [header size]\n"

if len(sys.argv) < 2:
	sys.stderr.write("TAP file name missing.\n")
	sys.stderr.write(USAGE)
	sys.exit(1)

if len(sys.argv) > 3:
	sys.stderr.write("Too many arguments.\n")
	sys.stderr.write(USAGE)
	sys.exit(1)

header_size = int(sys.argv[2]) if len(sys.argv) == 3 else 0

# read original file

with open(sys.argv[1], "rb") as f:

	# skip TAP header
	f.read(16)

	# skip file type specific header
	f.read(header_size)

	# read 1st block
	data = f.read(129 - header_size)

	# write data
	sys.stdout.write(data[1:])

	while (True):

		# read next block
		data = f.read(129)
		if (len(data) == 0):
			break

		# write data
		sys.stdout.write(data[1:])
