;
; main.asm
; Synth85 example application
;
; Created by Stefan Koch on 02.03.23.
; Copyright (c) 2023 Moods Plateau.
; All rights reserved.
;

	ORG	200H

	INCLUDE "system/caos.i"

; ---------- switches ----------

SYNTH85_RAM8:		EQU	0
SYNTH85_CUSTOM_INT:	EQU	0
SYNTH85_MASTER_VOLUME:	EQU	0
SYNTH85_CHANNEL_MUTE:	EQU	0
SYNTH85_PATTERN_REPEAT:	EQU	0
SYNTH85_USE_SFX:	EQU	0

; ---------- code start ----------

	DEFM	7FH,7FH,"SYNTH85",1

	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF

	LD	HL,MODULE
	CALL	SYNTH85_LOAD

	CALL	SYNTH85_PLAY

.CONTROL_LOOP:

	; check break key
	CALL	CAOS
	DEFB	BRKT
	JR	C,.STOP_PLAYER

	; check replayer state
	LD	A,(SYNTH85_END)
	AND	A	; A = 0?
	JR	Z,.CONTROL_LOOP

.STOP_PLAYER:

	CALL	SYNTH85_STOP

	POP	AF
	POP	BC
	POP	DE
	POP	HL

	RET

	INCLUDE	"synth85/synth85.s"

MODULE:
	INCBIN "mod/acidjazz.m85"
