!to "clock",plain
!src "config.txt"
*=address

!if cpu = m6502 {
  !cpu 6502
} else {
  !cpu 65c02
}

xoff   = $3C
yoff   = $3D
COLOR  = $30
PLOT   = $F800
SETGR  = $FB40
WAIT   = $FCA8

clock
    jsr    SETGR

unlock

!if timecol = 0 {
  !if cpu = m6502 {
    lda    #0
    sta    xoff
  } else {
    stz    xoff
  }
} else {
    lda    #timecol
    sta    xoff
}
!if timerow = 0 {
  !if cpu = m6502 {
    !if timecol != 0 {
    lda    #0
    }
    sta    yoff
  } else {
    stz    yoff
  }
} else {
    lda    #timerow
    sta    yoff
}
!if module=reset {
    lda    #$12
    jsr    cnvbcddash
    tya
    jsr    cnvbcddash
    tya
    jsr    cnvbcd
} else {
    lda    hours
    jsr    cnvbcddash
    lda    minutes
    jsr    cnvbcddash
    lda    seconds
    jsr    cnvbcd
}
!if datecol = 0 {
    sty    xoff
} else {
    lda    #datecol
    sta    xoff
}
!if daterow = 0 {
    sty    yoff
} else {
    lda    #daterow
    sta    yoff
}
!if format=ddmmyy {
  !if module=reset {
    lda    #$27
    jsr    cnvbcddash
    lda    #4
    jsr    cnvbcddash
    lda    #$19
    jsr    cnvbcd
  } else {
    lda    date
    jsr    cnvbcddash
    lda    month
    jsr    cnvbcddash
    lda    year
    jsr    cnvbcd
  }
} else {
  !if format=mmddyy {
    !if module=reset {
    lda    #4
    jsr    cnvbcddash
    lda    #$27
    jsr    cnvbcddash
    lda    #$19
    jsr    cnvbcd
    } else {
    lda    month
    jsr    cnvbcddash
    lda    date
    jsr    cnvbcddash
    lda    year
    jsr    cnvbcd
    }
  } else { ;yymmdd
    !if module=reset {
    lda    #$19
    jsr    cnvbcd
    lda    #4
    jsr    cnvbcddash
    lda    #$27
    jsr    cnvbcddash
    } else {
    lda    year
    jsr    cnvbcddash
    lda    month
    jsr    cnvbcddash
    lda    date
    jsr    cnvbcd
    }
  }
}

    ; disable delay

    lda    #$2c
    sta    xdelay
    jsr    delay
-   lda    seconds,x
    jsr    cmp60
    sta    seconds,x
    bne    clock
    inx
    bne    - ;"always"

cmp60
    sed
    clc
    adc    #1
    cmp    #$60
    bne    +
    lda    #0
+   cld
    rts

delay
    ldx    #6
    lda    #0
-   jsr    WAIT
    dex
    bne    -
    rts

cnvbcddash
    jsr    cnvbcd
    bne    show1 ;always

cnvbcd
    pha
    lsr
    lsr
    lsr
    lsr
    jsr    show
    pla
    and    #$0f

    ;search variable-length font for requested number

show
    tax
    ldy    #0
-   iny
    lda    font-1, y
    bne    -
    dex
    bpl    -

    ;save it for later

show1
!if cpu = m6502 {
    tya
    pha
} else {
    phy
}

    ;draw an '8' in colour
    ;by drawing zero and then dash

    inx
    ldy    #(colour * 16) + colour
    jsr    draw
    stx    xoff
    ldx    #<(char0-font)
    jsr    draw1
    stx    xoff
xdelay
    jsr    delay
    clc

    ;then erase segments to produce number

!if cpu = m6502 {
    pla
    tax
} else {
    plx
}
    ;ldy    #0 ;COLOR=0, draw1 returns this

draw
    sty    COLOR
draw1
-   ldy    font, x
    beq    shift
    jsr    jump
    inx
    bne    - ;always

jump
    lda    #>clock
    pha
!if cpu = m6502 {
    tya
    pha
} else {
    phy
}
    ldy    xoff
    lda    yoff
    rts

shift
    ;move to next position
    ;carry is always cleared by PLOT

    ldx    xoff ;preserve - two callers rely on original xoff
    txa
    adc    #5 ;font width
    sta    xoff

seg0
    rts

    ;erase bottom-horizontal

seg3
    adc    #3 ;font half-height

    ;erase mid-horizontal

seg2
    adc    #3 ;font half-height

    ;erase top horizontal

seg1
    pha
    iny
    jsr    PLOT
    iny
    pla
--  jmp    PLOT

    ;erase bottom-right vertical

seg7
    adc    #3 ;font half-height

    ;erase top-right vertical

seg6
    iny
    iny
    iny
    !byte  $2c ;mask ADC

    ;erase bottom-left vertical

seg5
    adc    #3 ;font half-height

    ;erase top-left vertical

seg4
!if cpu = m6502 {
    adc    #1
} else {
    inc
}
-   pha
    jsr    PLOT
    pla
!if cpu = m6502 {
    adc    #1
} else {
    inc
}
    bne    -- ;always

font
    !byte    <seg1-1,<seg3-1,<seg4-1,<seg5-1,<seg6-1,<seg7-1,0
char0
    !byte    <seg2-1,0                                 ;0
    !byte    <seg1-1,<seg2-1,<seg3-1,<seg4-1,<seg5-1,0 ;1
!if module=upsidedown {
    !byte    <seg5-1,<seg6-1,0                         ;2
    !byte    <seg4-1,<seg5-1,0                         ;3
    !byte    <seg1-1,<seg3-1,<seg4-1,0                 ;4
    !byte    <seg4-1,<seg7-1,0                         ;5
    !byte    <seg7-1,0                                 ;6
    !byte    <seg2-1,<seg1-1,<seg4-1,<seg5-1,0         ;7
    !byte    0                                         ;8
    !byte    <seg1-1,<seg4-1,0                         ;9
} else {
    !byte    <seg4-1,<seg7-1,0                         ;2
    !byte    <seg4-1,<seg5-1,0                         ;3
    !byte    <seg1-1,<seg3-1,<seg5-1,0                 ;4
    !byte    <seg5-1,<seg6-1,0                         ;5
    !byte    <seg6-1,0                                 ;6
    !byte    <seg2-1,<seg3-1,<seg4-1,<seg5-1,0         ;7
    !byte    0                                         ;8
    !byte    <seg3-1,<seg5-1,0                         ;9
}

;memory-mapped registers
date     !byte $20
month    !byte $05
year     !byte $23
seconds  !byte $56
minutes  !byte $34
hours    !byte $21
