;                                        _____
;                                       / ___ \
; undefined_rocks.asm v0.1 by nikhotmsk  /_o_\
;
; use this command to compile this thing:
; wine ../../sjasmplus-1.18.3.win/sjasmplus.exe undefined_rocks.asm --lst=undefined_rocks.lst --sym=undefined_rocks.sym && ../bas2tap/bas2tap -a10 loader.bas && cat loader.tap undefined_rocks_code.tap > undefined_rocks.tap
;
; run in emulator:
; wine ../../../unreal_speccy/us0.38.1/unreal.exe undefined_rocks.tap
;

;
; message for humans. If you want to learn Z80 assembly language, try
; this tutorial: https://www.chibiakumas.com/z80
;

	DEVICE ZXSPECTRUM128
	org $a000
	;
	; This is a fischinger engine, it is used to draw multiple objects
	; at many places using precompiled drawing code. Ask nikhotmsk if you
	; want to understand how it works.
	;
code_start:
	di
	ld (saved_iy), iy ; save IY register, because it is needed for rst #10
	
	; find the page that was active at boot and place it to player_page
	ld a, (stored_paging_byte_address) ; which is $5b5c (23388)
	and 0b00000111
	ld (player_page), a
	
code_again:
	di
	ld hl, machine_stack_end
	ld sp, hl
	
	; TODO make sure keyboard keys are released
	
	; init variables
	ld hl, 0
	ld (frame_counter), hl
	ld hl, draw_text_empty_byte
	ld (draw_text_pointer), hl
	ld hl, draw_polyline_empty
	ld (polyline_pointer), hl
	ld (polyline_erase_pointer), hl
	ld hl, $4000
	ld (draw_text_screen_address), hl
	ld a, 0
	ld (wait_for_frame_callback_tv_1), a
	ld (wait_for_frame_callback_tv_2), a
	; turbo sound setting should survive
	; TODO cancel pause
	
	ld a, 0
	out (#FE),A      ; border black
	ld HL, #5800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
	ld hl, vars
	ld bc, machine_stack - vars
	ld d, 0
	call fill_mem ; clear variables and shedule
	
	ld hl, assembled_sequence_1_12
	ld bc, assembled_sequence_end - assembled_sequence_1_12
	ld d, 0
	call fill_mem ; clear this area too
	
	;ld ix, vars     ; put four dots
	;ld de, 0x0202	;
	;ld (ix+0), de	;    A-------B
	;ld de, 0x0214	;    |       |
	;ld (ix+2), de	;    |       |
	;ld de, 0x1414	;    |       |
	;ld (ix+4), de	;    D-------C
	;ld de, 0x1402	;
	;ld (ix+6), de
	
	ld a,2
	call $1601 ; select S channel for text
	
	di
	ld hl, im2_interrupt_block ; prepare interrupt mode 2
	ld a, h
	ld i, a
	;ld bc, 257 ; size of interrupt block
;interrupt_setup_loop:
	;ld (hl), $80
	;inc hl
	;dec bc
	;ld a, b
	;or c
	;jr nz, interrupt_setup_loop
	im 2
	
stored_paging_byte_address: EQU $5b5c ; this is standard ROM variable
	
	; initSong
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	or l
	or 16 ; always select basic48 ROM
	ld bc, #7ffd
	ld (stored_paging_byte_address), a
	; always store this byte, so interrupt can restore it back
	; interrupts are not enabled yet, but still lets save it
	out (c),a
	
	ld a, (no_music)
	or a
	call z, initSong
	
	
	jp code_main
saved_iy:	WORD 0
	
	; ORG ahead, do not put extra code here, because not much space

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	org #a0a0 ; interrupt routine here
	push af
	;ld a, 0b00000111 ; debug border white
	;out (#fe), a
	push bc
	push de
	push hl
	push ix
	push iy
	
	; frame counter here
	ld hl, (frame_counter)
	inc hl ; normal flow
	ld (frame_counter), hl ; TODO pause
	
	jp interrupt_routine_continue

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ALIGN 2 ; hardcoded interrupt table here
im2_interrupt_block:
	.257 BYTE #a0 ; this is an interrupt table (size 257 bytes)
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_routine_continue
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_music: BYTE 0
flip_mask: BYTE 0
flip_override: BYTE 0
flip_override_storage: BYTE 0
paging_available: BYTE 0
player_page: BYTE 0
interrupt_choosen_file: WORD 0
interrupt_chosen_erase_bank: WORD 0
interrupt_chosen_queue: WORD 0
draw_polyline_empty: BYTE 0,0,0,0
starfield_enable: BYTE 0
interrupt_routine_continue:
	; do flip
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override
	ld a, (flip_mask)
	and 0b11110111 ; if flip override, then always display screen 0
	ld (flip_override_storage), a ; save flip_mask for later recovery
interrupt_no_override:
	
	ld hl, (frame_counter)
	ld a, l
	and 0b00000010
	jr z, interrupt_frame_is_0
	; set active file to IY
	ld iy, asm_file_for_screen_1
	ld a, 0
	ld (flip_mask), a ; and show screen 0
	jr interrupt_frame_is_not_0_skip
interrupt_frame_is_0:
	; set active file IY
	ld iy, asm_file_for_screen_0 ; writing to screen 0, displayng 1
	ld a, 8
	ld (flip_mask), a ; frame 1 is displayed
interrupt_frame_is_not_0_skip:
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override_2
	ld a, (flip_override_storage) ; recover
	ld (flip_mask), a
interrupt_no_override_2:
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; do not save a byte, because it is for interrupt only
	out  (c),a	; flip shadow screen
	ld (interrupt_choosen_file), iy

	

	; page in a screen file & shedule & erase shedule
	ld iy, (interrupt_choosen_file)
	ld hl, (iy+12) ; [*bank to be erased]
	ld (interrupt_chosen_erase_bank), hl
	ld hl, (iy+10) ; [*shedule]
	ld (interrupt_chosen_queue), hl
	
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	
	ld a, (iy+6) ; [asm enable]
	or a ; if asm is disabled, it means that this page does not exist, no paging available
	jp z, do_not_draw_this_time_wait_for_next_interrupt ; skip the whole thing
	
	
	; the engine makes flip and then erases shapes, on next frame it draws shapes
	ld hl, (frame_counter)
	ld a, l
	and 1
	jr z, interrupt_routine_go_erase
	ld a, (paging_available)
	or a
	jp z, do_not_draw_this_time_wait_for_next_interrupt ; avoid draw two times in compatibility mode
	jp interrupt_routine_no_erase_this_time
	
	
interrupt_routine_go_erase:
	ld b, shedule_bank_size ; erase thing on even frames
	ld ix, (interrupt_chosen_erase_bank)
	ld a, ixl
	or ixh
	jp z, interrupt_routine_no_erase_this_time
	
interrupt_c0:
	ld a, (ix+4) ; [hl register] [drawing code] [enable]
	or a
	jr z, interrupt_skip0
	ld d, (iy+14) ; [frame number mask]
	cp d
	jr nz, interrupt_skip0
	
	ld de, (ix+2) ; drawing code pointer
	ld hl, (ix+0) ; screen pointer
	push bc
	ld b, 0 ; draw black
	call call_de
	pop bc
	ld a, 0
	ld (ix+4), a ; [enable] mark this entry as empty
	
interrupt_skip0:
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, interrupt_c0
	
	; if no shadow screen is supported, draw instantly after erase
	ld a, (paging_available)
	or a
	jp nz, do_not_draw_this_time_wait_for_next_interrupt ; draw on next frame
	
	

interrupt_routine_no_erase_this_time:

	; draw some figurines
	
	ld de, (frame_counter) ; prepare frame number mask byte
	rr d
	rr e
	rr d
	rr e
	ld a, e
	and 0b11111100
	or 1
	ld (iy+14), a ; store [frame number mask]
	
	; select shedule bank here
	ld a, (frame_counter)
	ld de, shedule_bank_size * shedule_entry_size ; 20 * 5 = 100
	ld hl, 0
	; test bits in a
	bit 2, a
	jr z, interrupt_draw_multiply_0001_skip
	add hl, de ; addition here
interrupt_draw_multiply_0001_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 3, a
	jr z, interrupt_draw_multiply_0010_skip
	add hl, de
interrupt_draw_multiply_0010_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 4, a
	jr z, interrupt_draw_multiply_0100_skip
	add hl, de
interrupt_draw_multiply_0100_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 5, a
	jr z, interrupt_draw_multiply_1000_skip
	add hl, de
interrupt_draw_multiply_1000_skip: ; end of multiply
	ex hl, de ; now DE contains proper displacement
	
	ld hl, (interrupt_chosen_queue) ; [*shedule]
	add hl, de
	ld iy, (interrupt_choosen_file)
	ld (iy+12), hl ; [*bank to be erased]
	ld ix, hl
	ld b, shedule_bank_size
interrupt_c1:
	ld a, (ix+4) ; [hl register] [drawing code] [enable]
	or a
	jr z, interrupt_skip1 ; enable byte is reset
	ld d, (iy+14) ; [frame number mask]
	cp d
	jr nz, interrupt_skip1
	ld hl, (ix+0) ; load screen pointer
	ld de, (ix+2) ; load drawing code
	push bc
	ld b, #ff
	call call_de ; run drawing code
	
	; switch page back after running the code
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	pop bc
	
	; do not drop enable byte, it will be used to erase figurine
	
interrupt_skip1:
	; TODO check frame number
	ld de, shedule_entry_size
	add ix, de
	dec b
	jp nz, interrupt_c1
	
do_not_draw_this_time_wait_for_next_interrupt:
	
	ld a, (no_music)
	or a
	jr nz, interrupt_routine_no_music
	; page in a player
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	call player+5 ; run music ; TODO implement pause
	
interrupt_routine_no_music:
	
	call fischinger_draw_polyline
	call fischinger_erase_polyline
	
	; read keyboard
	ld bc, #7ffe ; keys b,n,m,sym,space
	in a, (c)
	and 0b00000001
	jr nz, interrupt_routine_no_break_key
interrupt_routine_goto_code_again:
	; reset program back to the beginning
	ld de, code_again
	push de
	; ei
	reti ; start the program from the beginning
interrupt_routine_no_break_key:
	ld bc, #fdfe ; keys g,f,d,s,a
	in a, (c)
	ld b, a
	and 0b00000010 ; the 's' key
	jr nz, interrupt_routine_no_s_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 0
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_s_key:
	ld a, b
	and 0b00000001 ; the 'a' key
	jr nz, interrupt_routine_no_a_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 1
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_a_key:

	; draw text here
	ld a, (flip_mask)
	or 7  ; select page 7 for text drawing
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a
	
	ld hl, (draw_text_pointer)
	ld a, (hl)
	cp '$'
	jr z, interrupt_no_draw_text
	ld b, 15 ; speed of text drawing here
interrupt_draw_text_cycle:
	ld a, (hl)
	cp '$'
	jr z, interrupt_draw_text_end
	; catch a ctl_at byte here
	cp ctl_at
	jr nz, interrupt_draw_text_to_ctl_at
	
	inc hl
	ld c, (hl)
	inc hl
	ld b, (hl)
	inc hl
	or a ; drop carry
	rl c
	rl c
	rl c
	call get_video_pos ; returns de
	ld (draw_text_screen_address), de
	jr interrupt_draw_text_cycle
	
interrupt_draw_text_to_ctl_at:
	
	push bc
	push hl
	
	ld bc, (draw_text_erase)
	bit 0, c
	jr z, interrupt_draw_text_no_erase
	ld a, ' ' ; erase text with spaces
interrupt_draw_text_no_erase:
	
	ld hl, 0
	
	sub 32 ; substract non-printable chars
	ld l, a
	or a ; drop carry bit
	rl l
	rl h
	rl l
	rl h
	rl l
	rl h ; multiply by eight
	ld de, $3d00 ; Character set
	add hl, de
	ld b, 8
	ld de, (draw_text_screen_address)
	push de
interrupt_draw_text_cycle_cycle:
	ld a, (hl)
	ld (de), a ; write to screen
	ld ixl, a
	ld a, (paging_available)
	or a
	jr z, interrupt_draw_text_no_shadow_screen
	push de
	set 7, d ; extended instruction, set bit 7 in register d
	ld a, ixl
	ld (de), a ; write the same thing to shadow screen
	pop de
	
interrupt_draw_text_no_shadow_screen:
	inc d      ; step down
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle_cycle
	pop de
	inc e ; step right
	ld (draw_text_screen_address), de
	
	pop hl
	pop bc
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle
interrupt_draw_text_end:
	ld (draw_text_pointer), hl
interrupt_no_draw_text:

	; draw starfield
	ld hl, (frame_counter)
	bit 0, l
	jr z, interrupt_starfield_draw_no_loop ; skip odd frames
	; erase
	ld ix, starfield_array
	call interrupt_page_set_player_page
interrupt_starfield_erase_loop:
	ld a, (ix+0) ; [speed] enable
	or a
	jr z, interrupt_starfield_erase_no_loop
	ld a, (ix+3) ; [prev contents]
	or a
	jr nz, interrupt_starfield_erase_skip_dot
	
	ld bc, (ix+1)
	push bc
	call interrupt_page_set_7
	pop bc
	call Unplot ; remove point
	call interrupt_page_set_player_page
	
interrupt_starfield_erase_skip_dot:
	ld de, 4 ; [speed] [x] [y] [prev contents]
	add ix, de
	jr interrupt_starfield_erase_loop
	
interrupt_starfield_erase_no_loop:
	; draw
	ld a, (starfield_enable)
	or a
	jr z, interrupt_starfield_draw_no_loop
	call interrupt_page_set_player_page
	ld ix, starfield_array
interrupt_starfield_draw_loop:
	ld a, (ix+0) ; [speed] enable
	or a
	jr z, interrupt_starfield_draw_no_loop
	ld a, (ix+0)
	add (ix+1)
	ld (ix+1), a ; move star right
	ld bc, (ix+1)
	push bc
	call interrupt_page_set_7
	pop bc
	call Plot ; draw point
	call interrupt_page_set_player_page
	ld de, 4 ; [speed] [x] [y] [prev contents]
	add ix, de
	jr interrupt_starfield_draw_loop
	
interrupt_starfield_draw_no_loop:
	
	
	
	
	ld a, (flip_mask)
	ld l, a
	ld a, (stored_paging_byte_address)
	and 0b11110111
	or l
	or 16 ; basic48
	ld bc, #7ffd
	out (c),a ; restore page as it was before interrupt
	
	
	;ld a, 0b00000000 ; border black again
	;out (#fe), a
	; .6 call busy_wait
	
	
	
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti

;;;;;;;;;;;;;;;;;
; rewind_music
;;;;;;;;;;;;;;;;;
rewind_frame: EQU 950
rewind_music:
	ld a, (no_music)
	or a
	ret nz
	ld bc, rewind_frame
	ld hl, (frame_counter)
	ld de, rewind_frame
	add hl, de
	ld (frame_counter), hl
rewind_music_loop:
	push bc
	call player+5
	pop bc
	dec bc
	ld a, b
	or c
	jr nz, rewind_music_loop
	ret
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;test_figurine_asm:	WORD 0
code_main:
	
	; WANTFIX the loader of music is probably to be located here, make user
	; able to cancel music loading on device that does not
	; support AY sound, by pressing a key
	
	; check if paging available
	ld a, 1
	ld (paging_available), a
	
	ld a, (flip_mask)
	ld h, a
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, 16
	ld ($ffff), a
	
	ld a, 7
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld a, 17
	ld ($ffff), a
	
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, ($ffff)
	cp 17
	jr nz, code_main_paging_ok
	ld a, 0
	ld (paging_available), a
	
	ld a, 2
	out (#FE),A ; border red means that paging is failed (48k compatibility mode)
	
	; change asm_file so it assembles into $6000 and drop even frames
	ld ix, asm_file_for_screen_0
	ld (ix+6), 0 ; [enable asm] screen 0 does not compile
	ld hl, shedule_6000
	ld (ix+10), hl
	;ld hl, erase_queue_6000
	;ld (ix+12), hl
	
	ld ix, asm_file_for_screen_1
	ld hl, 0
	ld (ix+8), hl ; [screen file offset]
	
	
	jr code_main_paging_not_available_skip_music_check
code_main_paging_ok:
	; player page should not be 4 or 7, if so, disable music
	; it would probably always be 0 at load, but I put a check to be sure
	ld a, (player_page)
	and 0b00000111
	cp 7
	jr z, code_main_disable_music
	cp 4
	jr z, code_main_disable_music
	jr code_main_music_ok
code_main_disable_music:
	ld a, 1
	ld (no_music), a
	
code_main_music_ok:
	
	ld hl, vault_c000
	ld bc, shedule_c000_end - vault_c000 ; page 4
	ld d, 0
	call fill_mem ; clear shedule at c000
	
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld HL, #d800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
code_main_paging_not_available_skip_music_check:
	
	ei
	call clear_slow
	
	; set player page, so the code has access to shapes
	ld a, (player_page)
	ld l, a
	di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page (where shapes are stored)
	ei
	
	jp frame_0_program_start ; program moved to $c000 at page 0




;;;;;;;;;;;;;;;;;;;;;;;;;;;
; on screen display text
;;;;;;;;;;;;;;;;;;;;;;;;;;;
ctl_paper:	EQU $11
ctl_ink:	EQU $10
ctl_at:		EQU $16
ctl_bright:	EQU $13
text_nikhotmsk_presents: ; BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
	BYTE ctl_at,8, 6,'       _____'
	BYTE ctl_at,9, 6,'      / ___ \'
	BYTE ctl_at,10,6,'       /   \'
	BYTE ctl_at,11,6,'      /__O__\'
	BYTE ctl_at,14,6,'nikhotmsk  presents', '$'

text_hello:
	BYTE ctl_at,11,13,'Hello!', '$'
text_hello_invitation_1:
	BYTE ctl_at,11,6,'I want to invite you', '$'
text_hello_invitation_2:
	BYTE ctl_at,11,6,'  to the DEMOPARTY', '$'

text_filler_1:
	BYTE ctl_at,20,0,'  Demoparty on old CRT displays ', '$'
text_filler_2:
	BYTE ctl_at,20,0,'        A lot of DIY stuff      ', '$'
text_filler_3:
	BYTE ctl_at,20,0,'    https://undefined.c-c.ru    ', '$'
text_filler_4:
	BYTE ctl_at,20,0,'      http://107.189.31.31      ', '$'



;place_single:
;	BYTE 1, 0, 0, 0, 0 ; [enable] [dY dX] [dFrame]
;	BYTE 0 ; terminator



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; blink_border
; hl - base frame number
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
blink_border_base_frame: WORD 0
blink_border:
	ld (blink_border_base_frame), hl

	call set_right_page_and_chosen_shedule
	
	ld hl, (blink_border_base_frame)
	ld de, 32
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_white	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 64
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_black	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 96
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_white	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	ld hl, (blink_border_base_frame)
	ld de, 128
	add hl, de
	ld ix, hl
	
	ld hl, callback_set_border_black	; drawing code
	ld de, ix							; frame number
	ld bc, 0							; position shift
	call shedule_add_figurine
	
	; switch back to player page
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page, because program is there
	ei
	
	ret

;;;;;;;;;;;;;;;
; call_de
;;;;;;;;;;;;;;;
call_de:
	push de
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_white
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_white:
	ld a, 7
	out (#FE),A      ; border white
	ret
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_black
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_black:
	ld a, 0
	out (#FE),A      ; border black
	ret


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; set_right_page_and_chosen_shedule
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
set_right_page_and_chosen_shedule:
	ld hl, (asm_file_for_screen_0 + 10) ; [schedule]
	ld (asm_chosen_shedule), hl
	
	 ; do not forget to set right page for shedule_add_figurine
	ld iy, asm_file_for_screen_0
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a structure for shadow screen pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
asm_file_for_screen_0: WORD vault_c000	; [*assembler_running_w]
	WORD vault_c000						; [*vault]
	WORD vault_c000_wraparound			; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 4								; [memory page]
	WORD $0000							; [*screen file offset]
	WORD shedule_c000					; [*shedule]
	WORD 0								; [*bank to be erased]
	BYTE 0								; [frame number mask]
	
asm_file_for_screen_1: WORD drawing_code_vault	; [*assembler_running_w]
	WORD drawing_code_vault						; [*vault]
	WORD wraparound_area				; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 7								; [memory page]
	WORD $8000							; [*screen file offset]
	WORD shedule_6000					; [*shedule]
	WORD 0								; [*bank to be erased]
	BYTE 0								; [frame number mask to be erased]
; [*assembler_running_w] [*vault] [*wraparound] [enable asm] [memory page] [*screen file offset] [*screen file offset] [*shedule] [*bank to be erased] [frame number mask]


vault_c000: EQU $c000 ; on page 4
	; size 13384
vault_c000_wraparound: EQU vault_c000 + 13384
vault_c000_end: EQU vault_c000_wraparound + 16
shedule_c000: EQU vault_c000_end
shedule_c000_end: EQU shedule_c000 + (shedule_entry_size * shedule_size)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_mirror_leftright_run
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_mirror_leftright_run:
	ld ix, vars
	; load X coordinate and mirror it
	ld a, (ix+0)
	xor 0b11111111 ; make negative number (and wrap around modulo 256)
	inc a
	ld (ix+0), a
	ld a, (ix+2)
	xor 0b11111111
	inc a
	ld (ix+2), a
	ld a, (ix+4)
	xor 0b11111111
	inc a
	ld (ix+4), a
	ld a, (ix+6)
	xor 0b11111111
	inc a
	ld (ix+6), a
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_mirror_updown_run
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_mirror_updown_run:
	ld ix, vars
	; load Y coordinate and mirror it around the center of the screen
	ld a, (ix+1)
	xor 0b11111111  ; make negative number, same as neg a
	inc a
	add 192
	ld (ix+1), a
	
	ld a, (ix+3)
	xor 0b11111111
	inc a
	add 192
	ld (ix+3), a
	
	ld a, (ix+5)
	xor 0b11111111
	inc a
	add 192
	ld (ix+5), a
	
	ld a, (ix+7)
	xor 0b11111111
	inc a
	add 192
	ld (ix+7), a
	ret



assembled_sequence_tv_color_zone_16:
	BYTE 96, 106 ; [upper lower pixels]
	WORD callback_color_around_tv ; [*drawing code]
	BYTE 128 ; [upper_point_x]
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	
	BYTE 0, 0, 0, 0, 0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; callback_color_around_tv
; hl - screen pointer
; b - drawing/erase mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
callback_color_around_tv:

	ld a, l
	ld e, a
	
	ld a, h
	rra
	rra
	rra
	and 0b00000011 ; get attribute pointer from screen pointer
	ld d, a
	ld a, h
	and 0b10000000 ; also take shadow screen offset
	or  0b01011000  ; set address to $5800
	or d
	ld d, a ; de contains attribute pointer
	
	ld a, 0b01000111 ; black background & white ink
	bit 0, b
	jr z, callback_color_around_tv_erase_mode
	ld a, 0b01000011 ; black background & pink ink
callback_color_around_tv_erase_mode:
	
	ex hl, de
	ld de, -160 ; move up five steps
	add hl, de
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	ld de, 32
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	ld de, -32
	add hl, de ; move up one step
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a ; color area ready
	ret

;;;;;;;;;;;;;;;;;;;;;
; shedule_compile_shape (sequence)
; hl - shape sequence
; de - base frame number
; add_shape_places_table - places sequence
;;;;;;;;;;;;;;;;;;;;;
shedule_prev_line_a: WORD 0 ; X Y (like in memory)
shedule_prev_line_b: WORD 0
shedule_base_frame_number: WORD 0
add_shape_places_table: WORD 0 ; place_single
asm_chosen_shedule: WORD 0
asm_chosen_shedule_with_offset: WORD 0
asm_chosen_screen_offset: BYTE 0
asm_sequence_buffer: WORD 0
silkscreen_mirror_updown: BYTE 0
silkscreen_mirror_leftright: BYTE 0
shedule_compile_shape:
	ld (shedule_base_frame_number), de
	ld ix, hl
	ld hl, 0
	ld (shedule_prev_line_a), hl ; reset prev_line
	ld (shedule_prev_line_b), hl
shedule_add_shape_cycle1:
	; decide where to put the drawing code, which shadow screen to use
	push hl
	ld iy, asm_file_for_screen_0
	ld hl, (shedule_base_frame_number)
	ld a, l ; choice the memory page here
	and 0b00000010
	jr z, shedule_add_shape_screen_0
	ld iy, asm_file_for_screen_1
shedule_add_shape_screen_0:
	ld hl, (iy+8) ; [screen offset]
	ld a, h
	ld (asm_chosen_screen_offset), a
	ld hl, (iy+10) ; [*shedule]
	ld (asm_chosen_shedule), hl
	
	; select page with shapes, so IX will work
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	;ei
	
	pop hl
	
	ld bc, (ix+0)
	ld a, b
	or c
	ret z ; sequence ready
	
	ld bc, (shedule_prev_line_a)
	ld de, (shedule_prev_line_b)
	ld a, b
	or c
	or d
	or e ; check if prev line empty
	jr nz, shedule_add_shape_draw ; do not draw, just remember prev line
	ld bc, (ix+0) ; c = X, b = Y ??
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de
	
	jr shedule_add_shape_cycle1
shedule_add_shape_draw:
	
	; silkscreen (do not forget to push ix)
	ld hl, vars
	ld bc, (ix+0) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (ix+2)
	ld (hl), c
	inc hl
	ld (hl), b ; fill vars with figurine parameters
	inc hl
	ld bc, (shedule_prev_line_b) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (shedule_prev_line_a)
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	
	push ix
	
	ld a, (silkscreen_mirror_updown)
	or a
	call nz, silkscreen_mirror_updown_run
	
	ld a, (silkscreen_mirror_leftright)
	or a
	call nz, silkscreen_mirror_leftright_run
	
	; select page with drawing code vault
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	;ei
	
	pop ix
	
	ld hl, 0 ; if asm is disabled, write 0 at drawing code pointer
	ld a, 1
	ld (upper_point_lower_point), a ; put default value to make entry active
	
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_shape_asm_disabled
	
	push ix
	
	call silkscreen_figurine ; this function sets upper_point_lower_point
	; call debug_lines
	; .8 call busy_wait
	
	; do not forget to set asm_file IY
	call silkscreen.silkscreen_assembler ; (returns HL)
	pop ix
shedule_add_shape_asm_disabled:
	; remember prev line
	push hl ; select page with shapes
	ld a, (player_page)
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	;ei
	pop hl
	ld bc, (ix+0)
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de ; also move ix forvard
	
	; put it in draw queue
	push ix
	
	;push hl ; select page with shedule
	;ld a, (iy+7) ; [memory page]
	;or 16 ; always select basic48 ROM
	;ld l, a
	;; di
	;ld a, (flip_mask)
	;or l
	;ld   bc, #7ffd
	;ld (stored_paging_byte_address), a
	;out  (c),a
	;ei
	;pop hl
	
	;ld a, (iy+6) ; [enable asm]
	; or a
	; call nz, shedule_add_figurine_many_places (deprecated)
	
	ld ix, (asm_sequence_buffer)
	ld (ix+2), hl
	ld hl, (upper_point_lower_point)
	ld (ix+0), hl ; [upper lower pixels] [*drawing code] [upper_point_x]
	ld a, (upper_point_x)
	ld (ix+4), a
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	ld (asm_sequence_buffer), ix
	ld hl, 0
	ld (ix+0), hl ; mark the end of sequence
	
	
	pop ix
	ld de, (shedule_base_frame_number)
	inc de
	inc de
	ld (shedule_base_frame_number), de
	
	jp shedule_add_shape_cycle1

;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_post_sequence
; ix - sequence buffer
; de - base frame number
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_post_sequence_track_enabled: BYTE 1
shedule_post_sequence_running_track: WORD tv_track_testing_line
shedule_post_sequence_track_return: WORD tv_track_testing_line
shedule_post_sequence_running_running_track: WORD 0
shedule_post_sequence:
	ld hl, (shedule_post_sequence_running_track)
	ld (shedule_post_sequence_running_running_track), hl
shedule_post_sequence_loop:
	ld hl, (ix+0) ; [upper lower pixels] [*drawing code] [upper_point_x]
	ld a, h
	or l
	ret z
	ld (upper_point_lower_point), hl
	ld a, (ix+4)
	ld (upper_point_x), a
	ld hl, (ix+2) ; [upper lower pixels] [*drawing code] [upper_point_x]
	; bc is ready
	; de is ready
	ld a, (shedule_post_sequence_track_enabled)
	or a
	jr z, shedule_post_sequence_no_track
	push ix
	ld ix, (shedule_post_sequence_running_running_track)
	; [frame number] [track running] [track returning point]
	; [x] [y] [visible] [enabled]
	ld bc, (ix+0) ; [x] [y]
	push de
	ld de, 4
	add ix, de ; move to next entry in track
	pop de
	ld a, (ix+3) ; enabled
	or a
	jr nz, shedule_post_sequence_track_no_wraparound
	; wraparound here
	push de
	ld de, (shedule_post_sequence_track_return)
	ld ix, de
	ld (shedule_post_sequence_running_running_track), de
	pop de
shedule_post_sequence_track_no_wraparound:
	ld (shedule_post_sequence_running_running_track), ix
	pop ix
	
	
shedule_post_sequence_no_track:
	
	ld a, h
	or l
	jr z, shedule_post_sequence_no_write ; drawing code pointer is 0
	
	push bc
	push de
	push ix
	call shedule_add_figurine
	pop ix
	pop de
	pop bc
shedule_post_sequence_no_write:
	
	inc de
	inc de
	
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_post_sequence_loop
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine_many_places (discontinued)
; hl - drawing code
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_many_places:
	ld ix, (add_shape_places_table)
shedule_add_figurine_many_places_cycle:
	ld a, (ix+0)
	or a
	ret z
	push hl
	ld hl, (shedule_base_frame_number)
	ld de, (ix+3) ; [enable] [dY dX] [dFrame] ; maybe [dX dY] i duno
	add hl, de ; frame number displacement
	ex de, hl
	ld bc, (ix+1) ; position displacement
	pop hl
	push ix
	call shedule_add_figurine
	pop ix
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_add_figurine_many_places_cycle
	
	
	
	;call silkscreen_figurine
	;call debug_draw_silkscreen
	;call silkscreen.silkscreen_assembler ; returns hl
	;ld (test_figurine_asm), hl
	;call debug_lines
	
	;ld hl, (test_figurine_asm)
	;ld de, 41 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #0404 ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 47 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #000c ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 51 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #060c ; shift (Y X)
	;call shedule_add_figurine


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; wait_for_frame
; de - frame number (function will hang if frame_counter is less then de)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wait_for_frame_callback_tv_1: BYTE 0
wait_for_frame_callback_tv_2: BYTE 0
wait_for_frame:
	push de
	ld a, (wait_for_frame_callback_tv_1)
	or a
	jr z, wait_for_frame_no_callback_1
	ld ix, tv_context_1
	call shedule_post_tv
	ld a, 0
	ld (wait_for_frame_callback_tv_1), a
wait_for_frame_no_callback_1:
	
	pop de
	ld hl, (frame_counter)
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	ret nc		; carry is set if (hl < de)
	halt
	jr wait_for_frame

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine
; hl - drawing code
; de - frame number (must not be even (because erase runs at 25 fps))
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_frame_number_mask: BYTE 0
shedule_add_figurine:
	push hl
	
	; select page based on drawing code pointer
	push bc
	
	ld iy, asm_file_for_screen_1
	bit 6, h
	jr z, shedule_add_figurine_select_screen
	bit 7, h
	jr z, shedule_add_figurine_select_screen
	ld iy, asm_file_for_screen_0
	jr shedule_add_figurine_select_screen_ready
shedule_add_figurine_select_screen:
	ld iy, asm_file_for_screen_0
	ld a, e ; choice the memory page based on frame number
	and 0b00000010
	jr z, shedule_add_figurine_select_screen_ready
	ld iy, asm_file_for_screen_1
	
shedule_add_figurine_select_screen_ready:
	
	ld hl, (iy+10) ; [schedule]
	ld (asm_chosen_shedule), hl
	ld hl, (iy+8) ; [screen offset]
	ld a, h
	ld (asm_chosen_screen_offset), a
	
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	; ei
	pop bc
	pop hl
	
	; if asm is not enabled, do not write
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_figurine_abort
	
	push hl
	push de ; prepare frame number mask (enable byte)
	;or a ; drop carry
	rr d
	rr e
	rr d
	rr e
	ld a, e
	and 0b11111100
	or 1 ; LSB is always one
	ld (shedule_add_figurine_frame_number_mask), a
	pop de
	
	push de
	; select shedule bank here
	ld a, e
	ld de, shedule_bank_size * shedule_entry_size ; 20 * 5 = 100
	ld hl, 0
	; test bits in a
	bit 2, a
	jr z, asm_multiply_0001_skip
	add hl, de ; addition here
asm_multiply_0001_skip:
	or a ; drop carry bit
	rl e ; rotate left
	rl d
	bit 3, a
	jr z, asm_multiply_0010_skip
	add hl, de
asm_multiply_0010_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 4, a
	jr z, asm_multiply_0100_skip
	add hl, de
asm_multiply_0100_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 5, a
	jr z, asm_multiply_1000_skip
	add hl, de
asm_multiply_1000_skip: ; end of multiply

	ex hl, de ; now DE contains proper displacement
	ld ix, (asm_chosen_shedule)
	add ix, de
	ld (asm_chosen_shedule_with_offset), ix
	pop de ; now ix is set to shedule bank
	
	push bc
	push de
	ld b, shedule_bank_size
shedule_add_figurine_c1:
	; move ix to empty slot here
	
	ld a, (ix+4) ; [enable]
	or a
	jr z, shedule_add_figurine_found_slot1
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, shedule_add_figurine_c1
	ld ix, (asm_chosen_shedule_with_offset) ; no space left, clobber the first entry
shedule_add_figurine_found_slot1:
	pop de
	pop bc
	
	push bc
	sla b
	sla b
	sla b ; multiply by 8
	ld a, b
	ld hl, (upper_point_lower_point)
	add h
	ld b, a ; add vertical shift ; TODO add return path crop
	ld a, (upper_point_x)
	ld c, a
	call Get_Pixel_Address ; returns hl
debug_point_4:
	ld a, (asm_chosen_screen_offset)
	or h
	ld h, a
	pop bc
	ld a, l      ; add horizontal shift value
	add c
	ld l, a
	ld (ix+0), l ; screen address ready
	ld (ix+1), h
	pop hl
	ld (ix+2), l
	ld (ix+3), h ; drawing code address ready
	ld a, (shedule_add_figurine_frame_number_mask)
	ld (ix+4), a ; enable byte ; it is atomic write here

shedule_add_figurine_abort:
	; change page back to player page
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	;ei

	ret


;;;;;;;;;;;;;;;;;;
; empty_routine
;;;;;;;;;;;;;;;;;;
empty_routine:
	
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
; clear screen data
;;;;;;;;;;;;;;;;;;;;;;;;;
clear_slow:
	; di
	ld a, (flip_mask)
	or 7
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page 7 (no op if it is spectrum48)
	ei
debug_point_6:
	ld a, (paging_available)
	or a
	jr nz, clear_slow_paging_ok
	ld a, $00 ; nop
	ld (clear_slow_mod1), a ; self modify code so it does not write to c000
clear_slow_paging_ok:

	ld HL, #4000
	ld de, #c000 ; on page 7
	ld BC, 6144      ; clear image data (slow and nice)
clear_slow_c1:
	xor a
	ld (hl), a ; draw on screen
clear_slow_mod1:
	ld (de), a ; draw on shadow screen
	inc hl
	inc de
	dec bc
	ld a, c
	or a
	jr nz, clear_slow_skip1
	halt
clear_slow_skip1:
	or b
	jr nz, clear_slow_c1
	
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page, because program is there
	ei
	ret
	
;
; fill memory with constant byte
;
; D  - byte
; HL - start address
; BC - size
;
fill_mem:
  ld A, D
  ld (HL), A
  inc HL
  dec BC
  ld A,B
  or C
  jr nz, fill_mem
  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_figurine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_figurine:
	; TODO clear the header
	ld h, 255
	ld l, 0
	ld (upper_point_lower_point), hl ; reset upper point
	
	; clear the buffer
	ld c, 192
	ld hl, silk_data
	ld b, 255 ; these are the shape coordinates
	ld a, 0   ; they are invalid, so drawing code will fix them
silkscreen_figurine_c1:
	ld (hl), b
	inc hl
	ld (hl), a ; set second point to zero to mark it as disabled
	inc hl
	dec c
	jr nz, silkscreen_figurine_c1
	
	; do silkscreen drawing
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call silkscreen.Draw_Line
	
	
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_draw_silkscreen
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_draw_silkscreen:
;	ld hl, silk_data
;	ld c, 192 ; counter
;	ld b, 0   ; Y coordinate
;debug_draw_silkscreen_c1:
;	push bc
;	ld d, b ; make horisontal line
;	ld c, (hl) ; load X left
;	inc hl
;	ld e, (hl) ; load X right
;	inc hl
;	push hl
;	ld a, e ; check if the line is active
;	or a
;	jr z, debug_draw_silkscreen_s
;	ld a, e ; check if line is valid
;	cp c
;	jr c, debug_draw_silkscreen_s
;	jr z, debug_draw_silkscreen_s
;	dec e ; last point is not included
;	;call nz, Plot
;	;ld b, d
;	;ld c, e
;	;call nz, Plot
;	call Draw_Line
;debug_draw_silkscreen_s:
;	pop hl
;	pop bc
;	inc b
;	dec c
;	jr nz, debug_draw_silkscreen_c1
;	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_lines
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_lines:
;	ld ix, vars
;	ld bc, (ix+0) ; AB
;	ld de, (ix+2)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+2) ; BC
;	ld de, (ix+4)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+4) ; CD
;	ld de, (ix+6)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+6) ; DA
;	ld de, (ix+0)
;	call Draw_Line
;	ret
	
	
;
; this code comes from ChibiAkumas. Compute spectrum video address
;
; B  - X in bytes
; C  - Y
; return DE - mem pos in video memory
;;;;;;;;;;;;;;;;;;;;;;;;;
; get_video_pos
;;;;;;;;;;;;;;;;;;;;;;;;;
get_video_pos:
  ld a, c
  and %00111000
  rlca
  rlca
  or b
  ld e, a ; first byte is ready
  ld a, c
  and %00000111
  ld d, a
  ld a, c
  and %11000000
  rrca
  rrca
  rrca
  or d
  or #40
  ld d, a ; second byte is ready
  ret


;
; this code comes from ChibiAkumas too.
;
; DE - address in video mem
; returns DE - new address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; get_next_line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_next_line:
  inc d
  ld a, d
  and    %00000111 ; check bits Y5 Y4 Y3 overflow
  ret nz
  ld a, e
  add a, %00100000
  ld e, a
  ret c            ; check bits Y2 Y1 Y0 overflow
  ld a, d
  sub    %00001000 ; fix overflow bit Y6
  ld d, a
  ret


;;;;;;;;;;;;;;;;;;;;;;
; busy_wait
;;;;;;;;;;;;;;;;;;;;;;
busy_wait:
	push bc
	ld bc, 5000
busy_wait_loop:
	dec bc
	ld a, b
	or c
	jr nz, busy_wait_loop
	pop bc
	ret




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

shape_flyby_1:
	BYTE 10,115,14,119
	BYTE 40,82,44,87
	BYTE 118,51,119,59
	BYTE 189,66,185,70
	BYTE 198,114,192,112
	BYTE 160,132,162,125
	BYTE 126,113,134,110
	BYTE 130,83,135,88
	BYTE 199,71,201,63
	BYTE 224,105,234,107
	BYTE 186,149,187,154
	BYTE 120,137,112,143
	BYTE 114,100,108,96
	BYTE 143,64,141,54
	BYTE 211,71,219,66
	BYTE 212,128,220,132
	BYTE 164,148,160,156
	BYTE 151,111,142,114
	BYTE 177,55,172,50
	BYTE 225,23,218,17
	BYTE 0,0,0,0




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; scanline fill by John Metcalf
; call with d=x-coord, e=y-coord
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; set end marker

fill:
  ld l,255
  push hl

; calculate bit position of pixel

nextrun:
  ld a,d
  and 7
  inc a
  ld b,a
  ld a,1
bitpos:
  rrca
  djnz bitpos
  ld c,b
  ld b,a

; move left until hitting a set pixel or the screen edge

seekleft:
  ld a,d
  or a
  jr z,goright
  dec d
  rlc b
  call scrpos
  jr nz,seekleft

; move right until hitting a set pixel or the screen edge,
; setting pixels as we go. Check rows above and below and
; save their coordinates to fill later if necessary

seekright:  
  rrc b
  inc d
  jr z,rightedge
goright:
  call scrpos
  jr z,rightedge
  ld (hl),a
  inc e
  call checkadj
  dec e
  dec e
  call checkadj
  inc e
  jr seekright

; check to see if there's another row waiting to be filled

rightedge:
  pop de
  ld a,e
  inc a
  jr nz,nextrun
  ret  

; calculate the pixel address and whether or not it's set

scrpos:
  ld a,e
  and 248
  rra
  scf
  rra
  rra
  ld l,a
  xor e
  and 248
  xor e
  ld h,a
  ld a,l
  xor d
  and 7
  xor d
  rrca
  rrca
  rrca
  ld l,a
  ld a,b
  or (hl)
  cp (hl)
  ret

; check and save the coordinates of an adjacent row

checkadj:
  sla c
  ld a,e
  cp 192
  ret nc
  call scrpos+1
  ret z
  inc c
  bit 2,c
  ret nz
  pop hl
  push de
  jp (hl)

polyline_pointer: WORD draw_polyline_empty
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_draw_polyline
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_draw_polyline:
polyline_speed:
	ld b, 2 ; speed of drawing
draw_polyline_cycle: ; draw logo
	call interrupt_page_set_player_page
	
	ld hl, (polyline_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_draw_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_draw_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	call interrupt_page_set_7
	call Draw_Line
	call interrupt_page_set_player_page
	pop bc
	
	ld hl, (polyline_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_pointer), hl
	
	dec b
	jr nz, draw_polyline_cycle
no_draw_polyline:
	ret

polyline_erase_pointer: WORD draw_polyline_empty
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_erase_polyline
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_erase_polyline:
polyline_erase_speed:
	ld b, 2 ; speed of eraseing
erase_polyline_cycle: ; erase logo
	call interrupt_page_set_player_page
	
	ld hl, (polyline_erase_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_erase_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_erase_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_erase_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_erase_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	call interrupt_page_set_7
	call Erase_Line
	call interrupt_page_set_player_page
	pop bc
	
	ld hl, (polyline_erase_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_erase_pointer), hl
	
	dec b
	jr nz, erase_polyline_cycle
no_erase_polyline:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; callback_self_post_tv_again_context_1
;;;;;;;;;;;;;;;;;;;;;;;;
callback_self_post_tv_again_context_1:
	bit 0, b
	ret z
	ld a, 1
	ld (wait_for_frame_callback_tv_1), a
	ret


;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_7
;;;;;;;;;;;;;;;;;;;;;;;;
interrupt_page_set_7:
	push bc
	; di
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	; ld (stored_paging_byte_address), a ; its interrupt
	ld bc, #7ffd
	out (c),a ; set page 7
	; ei
	pop bc
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_player_page
;;;;;;;;;;;;;;;;;;;;;;;;
; this routine is not used
interrupt_page_set_player_page:
	push de
	push bc
	ld a, (player_page)
	or 16 ; select basic rom
	ld d, a
	;di
	ld a, (flip_mask)
	or d
	; ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set the page
	;ei
	pop bc
	pop de
	ret

;;;;;;;;;;;;;;;;;
; initSong
; hl,de - address of raw pt3 file
;;;;;;;;;;;;;;;;;
initSong:
	ld hl,music
	ld de,music
	ld a, (turbosound_flip_modules)
	or a
	jr z, initSong_noflip
	ex de, hl
initSong_noflip:
	ld a, (turbosound_setting_byte)
	ld (player+10),a
	     ;set bit0, if you want to play without looping
	     ;(optional);
	     ;set bit1 for PT2 and reset for PT3 before
	     ;calling INIT;
	     ;bits2-3: %00-ABC, %01-ACB, %10-BAC (optional);
	     ;bits4-5: %00-no TS, %01-2 modules TS, %10-
	     ;autodetect PT3 TS-format by AlCo (PT 3.7+);
	     ;Remark: old PT3 TS-format by AlCo (PT 3.6) is not
	     ;documented and must be converted to new standard.
	     ;bit6 is set each time, when loop point of 2nd TS
	     ;module is passed (optional).
	     ;bit7 is set each time, when loop point of 1st TS
	     ;or of single module is passed (optional).
	call player+3
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	INCLUDE "vector.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector_silkscreen.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MODULE silkscreen
	INCLUDE "vector_silkscreen.asm"
	ENDMODULE


;;;;;;;;;;;;;;;;;;;;;;;;;
; prerecorded variables here
;;;;;;;;;;;;;;;;;;;;;;;;;

frame_counter: WORD 0
draw_text_pointer: WORD draw_text_empty_byte
draw_text_screen_address: WORD $4000
draw_text_empty_byte: BYTE '$'
draw_text_erase: BYTE 0
;turbosound_setting_byte: BYTE 00010001b ; turbosound enabled
turbosound_setting_byte: BYTE 00000001b
turbosound_flip_modules: BYTE 0


;
; end of code
;
code_end:

; variables here (moved to 5ccb)
vars: EQU $5ccb
	; 8 bytes
upper_point_lower_point: EQU vars + 8
	; 2 bytes
upper_point_x: EQU upper_point_lower_point + 2
	; 1 byte
silk_header: EQU upper_point_x + 1
	; 2 bytes
silk_data: EQU silk_header + 2
	; 192*2 bytes
silk_end: EQU silk_data + 192*2
drawing_code_vault: EQU silk_end
	; 13384 bytes
wraparound_area: EQU drawing_code_vault + 13384
	; 16 bytes
drawing_code_vault_end: EQU wraparound_area + 16

shedule_6000: EQU drawing_code_vault_end
shedule_bank_size: EQU 20
shedule_size: EQU 16 * shedule_bank_size
shedule_entry_size: EQU 5
	; 16 * 20 * 5 bytes ; [hl register] [drawing code] [enable]
machine_stack: EQU shedule_6000 + (shedule_size * shedule_entry_size)
	; stack size 128
machine_stack_end: EQU machine_stack + 128
assembled_sequence_1_12: EQU machine_stack_end
	; [upper lower pixels] [*drawing code] [upper_point_x]
	; 5 * 12
assembled_sequence_2_12: EQU assembled_sequence_1_12 + (5 * 12)
	; 5 * 12
assembled_sequence_3_12: EQU assembled_sequence_2_12 + (5 * 12)
	; 5 * 12
assembled_sequence_4_12: EQU assembled_sequence_3_12 + (5 * 12)
	; 5 * 12
assembled_sequence_5_17: EQU assembled_sequence_4_12 + (5 * 12)
	; 5 * 17
assembled_sequence_6_17: EQU assembled_sequence_5_17 + (5 * 17)
	; 5 * 17
assembled_sequence_7_17: EQU assembled_sequence_6_17 + (5 * 17)
	; 5 * 17
assembled_sequence_8_17: EQU assembled_sequence_7_17 + (5 * 17)
	; 5 * 17
assembled_sequence_end: EQU assembled_sequence_8_17 + (5 * 17)

;;;;;;;;;;;;;;;;;;;;;;;;
; music code here
;;;;;;;;;;;;;;;;;;;;;;;;
	ORG $c000
player:
	MODULE ptsplay
	include "PTSPlay.asm"
	ENDMODULE
music:
	incbin "m.pt3"


;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_make_static_shape_16
; ix - assembled_sequence_pointer
;;;;;;;;;;;;;;;;;;;;;;;
fischinger_make_static_shape_16:
	ld hl, ix
	ld de, 5 * 2
	add hl, de
	ex hl, de
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir
	ld hl, ix
	ld bc, 5 * 8 ; 40 bytes
	ldir
	ld a, 0
	ld (de), a ; null terminator
	inc de
	ld (de), a
	inc de
	ld (de), a
	inc de
	ld (de), a
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FRAME 0 PROGRAM START
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
frame_0_program_start:
	
	;;;;;;;;;;;;;;;;;;;;
	; enable starfield
	;;;;;;;;;;;;;;;;;;;;
	ld a, 1
	ld (starfield_enable), a
	
	;;;;;;;;;;;;;;;;;;;;
	; compile things
	;;;;;;;;;;;;;;;;;;;;
	
	ld a, 1
	out (#FE),A ; border blue (make it visible just for debugging)
	
	ld a, 0
	ld (silkscreen_mirror_updown), a
	ld (silkscreen_mirror_leftright), a ; disable mirror
	
	ld hl, assembled_sequence_1_12
	ld (asm_sequence_buffer), hl
	ld hl, shape_romb_24_down_right ; compile
	ld de, 100 ; frame number (just for shadow screen selection)
	call shedule_compile_shape
	
	ld a, 1
	ld (silkscreen_mirror_updown), a ; enable mirror
	
	ld hl, assembled_sequence_2_12
	ld (asm_sequence_buffer), hl
	ld hl, shape_romb_24_down_right ; compile
	ld de, 100
	call shedule_compile_shape
	
	ld a, 1
	ld (silkscreen_mirror_leftright), a ; enable another mirror
	
	ld hl, assembled_sequence_3_12
	ld (asm_sequence_buffer), hl
	ld hl, shape_romb_24_down_right ; compile
	ld de, 100
	call shedule_compile_shape
	
	ld a, 0
	ld (silkscreen_mirror_updown), a ; disable first mirror
	
	ld hl, assembled_sequence_4_12
	ld (asm_sequence_buffer), hl
	ld hl, shape_romb_24_down_right ; compile
	ld de, 100
	call shedule_compile_shape
	
	ld a, 0
	ld (silkscreen_mirror_leftright), a ; disable second mirror just for sure
	
	
	ld hl, assembled_sequence_5_17
	ld (asm_sequence_buffer), hl
	ld hl, shape_tv_1 ; compile tv box
	ld de, 100
	call shedule_compile_shape
	
	ld hl, assembled_sequence_6_17
	ld (asm_sequence_buffer), hl
	ld hl, shape_tv_2 ; compile tv box
	ld de, 100
	call shedule_compile_shape
	
	ld hl, assembled_sequence_7_17
	ld (asm_sequence_buffer), hl
	ld hl, shape_tv_3 ; compile tv antenna left
	ld de, 100
	call shedule_compile_shape
	
	ld a, 1
	ld (silkscreen_mirror_leftright), a
	ld hl, assembled_sequence_8_17
	ld (asm_sequence_buffer), hl
	ld hl, shape_tv_3 ; compile tv antenna right
	ld de, 100
	call shedule_compile_shape
	
	ld a, 0
	ld (silkscreen_mirror_leftright), a ; cancel mirror
	
	
	ld ix, assembled_sequence_5_17
	call fischinger_make_static_shape_16
	
	ld ix, assembled_sequence_6_17
	call fischinger_make_static_shape_16
	
	ld ix, assembled_sequence_7_17
	call fischinger_make_static_shape_16
	
	ld ix, assembled_sequence_8_17
	call fischinger_make_static_shape_16
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; testing area
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 128 - 2
	call wait_for_frame
	
	ld ix, tv_context_1
	ld de, 128
	ld (ix+0), de ; frame number
	ld de, tv_track_testing_rotate_small
	ld (ix+2), de ; track running
	ld de, tv_track_testing_rotate_small
	ld (ix+4), de ; track returning point
	ld de, callback_self_post_tv_again_context_1
	ld (ix+6), de ; callback
	call shedule_post_tv
	
	; do not forget to kill tv, or it will pop up again
	ld de, 480 - 40
	call wait_for_frame
	call kill_tv
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; 480 hello
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 480
	call wait_for_frame
	
	;ld a, 0
	;out (#FE),A ; border black (cancel red border on boot)
	
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_hello
	ld (draw_text_pointer), hl
	
	ld de, 750
	call wait_for_frame
	
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_hello
	ld (draw_text_pointer), hl
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 800 invitation text
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 800
	call wait_for_frame
	
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_hello_invitation_1 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 800 + 250
	call wait_for_frame
	
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_hello_invitation_1 ; erase text
	ld (draw_text_pointer), hl
	
	ld de, 800 + 320
	call wait_for_frame
	
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_hello_invitation_2 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 1440 - 70
	call wait_for_frame
	
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_hello_invitation_2 ; erase text
	ld (draw_text_pointer), hl
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 1440 draw logo
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 1440
	call wait_for_frame
	
	; flip disable
	ld a, 1
	ld (flip_override), a
	
	ld a, 2
	ld (polyline_speed + 1), a
	ld hl, the_logo_svg
	ld (polyline_pointer), hl ; interrupt now will draw the logo
	
	ld de, 1440 + 30
	call wait_for_frame
	ld hl, the_logo_svg
	ld (polyline_erase_pointer), hl
	
	ld de, 1600
	call wait_for_frame
	ld hl, the_logo_svg
	ld (polyline_pointer), hl ; interrupt now will draw the logo
	
	ld de, 1600 + 30
	call wait_for_frame
	ld hl, the_logo_svg
	ld (polyline_erase_pointer), hl
	
	ld de, 1760 - 40
	call wait_for_frame
	ld a, 8
	ld (polyline_speed + 1), a
	ld hl, the_logo_svg
	ld (polyline_pointer), hl
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 1760 fill logo
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 1760
	call wait_for_frame
	
	; todo write bottom part
	ld a, 4
	ld (polyline_speed + 1), a
	ld hl, the_logo_bottom_svg
	ld (polyline_pointer), hl
	
	ld de, 1760 + 160
	call wait_for_frame
	
	; fill the logo
	ld de, ( 11 * 256) + 196-182 ; fill big letters
	call fill
	ld de, ( 42 * 256) + 196-182
	call fill
	ld de, ( 73 * 256) + 196-182
	call fill
	ld de, (106 * 256) + 196-182
	call fill
	ld de, (133 * 256) + 196-182
	call fill
	ld de, (156 * 256) + 196-182
	call fill
	ld de, (169 * 256) + 196-182
	call fill
	ld de, (201 * 256) + 196-182
	call fill
	ld de, (228 * 256) + 196-182
	call fill
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 2160 tv 1
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 2160 - 50
	call wait_for_frame
	;ld a, 0
	;ld (starfield_enable), a ; disable starfield
	call clear_slow
	
	
	ld ix, tv_context_1
	ld de, 2160
	ld (ix+0), de ; frame number
	ld de, tv_track_testing_rotate_small
	ld (ix+2), de ; track running
	ld de, tv_track_testing_rotate_small
	ld (ix+4), de ; track returning point (disabled)
	ld de, 2160 - 2
	call wait_for_frame
	call shedule_post_tv
	
	
	ld a, 0
	ld (flip_override), a ; flip enable
	
	ld de, 2160
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_filler_1 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 300
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_filler_1 ; erase text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 320
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_filler_2 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 300 + 320
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_filler_2 ; erase text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 320 + 320
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_filler_3 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 300 + 320 + 320
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_filler_3 ; erase text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 320 + 320 + 320
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_filler_4 ; draw text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 300 + 320 + 320 + 320
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_filler_4 ; erase text
	ld (draw_text_pointer), hl
	
	ld de, 2160 + 320 + 320 + 320 + 320
	call wait_for_frame
	
	call kill_tv
	ld hl, the_logo_svg
	ld (polyline_pointer), hl
	ld de, 2160 + 140 + 320 + 320 + 320 + 320 + 100
	call wait_for_frame
	ld hl, the_logo_bottom_svg
	ld (polyline_pointer), hl
	
	; flip disable
	ld a, 1
	ld (flip_override), a
	
	ld de, 7276
	call wait_for_frame ; and do callback reposting tv
	
	
code_loop:
	halt
	jr code_loop
	; autorestart logic was here
	; jp interrupt_routine_goto_code_again

; main program ends here



;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; kill_tv
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
kill_tv:
	; scan shedule and find all callbacks that post new tvs
	; and remove them
	ld ix, shedule_6000
	ld bc, shedule_size ; all banks
kill_tv_cycle_1:
	ld de, callback_self_post_tv_again_context_1
	ld hl, (ix+2) ; [hl register] [drawing code] [enable]
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	jr nz, kill_tv_cycle_1_context_1
	ld a, 0
	ld (ix+4), a ; [enable] mark entry as empty
kill_tv_cycle_1_context_1:

	ld de, shedule_entry_size
	add ix, de
	dec bc
	ld a, b
	or c
	jr nz, kill_tv_cycle_1
	
	ld a, 0
	ld (wait_for_frame_callback_tv_1), a
	ld (wait_for_frame_callback_tv_2), a
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_post_tv
; ix - context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_post_tv:
	; [frame number] [track running] [track returning point] [callback]
	ld de, (ix+2)
	ld (shedule_post_sequence_running_track), de
	ld de, (ix+4)
	ld (shedule_post_sequence_track_return), de
	
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_2_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_3_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_4_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_tv_color_zone_16 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_5_17 ; post tv frame
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_6_17 ; post tv frame 2
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_7_17 ; post tv antenna
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_8_17 ; post tv antenna
	call shedule_post_sequence
	pop ix
	
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl ; increment frame number
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_2_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_3_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_4_12 ; post
	call shedule_post_sequence
	pop ix
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_2_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_3_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_4_12 ; post
	call shedule_post_sequence
	pop ix
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_2_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_3_12 ; post
	call shedule_post_sequence
	pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_4_12 ; post
	call shedule_post_sequence
	pop ix
	
	call advance_running_track_8 ; increment track
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl ; new frame number stored in context
	
	; put a callback so tv can post itself again and again
	ld hl, (ix+0)
	ld de, 8
	sbc hl, de
	set 1, l ; make so that callback ends up only for screen 1
	ex hl, de ; frame number ready
	ld bc, 0
	ld hl, (ix+6)
	push ix
	call shedule_add_figurine
	pop ix
	
	; [frame number] [track running] [track returning point] [callback]
	ld de, (shedule_post_sequence_running_track)
	ld (ix+2), de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;
; advance_running_track_8
;;;;;;;;;;;;;;;;;;;;;;;;;;;
advance_running_track_8:
	push ix
	ld ix, (shedule_post_sequence_running_track)
	ld b, 4
advance_running_track_8_loop:
	
	
	ld de, 4 ; [x] [y] [visible] [enabled]
	add ix, de ; move to next entry in track
	
	ld a, (ix+3) ; enabled
	or a
	jr nz, advance_running_track_8_no_wraparound
	; wraparound here
	
	ld ix, (shedule_post_sequence_track_return)
	
	
advance_running_track_8_no_wraparound:
	dec b
	jr nz, advance_running_track_8_loop
	ld (shedule_post_sequence_running_track), ix
	pop ix
	ret


tv_context_1:
	WORD 0, 0, 0, 0
; [frame number] [track running] [track returning point] [callback]



;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;

shape_romb_24_down_right:
	BYTE 128,96,128,96 ; this is previous line
	BYTE 128+ 0,96+ 4,128+ 4,96+ 0 ; draw figurine based on prev line
	BYTE 128+ 0,96+ 8,128+ 8,96+ 0
	BYTE 128+ 0,96+12,128+12,96+ 0
	BYTE 128+ 0,96+16,128+16,96+ 0
	BYTE 128+ 0,96+20,128+20,96+ 0
	BYTE 128+ 4,96+20,128+20,96+ 4
	BYTE 128+ 8,96+20,128+20,96+ 8
	BYTE 128+12,96+20,128+20,96+12 ; this is where next figurine would fire
	BYTE 128+16,96+20,128+20,96+16
	BYTE 128+20,96+20,128+20,96+20
	; assembled_sequence_1_12 has only 11 places (and zero terminator is 12)
	BYTE 0,0,0,0
	
shape_tv_1:
	BYTE 103,71,103,120
	BYTE 103,120,152,120
	BYTE 103,71,103,120 ; broken shape just to draw two lines
	BYTE 0,0,0,0 ; this thing compile to two identical frames for each shadowscreen
	
shape_tv_2:
	BYTE 103,71,152,71
	BYTE 152,71,152,120
	BYTE 103,71,152,71 ; another broken shape to complete the tv box
	BYTE 0,0,0,0

shape_tv_3:
	BYTE 126,70,126,70
	BYTE 121,65,121,65
	BYTE 126,70,126,70 ; tv antenna left
	BYTE 0,0,0,0

tv_track_testing_rotate_small:
	; [x] [y] [visible] [enabled]
	BYTE -1,-1,1,1
	BYTE -1,-1,1,1
	BYTE -1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1, 1,1,1
	BYTE  1, 1,1,1
	BYTE  1, 1,1,1
	BYTE -1, 1,1,1
	BYTE -1, 1,1,1
	BYTE -1, 1,1,1
	BYTE 0,0,0,0
	
tv_track_testing_line_slow:
	; [x] [y] [visible] [enabled]
	BYTE -12,0,1,1
	BYTE -12,0,1,1
	BYTE -11,0,1,1
	BYTE -11,0,1,1
	BYTE -10,0,1,1
	BYTE -10,0,1,1
	BYTE -9,0,1,1
	BYTE -9,0,1,1
	BYTE -8,0,1,1
	BYTE -8,0,1,1
	BYTE -7,0,1,1
	BYTE -7,0,1,1
	BYTE -6,0,1,1
	BYTE -6,0,1,1
	BYTE -5,0,1,1
	BYTE -5,0,1,1
	BYTE -4,0,1,1
	BYTE -4,0,1,1
	BYTE -3,0,1,1
	BYTE -3,0,1,1
	BYTE -2,0,1,1
	BYTE -2,0,1,1
	BYTE -1,0,1,1
	BYTE -1,0,1,1
	BYTE  0,0,1,1
	BYTE  0,0,1,1
	BYTE  1,0,1,1
	BYTE  1,0,1,1
	BYTE  2,0,1,1
	BYTE  2,0,1,1
	BYTE  3,0,1,1
	BYTE  3,0,1,1
	BYTE  4,0,1,1
	BYTE  4,0,1,1
	BYTE  5,0,1,1
	BYTE  5,0,1,1
	BYTE  6,0,1,1
	BYTE  6,0,1,1
	BYTE  7,0,1,1
	BYTE  7,0,1,1
	BYTE  8,0,1,1
	BYTE  8,0,1,1
	BYTE  9,0,1,1
	BYTE  9,0,1,1
	BYTE 10,0,1,1
	BYTE 10,0,1,1
	BYTE 11,0,1,1
	BYTE 11,0,1,1
	BYTE 0,0,0,0
	
tv_track_testing_line:
	; [x] [y] [visible] [enabled]
	BYTE -12,0,1,1
	BYTE -11,0,1,1
	BYTE -10,0,1,1
	BYTE -9,0,1,1
	BYTE -8,0,1,1
	BYTE -7,0,1,1
	BYTE -6,0,1,1
	BYTE -5,0,1,1
	BYTE -4,0,1,1
	BYTE -3,0,1,1
	BYTE -2,0,1,1
	BYTE -1,0,1,1
	BYTE  0,0,1,1
	BYTE  1,0,1,1
	BYTE  2,0,1,1
	BYTE  3,0,1,1
	BYTE  4,0,1,1
	BYTE  5,0,1,1
	BYTE  6,0,1,1
	BYTE  7,0,1,1
	BYTE  8,0,1,1
	BYTE  9,0,1,1
	BYTE 10,0,1,1
	BYTE 11,0,1,1
	BYTE 0,0,0,0

the_logo_svg:
	; path U 1
	.BYTE 15, 63, 13, 61
	.BYTE 13, 61, 11, 59
	.BYTE 11, 59, 9, 51
	.BYTE 9, 51, 8, 26
	.BYTE 8, 26, 8, 3
	.BYTE 8, 3, 11, 3
	.BYTE 11, 3, 13, 3
	.BYTE 13, 3, 13, 26
	.BYTE 13, 26, 14, 50
	.BYTE 14, 50, 15, 54
	.BYTE 15, 54, 18, 57
	.BYTE 18, 57, 22, 56
	.BYTE 22, 56, 24, 54
	.BYTE 24, 54, 26, 52
	.BYTE 26, 52, 27, 48
	.BYTE 27, 48, 28, 43
	.BYTE 28, 43, 28, 22
	.BYTE 28, 22, 28, 3
	.BYTE 28, 3, 30, 3
	.BYTE 30, 3, 32, 3
	.BYTE 32, 3, 32, 21
	.BYTE 32, 21, 32, 43
	.BYTE 32, 43, 31, 49
	.BYTE 31, 49, 29, 56
	.BYTE 29, 56, 24, 61
	.BYTE 24, 61, 21, 63
	.BYTE 21, 63, 15, 63
	; path N 2
	.BYTE 40, 30, 40, 3
	.BYTE 40, 3, 43, 3
	.BYTE 43, 3, 46, 3
	.BYTE 46, 3, 52, 24
	.BYTE 52, 24, 59, 44
	.BYTE 59, 44, 59, 24
	.BYTE 59, 24, 59, 3
	.BYTE 59, 3, 61, 3
	.BYTE 61, 3, 63, 3
	.BYTE 63, 3, 63, 28
	.BYTE 63, 28, 63, 52
	.BYTE 63, 52, 61, 52
	.BYTE 61, 52, 58, 53
	.BYTE 58, 53, 51, 33
	.BYTE 51, 33, 44, 12
	.BYTE 44, 12, 44, 34
	.BYTE 44, 34, 44, 56
	.BYTE 44, 56, 43, 56
	.BYTE 43, 56, 40, 57
	.BYTE 40, 57, 40, 30
	; path D 3 ext
	.BYTE 71, 27, 71, 3
	.BYTE 71, 3, 78, 3
	.BYTE 78, 3, 89, 5
	.BYTE 89, 5, 92, 7
	.BYTE 92, 7, 94, 11
	.BYTE 94, 11, 96, 15
	.BYTE 96, 15, 97, 20
	.BYTE 97, 20, 96, 33
	.BYTE 96, 33, 95, 38
	.BYTE 95, 38, 93, 41
	.BYTE 93, 41, 88, 47
	.BYTE 88, 47, 77, 49
	.BYTE 77, 49, 72, 50
	.BYTE 72, 50, 71, 50
	.BYTE 71, 50, 71, 27
	; path D 3
	.BYTE 79, 44, 84, 43
	.BYTE 84, 43, 86, 42
	.BYTE 86, 42, 89, 40
	.BYTE 89, 40, 90, 38
	.BYTE 90, 38, 92, 35
	.BYTE 92, 35, 93, 29
	.BYTE 93, 29, 93, 23
	.BYTE 93, 23, 92, 18
	.BYTE 92, 18, 91, 14
	.BYTE 91, 14, 89, 11
	.BYTE 89, 11, 87, 10
	.BYTE 87, 10, 83, 9
	.BYTE 83, 9, 79, 8
	.BYTE 79, 8, 76, 8
	.BYTE 76, 8, 76, 27
	.BYTE 76, 27, 76, 45
	.BYTE 76, 45, 79, 44
	
	; path E4
	.BYTE 104, 25, 104, 3
	.BYTE 104, 3, 113, 3
	.BYTE 113, 3, 123, 3
	.BYTE 123, 3, 123, 6
	.BYTE 123, 6, 123, 8
	.BYTE 123, 8, 115, 8
	.BYTE 115, 8, 108, 8
	.BYTE 108, 8, 108, 14
	.BYTE 108, 14, 108, 21
	.BYTE 108, 21, 114, 21
	.BYTE 114, 21, 121, 21
	.BYTE 121, 21, 122, 20
	.BYTE 122, 20, 122, 23
	.BYTE 122, 23, 122, 25
	.BYTE 122, 25, 118, 26
	.BYTE 118, 26, 111, 26
	.BYTE 111, 26, 108, 26
	.BYTE 108, 26, 108, 34
	.BYTE 108, 34, 108, 41
	.BYTE 108, 41, 110, 41
	.BYTE 110, 41, 115, 41
	.BYTE 115, 41, 121, 41
	.BYTE 121, 41, 123, 41
	.BYTE 123, 41, 123, 43
	.BYTE 123, 43, 123, 45
	.BYTE 123, 45, 122, 46
	.BYTE 122, 46, 114, 46
	.BYTE 114, 46, 106, 46
	.BYTE 106, 46, 104, 47
	.BYTE 104, 47, 104, 25
	; path F5
	.BYTE 130, 24, 130, 3
	.BYTE 130, 3, 139, 3
	.BYTE 139, 3, 148, 3
	.BYTE 148, 3, 148, 6
	.BYTE 148, 6, 148, 8
	.BYTE 148, 8, 141, 8
	.BYTE 141, 8, 134, 8
	.BYTE 134, 8, 134, 14
	.BYTE 134, 14, 134, 20
	.BYTE 134, 20, 138, 21
	.BYTE 138, 21, 144, 21
	.BYTE 144, 21, 146, 21
	.BYTE 146, 21, 146, 23
	.BYTE 146, 23, 146, 26
	.BYTE 146, 26, 140, 25
	.BYTE 140, 25, 134, 25
	.BYTE 134, 25, 134, 35
	.BYTE 134, 35, 134, 45
	.BYTE 134, 45, 132, 45
	.BYTE 132, 45, 130, 45
	.BYTE 130, 45, 130, 24
	; path I 6
	.BYTE 158, 47, 156, 46
	.BYTE 156, 46, 155, 46
	.BYTE 155, 46, 155, 25
	.BYTE 155, 25, 155, 3
	.BYTE 155, 3, 157, 3
	.BYTE 157, 3, 159, 3
	.BYTE 159, 3, 159, 25
	.BYTE 159, 25, 158, 47
	
	; path N 7
	.BYTE 187, 50, 184, 50
	.BYTE 184, 50, 178, 30
	.BYTE 178, 30, 171, 11
	.BYTE 171, 11, 171, 29
	.BYTE 171, 29, 171, 48
	.BYTE 171, 48, 170, 48
	.BYTE 170, 48, 168, 48
	.BYTE 168, 48, 167, 47
	.BYTE 167, 47, 167, 25
	.BYTE 167, 25, 167, 3
	.BYTE 167, 3, 170, 3
	.BYTE 170, 3, 172, 3
	.BYTE 172, 3, 179, 23
	.BYTE 179, 23, 186, 42
	.BYTE 186, 42, 186, 23
	.BYTE 186, 23, 186, 3
	.BYTE 186, 3, 188, 3
	.BYTE 188, 3, 190, 3
	.BYTE 190, 3, 190, 27
	.BYTE 190, 27, 190, 51
	.BYTE 190, 51, 187, 50
	
	; path E 8
	.BYTE 208, 55, 199, 53
	.BYTE 199, 53, 199, 28
	.BYTE 199, 28, 199, 3
	.BYTE 199, 3, 208, 3
	.BYTE 208, 3, 218, 3
	.BYTE 218, 3, 218, 6
	.BYTE 218, 6, 218, 9
	.BYTE 218, 9, 210, 9
	.BYTE 210, 9, 202, 9
	.BYTE 202, 9, 202, 17
	.BYTE 202, 17, 203, 24
	.BYTE 203, 24, 210, 25
	.BYTE 210, 25, 217, 25
	.BYTE 217, 25, 217, 29
	.BYTE 217, 29, 217, 32
	.BYTE 217, 32, 203, 30
	.BYTE 203, 30, 202, 30
	.BYTE 202, 30, 202, 39
	.BYTE 202, 39, 202, 48
	.BYTE 202, 48, 210, 50
	.BYTE 210, 50, 218, 51
	.BYTE 218, 51, 218, 54
	.BYTE 218, 54, 218, 58
	.BYTE 218, 58, 208, 55
	
	
	; path D 9 ext
	.BYTE 235, 64, 229, 62
	.BYTE 229, 62, 225, 60
	.BYTE 225, 60, 225, 32
	.BYTE 225, 32, 225, 3
	.BYTE 225, 3, 230, 3
	.BYTE 230, 3, 236, 4
	.BYTE 236, 4, 240, 5
	.BYTE 240, 5, 243, 7
	.BYTE 243, 7, 245, 10
	.BYTE 245, 10, 247, 14
	.BYTE 247, 14, 249, 19
	.BYTE 249, 19, 250, 25
	.BYTE 250, 25, 251, 36
	.BYTE 251, 36, 250, 46
	.BYTE 250, 46, 247, 58
	.BYTE 247, 58, 245, 61
	.BYTE 245, 61, 243, 63
	.BYTE 243, 63, 239, 64
	.BYTE 239, 64, 235, 64
	
	; path D 9
	.BYTE 240, 56, 242, 55
	.BYTE 242, 55, 243, 52
	.BYTE 243, 52, 245, 48
	.BYTE 245, 48, 246, 33
	.BYTE 246, 33, 245, 24
	.BYTE 245, 24, 243, 16
	.BYTE 243, 16, 241, 13
	.BYTE 241, 13, 238, 11
	.BYTE 238, 11, 236, 10
	.BYTE 236, 10, 231, 10
	.BYTE 231, 10, 229, 10
	.BYTE 229, 10, 229, 32
	.BYTE 229, 32, 229, 55
	.BYTE 229, 55, 232, 56
	.BYTE 232, 56, 235, 57
	.BYTE 235, 57, 237, 57
	.BYTE 237, 57, 240, 56
	.BYTE 0,0,0,0

the_logo_bottom_svg:
	; path hacker
	.BYTE 90, 88, 89, 88
	.BYTE 89, 88, 87, 86
	.BYTE 87, 86, 86, 86
	.BYTE 86, 86, 85, 87
	.BYTE 85, 87, 83, 88
	.BYTE 83, 88, 81, 87
	.BYTE 81, 87, 80, 86
	.BYTE 80, 86, 79, 87
	.BYTE 79, 87, 79, 88
	.BYTE 79, 88, 78, 87
	.BYTE 78, 87, 78, 86
	.BYTE 78, 86, 78, 85
	.BYTE 78, 85, 78, 86
	.BYTE 78, 86, 76, 87
	.BYTE 76, 87, 73, 88
	.BYTE 73, 88, 72, 88
	.BYTE 72, 88, 70, 87
	.BYTE 70, 87, 70, 86
	.BYTE 70, 86, 69, 87
	.BYTE 69, 87, 68, 88
	.BYTE 68, 88, 67, 88
	.BYTE 67, 88, 65, 88
	.BYTE 65, 88, 64, 86
	.BYTE 64, 86, 63, 86
	.BYTE 63, 86, 62, 88
	.BYTE 62, 88, 61, 88
	.BYTE 61, 88, 60, 88
	.BYTE 60, 88, 58, 86
	.BYTE 58, 86, 58, 85
	.BYTE 58, 85, 58, 84
	.BYTE 58, 84, 57, 85
	.BYTE 57, 85, 57, 87
	.BYTE 57, 87, 56, 87
	.BYTE 56, 87, 55, 86
	.BYTE 55, 86, 55, 85
	.BYTE 55, 85, 55, 84
	.BYTE 55, 84, 54, 84
	.BYTE 54, 84, 49, 83
	.BYTE 49, 83, 48, 83
	.BYTE 48, 83, 48, 84
	.BYTE 48, 84, 46, 88
	.BYTE 46, 88, 45, 88
	.BYTE 45, 88, 45, 87
	.BYTE 45, 87, 45, 85
	.BYTE 45, 85, 46, 82
	.BYTE 46, 82, 45, 81
	.BYTE 45, 81, 43, 80
	.BYTE 43, 80, 43, 79
	.BYTE 43, 79, 42, 78
	.BYTE 42, 78, 43, 77
	.BYTE 43, 77, 43, 76
	.BYTE 43, 76, 44, 75
	.BYTE 44, 75, 46, 74
	.BYTE 46, 74, 48, 74
	.BYTE 48, 74, 48, 72
	.BYTE 48, 72, 48, 69
	.BYTE 48, 69, 49, 69
	.BYTE 49, 69, 49, 72
	.BYTE 49, 72, 49, 75
	.BYTE 49, 75, 50, 75
	.BYTE 50, 75, 52, 77
	.BYTE 52, 77, 54, 78
	.BYTE 54, 78, 55, 80
	.BYTE 55, 80, 56, 81
	.BYTE 56, 81, 56, 80
	.BYTE 56, 80, 57, 71
	.BYTE 57, 71, 57, 68
	.BYTE 57, 68, 58, 67
	.BYTE 58, 67, 59, 68
	.BYTE 59, 68, 58, 70
	.BYTE 58, 70, 58, 75
	.BYTE 58, 75, 57, 82
	.BYTE 57, 82, 58, 82
	.BYTE 58, 82, 59, 81
	.BYTE 59, 81, 60, 79
	.BYTE 60, 79, 60, 78
	.BYTE 60, 78, 61, 77
	.BYTE 61, 77, 64, 77
	.BYTE 64, 77, 65, 79
	.BYTE 65, 79, 66, 79
	.BYTE 66, 79, 66, 81
	.BYTE 66, 81, 65, 85
	.BYTE 65, 85, 66, 86
	.BYTE 66, 86, 67, 87
	.BYTE 67, 87, 67, 86
	.BYTE 67, 86, 68, 86
	.BYTE 68, 86, 69, 82
	.BYTE 69, 82, 70, 80
	.BYTE 70, 80, 71, 78
	.BYTE 71, 78, 73, 77
	.BYTE 73, 77, 75, 77
	.BYTE 75, 77, 75, 78
	.BYTE 75, 78, 76, 79
	.BYTE 76, 79, 76, 80
	.BYTE 76, 80, 75, 81
	.BYTE 75, 81, 74, 80
	.BYTE 74, 80, 74, 79
	.BYTE 74, 79, 73, 79
	.BYTE 73, 79, 71, 82
	.BYTE 71, 82, 71, 84
	.BYTE 71, 84, 71, 85
	.BYTE 71, 85, 72, 86
	.BYTE 72, 86, 73, 86
	.BYTE 73, 86, 75, 86
	.BYTE 75, 86, 76, 85
	.BYTE 76, 85, 77, 84
	.BYTE 77, 84, 78, 82
	.BYTE 78, 82, 78, 78
	.BYTE 78, 78, 79, 70
	.BYTE 79, 70, 81, 68
	.BYTE 81, 68, 83, 68
	.BYTE 83, 68, 83, 69
	.BYTE 83, 69, 84, 70
	.BYTE 84, 70, 84, 72
	.BYTE 84, 72, 81, 76
	.BYTE 81, 76, 80, 77
	.BYTE 80, 77, 80, 78
	.BYTE 80, 78, 80, 79
	.BYTE 80, 79, 80, 78
	.BYTE 80, 78, 83, 77
	.BYTE 83, 77, 85, 78
	.BYTE 85, 78, 85, 79
	.BYTE 85, 79, 85, 81
	.BYTE 85, 81, 84, 83
	.BYTE 84, 83, 81, 84
	.BYTE 81, 84, 81, 85
	.BYTE 81, 85, 83, 86
	.BYTE 83, 86, 85, 86
	.BYTE 85, 86, 85, 85
	.BYTE 85, 85, 86, 84
	.BYTE 86, 84, 87, 82
	.BYTE 87, 82, 88, 80
	.BYTE 88, 80, 88, 79
	.BYTE 88, 79, 90, 77
	.BYTE 90, 77, 91, 77
	.BYTE 91, 77, 93, 78
	.BYTE 93, 78, 94, 79
	.BYTE 94, 79, 94, 80
	.BYTE 94, 80, 93, 82
	.BYTE 93, 82, 92, 83
	.BYTE 92, 83, 89, 85
	.BYTE 89, 85, 90, 86
	.BYTE 90, 86, 91, 87
	.BYTE 91, 87, 92, 86
	.BYTE 92, 86, 93, 85
	.BYTE 93, 85, 94, 84
	.BYTE 94, 84, 95, 82
	.BYTE 95, 82, 96, 80
	.BYTE 96, 80, 96, 79
	.BYTE 96, 79, 97, 77
	.BYTE 97, 77, 98, 77
	.BYTE 98, 77, 100, 77
	.BYTE 100, 77, 101, 78
	.BYTE 101, 78, 101, 80
	.BYTE 101, 80, 100, 85
	.BYTE 100, 85, 100, 86
	.BYTE 100, 86, 101, 87
	.BYTE 101, 87, 102, 86
	.BYTE 102, 86, 103, 86
	.BYTE 103, 86, 104, 84
	.BYTE 104, 84, 104, 82
	.BYTE 104, 82, 105, 80
	.BYTE 105, 80, 106, 81
	.BYTE 106, 81, 106, 82
	.BYTE 106, 82, 104, 87
	.BYTE 104, 87, 103, 88
	.BYTE 103, 88, 102, 88
	.BYTE 102, 88, 101, 88
	.BYTE 101, 88, 100, 88
	.BYTE 100, 88, 99, 84
	.BYTE 99, 84, 99, 81
	.BYTE 99, 81, 100, 79
	.BYTE 100, 79, 99, 79
	.BYTE 99, 79, 98, 79
	.BYTE 98, 79, 96, 84
	.BYTE 96, 84, 95, 86
	.BYTE 95, 86, 94, 87
	.BYTE 94, 87, 91, 88
	.BYTE 91, 88, 90, 88
	
	; path conference
	.BYTE 148, 96, 147, 94
	.BYTE 147, 94, 147, 89
	.BYTE 147, 89, 148, 86
	.BYTE 148, 86, 147, 87
	.BYTE 147, 87, 146, 88
	.BYTE 146, 88, 145, 88
	.BYTE 145, 88, 142, 87
	.BYTE 142, 87, 142, 86
	.BYTE 142, 86, 142, 82
	.BYTE 142, 82, 142, 79
	.BYTE 142, 79, 141, 80
	.BYTE 141, 80, 139, 84
	.BYTE 139, 84, 138, 86
	.BYTE 138, 86, 138, 88
	.BYTE 138, 88, 137, 88
	.BYTE 137, 88, 136, 88
	.BYTE 136, 88, 134, 88
	.BYTE 134, 88, 133, 88
	.BYTE 133, 88, 132, 88
	.BYTE 132, 88, 130, 88
	.BYTE 130, 88, 128, 88
	.BYTE 128, 88, 127, 87
	.BYTE 127, 87, 126, 86
	.BYTE 126, 86, 126, 83
	.BYTE 126, 83, 126, 82
	.BYTE 126, 82, 126, 83
	.BYTE 126, 83, 123, 86
	.BYTE 123, 86, 121, 87
	.BYTE 121, 87, 120, 87
	.BYTE 120, 87, 118, 87
	.BYTE 118, 87, 116, 87
	.BYTE 116, 87, 115, 86
	.BYTE 115, 86, 114, 84
	.BYTE 114, 84, 113, 83
	.BYTE 113, 83, 113, 80
	.BYTE 113, 80, 114, 75
	.BYTE 114, 75, 114, 73
	.BYTE 114, 73, 116, 71
	.BYTE 116, 71, 117, 69
	.BYTE 117, 69, 120, 67
	.BYTE 120, 67, 122, 67
	.BYTE 122, 67, 123, 68
	.BYTE 123, 68, 123, 70
	.BYTE 123, 70, 124, 73
	.BYTE 124, 73, 123, 77
	.BYTE 123, 77, 122, 77
	.BYTE 122, 77, 122, 75
	.BYTE 122, 75, 122, 72
	.BYTE 122, 72, 122, 70
	.BYTE 122, 70, 121, 69
	.BYTE 121, 69, 120, 69
	.BYTE 120, 69, 119, 69
	.BYTE 119, 69, 118, 70
	.BYTE 118, 70, 117, 72
	.BYTE 117, 72, 115, 74
	.BYTE 115, 74, 115, 77
	.BYTE 115, 77, 114, 79
	.BYTE 114, 79, 114, 81
	.BYTE 114, 81, 115, 83
	.BYTE 115, 83, 116, 85
	.BYTE 116, 85, 117, 85
	.BYTE 117, 85, 118, 86
	.BYTE 118, 86, 119, 86
	.BYTE 119, 86, 121, 85
	.BYTE 121, 85, 122, 84
	.BYTE 122, 84, 125, 81
	.BYTE 125, 81, 126, 81
	.BYTE 126, 81, 127, 81
	.BYTE 127, 81, 127, 80
	.BYTE 127, 80, 128, 79
	.BYTE 128, 79, 129, 77
	.BYTE 129, 77, 131, 77
	.BYTE 131, 77, 132, 77
	.BYTE 132, 77, 133, 78
	.BYTE 133, 78, 134, 83
	.BYTE 134, 83, 134, 85
	.BYTE 134, 85, 134, 86
	.BYTE 134, 86, 134, 87
	.BYTE 134, 87, 135, 87
	.BYTE 135, 87, 136, 85
	.BYTE 136, 85, 137, 84
	.BYTE 137, 84, 137, 81
	.BYTE 137, 81, 138, 78
	.BYTE 138, 78, 139, 78
	.BYTE 139, 78, 139, 79
	.BYTE 139, 79, 139, 80
	.BYTE 139, 80, 139, 79
	.BYTE 139, 79, 141, 77
	.BYTE 141, 77, 143, 78
	.BYTE 143, 78, 144, 79
	.BYTE 144, 79, 144, 82
	.BYTE 144, 82, 144, 86
	.BYTE 144, 86, 145, 87
	.BYTE 145, 87, 146, 86
	.BYTE 146, 86, 148, 83
	.BYTE 148, 83, 149, 80
	.BYTE 149, 80, 150, 78
	.BYTE 150, 78, 151, 72
	.BYTE 151, 72, 152, 71
	.BYTE 152, 71, 153, 71
	.BYTE 153, 71, 154, 70
	.BYTE 154, 70, 154, 71
	.BYTE 154, 71, 155, 71
	.BYTE 155, 71, 155, 74
	.BYTE 155, 74, 155, 76
	.BYTE 155, 76, 154, 79
	.BYTE 154, 79, 152, 84
	.BYTE 152, 84, 151, 84
	.BYTE 151, 84, 152, 84
	.BYTE 152, 84, 154, 83
	.BYTE 154, 83, 156, 82
	.BYTE 156, 82, 157, 80
	.BYTE 157, 80, 159, 78
	.BYTE 159, 78, 161, 77
	.BYTE 161, 77, 162, 77
	.BYTE 162, 77, 163, 77
	.BYTE 163, 77, 163, 78
	.BYTE 163, 78, 163, 80
	.BYTE 163, 80, 163, 82
	.BYTE 163, 82, 162, 83
	.BYTE 162, 83, 159, 85
	.BYTE 159, 85, 158, 85
	.BYTE 158, 85, 159, 86
	.BYTE 159, 86, 161, 87
	.BYTE 161, 87, 162, 86
	.BYTE 162, 86, 163, 86
	.BYTE 163, 86, 164, 84
	.BYTE 164, 84, 165, 82
	.BYTE 165, 82, 165, 80
	.BYTE 165, 80, 166, 78
	.BYTE 166, 78, 166, 77
	.BYTE 166, 77, 168, 77
	.BYTE 168, 77, 170, 77
	.BYTE 170, 77, 171, 78
	.BYTE 171, 78, 171, 81
	.BYTE 171, 81, 170, 85
	.BYTE 170, 85, 170, 86
	.BYTE 170, 86, 171, 86
	.BYTE 171, 86, 172, 86
	.BYTE 172, 86, 173, 84
	.BYTE 173, 84, 174, 82
	.BYTE 174, 82, 174, 80
	.BYTE 174, 80, 175, 79
	.BYTE 175, 79, 176, 78
	.BYTE 176, 78, 177, 77
	.BYTE 177, 77, 178, 77
	.BYTE 178, 77, 179, 77
	.BYTE 179, 77, 180, 78
	.BYTE 180, 78, 180, 81
	.BYTE 180, 81, 178, 84
	.BYTE 178, 84, 177, 84
	.BYTE 177, 84, 176, 85
	.BYTE 176, 85, 175, 85
	.BYTE 175, 85, 176, 86
	.BYTE 176, 86, 178, 87
	.BYTE 178, 87, 179, 86
	.BYTE 179, 86, 181, 85
	.BYTE 181, 85, 181, 83
	.BYTE 181, 83, 182, 80
	.BYTE 182, 80, 182, 78
	.BYTE 182, 78, 184, 78
	.BYTE 184, 78, 184, 79
	.BYTE 184, 79, 186, 78
	.BYTE 186, 78, 187, 77
	.BYTE 187, 77, 188, 78
	.BYTE 188, 78, 189, 82
	.BYTE 189, 82, 189, 86
	.BYTE 189, 86, 189, 87
	.BYTE 189, 87, 190, 87
	.BYTE 190, 87, 191, 86
	.BYTE 191, 86, 193, 83
	.BYTE 193, 83, 193, 81
	.BYTE 193, 81, 194, 80
	.BYTE 194, 80, 195, 79
	.BYTE 195, 79, 197, 77
	.BYTE 197, 77, 198, 77
	.BYTE 198, 77, 199, 77
	.BYTE 199, 77, 200, 78
	.BYTE 200, 78, 200, 80
	.BYTE 200, 80, 200, 81
	.BYTE 200, 81, 199, 81
	.BYTE 199, 81, 198, 80
	.BYTE 198, 80, 198, 79
	.BYTE 198, 79, 196, 81
	.BYTE 196, 81, 195, 82
	.BYTE 195, 82, 195, 84
	.BYTE 195, 84, 195, 85
	.BYTE 195, 85, 196, 86
	.BYTE 196, 86, 197, 86
	.BYTE 197, 86, 199, 86
	.BYTE 199, 86, 200, 85
	.BYTE 200, 85, 202, 81
	.BYTE 202, 81, 204, 78
	.BYTE 204, 78, 204, 77
	.BYTE 204, 77, 205, 77
	.BYTE 205, 77, 206, 77
	.BYTE 206, 77, 207, 77
	.BYTE 207, 77, 208, 78
	.BYTE 208, 78, 208, 80
	.BYTE 208, 80, 208, 82
	.BYTE 208, 82, 207, 83
	.BYTE 207, 83, 206, 84
	.BYTE 206, 84, 204, 85
	.BYTE 204, 85, 203, 84
	.BYTE 203, 84, 203, 85
	.BYTE 203, 85, 204, 86
	.BYTE 204, 86, 205, 87
	.BYTE 205, 87, 207, 86
	.BYTE 207, 86, 208, 86
	.BYTE 208, 86, 209, 84
	.BYTE 209, 84, 210, 82
	.BYTE 210, 82, 210, 80
	.BYTE 210, 80, 211, 80
	.BYTE 211, 80, 212, 81
	.BYTE 212, 81, 210, 85
	.BYTE 210, 85, 209, 87
	.BYTE 209, 87, 208, 88
	.BYTE 208, 88, 206, 88
	.BYTE 206, 88, 204, 88
	.BYTE 204, 88, 203, 88
	.BYTE 203, 88, 202, 86
	.BYTE 202, 86, 202, 85
	.BYTE 202, 85, 201, 86
	.BYTE 201, 86, 200, 87
	.BYTE 200, 87, 199, 88
	.BYTE 199, 88, 197, 88
	.BYTE 197, 88, 195, 87
	.BYTE 195, 87, 194, 86
	.BYTE 194, 86, 193, 85
	.BYTE 193, 85, 193, 86
	.BYTE 193, 86, 192, 87
	.BYTE 192, 87, 191, 88
	.BYTE 191, 88, 189, 88
	.BYTE 189, 88, 188, 88
	.BYTE 188, 88, 187, 86
	.BYTE 187, 86, 187, 82
	.BYTE 187, 82, 187, 79
	.BYTE 187, 79, 186, 79
	.BYTE 186, 79, 184, 83
	.BYTE 184, 83, 183, 86
	.BYTE 183, 86, 183, 87
	.BYTE 183, 87, 182, 88
	.BYTE 182, 88, 181, 87
	.BYTE 181, 87, 180, 88
	.BYTE 180, 88, 178, 88
	.BYTE 178, 88, 175, 88
	.BYTE 175, 88, 174, 87
	.BYTE 174, 87, 174, 86
	.BYTE 174, 86, 174, 87
	.BYTE 174, 87, 172, 88
	.BYTE 172, 88, 170, 88
	.BYTE 170, 88, 169, 88
	.BYTE 169, 88, 168, 87
	.BYTE 168, 87, 168, 85
	.BYTE 168, 85, 168, 84
	.BYTE 168, 84, 169, 81
	.BYTE 169, 81, 169, 79
	.BYTE 169, 79, 168, 79
	.BYTE 168, 79, 167, 79
	.BYTE 167, 79, 165, 85
	.BYTE 165, 85, 162, 88
	.BYTE 162, 88, 159, 88
	.BYTE 159, 88, 158, 88
	.BYTE 158, 88, 158, 87
	.BYTE 158, 87, 157, 86
	.BYTE 157, 86, 157, 85
	.BYTE 157, 85, 156, 84
	.BYTE 156, 84, 152, 86
	.BYTE 152, 86, 151, 86
	.BYTE 151, 86, 152, 87
	.BYTE 152, 87, 152, 89
	.BYTE 152, 89, 151, 94
	.BYTE 151, 94, 151, 95
	.BYTE 151, 95, 150, 96
	.BYTE 150, 96, 148, 96
	; path hacker
	.BYTE 80, 75, 82, 71
	.BYTE 82, 71, 81, 70
	.BYTE 81, 70, 80, 71
	.BYTE 80, 71, 80, 75
	.BYTE 80, 75, 80, 76
	.BYTE 80, 76, 80, 75
	; path hacker
	.BYTE 47, 80, 47, 76
	.BYTE 47, 76, 46, 76
	.BYTE 46, 76, 45, 76
	.BYTE 45, 76, 44, 77
	.BYTE 44, 77, 44, 78
	.BYTE 44, 78, 45, 79
	.BYTE 45, 79, 47, 80
	; path hacker
	.BYTE 54, 82, 52, 78
	.BYTE 52, 78, 50, 77
	.BYTE 50, 77, 49, 76
	.BYTE 49, 76, 49, 77
	.BYTE 49, 77, 48, 81
	.BYTE 48, 81, 49, 81
	.BYTE 49, 81, 53, 82
	.BYTE 53, 82, 54, 82
	; path hacker
	.BYTE 90, 83, 91, 82
	.BYTE 91, 82, 92, 81
	.BYTE 92, 81, 92, 80
	.BYTE 92, 80, 92, 79
	.BYTE 92, 79, 91, 79
	.BYTE 91, 79, 90, 79
	.BYTE 90, 79, 89, 81
	.BYTE 89, 81, 89, 83
	.BYTE 89, 83, 90, 83
	; path hacker
	.BYTE 82, 82, 83, 81
	.BYTE 83, 81, 84, 80
	.BYTE 84, 80, 83, 79
	.BYTE 83, 79, 82, 79
	.BYTE 82, 79, 81, 80
	.BYTE 81, 80, 80, 81
	.BYTE 80, 81, 80, 82
	.BYTE 80, 82, 80, 83
	.BYTE 80, 83, 82, 82
	; path hacker
	.BYTE 61, 86, 62, 85
	.BYTE 62, 85, 63, 83
	.BYTE 63, 83, 64, 79
	.BYTE 64, 79, 62, 79
	.BYTE 62, 79, 61, 79
	.BYTE 61, 79, 60, 82
	.BYTE 60, 82, 60, 84
	.BYTE 60, 84, 60, 86
	.BYTE 60, 86, 61, 86
	
	; path conference
	.BYTE 152, 81, 152, 79
	.BYTE 152, 79, 154, 75
	.BYTE 154, 75, 154, 73
	.BYTE 154, 73, 154, 72
	.BYTE 154, 72, 153, 73
	.BYTE 153, 73, 151, 77
	.BYTE 151, 77, 150, 83
	.BYTE 150, 83, 152, 81
	; path conference
	.BYTE 205, 83, 206, 82
	.BYTE 206, 82, 207, 80
	.BYTE 207, 80, 206, 79
	.BYTE 206, 79, 205, 79
	.BYTE 205, 79, 203, 81
	.BYTE 203, 81, 203, 83
	.BYTE 203, 83, 204, 83
	.BYTE 204, 83, 205, 83
	; path conference
	.BYTE 177, 83, 178, 82
	.BYTE 178, 82, 179, 80
	.BYTE 179, 80, 179, 79
	.BYTE 179, 79, 178, 79
	.BYTE 178, 79, 177, 79
	.BYTE 177, 79, 176, 80
	.BYTE 176, 80, 176, 82
	.BYTE 176, 82, 175, 82
	.BYTE 175, 82, 176, 83
	.BYTE 176, 83, 177, 83
	; path conference
	.BYTE 160, 83, 161, 81
	.BYTE 161, 81, 162, 80
	.BYTE 162, 80, 162, 79
	.BYTE 162, 79, 161, 79
	.BYTE 161, 79, 160, 79
	.BYTE 160, 79, 159, 80
	.BYTE 159, 80, 158, 82
	.BYTE 158, 82, 158, 83
	.BYTE 158, 83, 159, 83
	.BYTE 159, 83, 160, 83
	; path conference
	.BYTE 133, 84, 133, 82
	.BYTE 133, 82, 132, 79
	.BYTE 132, 79, 131, 79
	.BYTE 131, 79, 130, 81
	.BYTE 130, 81, 131, 83
	.BYTE 131, 83, 132, 85
	.BYTE 132, 85, 133, 84
	; path conference
	.BYTE 130, 87, 131, 87
	.BYTE 131, 87, 130, 86
	.BYTE 130, 86, 130, 85
	.BYTE 130, 85, 129, 82
	.BYTE 129, 82, 129, 81
	.BYTE 129, 81, 128, 81
	.BYTE 128, 81, 128, 85
	.BYTE 128, 85, 128, 87
	.BYTE 128, 87, 130, 87
	; path conference
	.BYTE 149, 94, 150, 91
	.BYTE 150, 91, 150, 87
	.BYTE 150, 87, 150, 86
	.BYTE 150, 86, 149, 87
	.BYTE 149, 87, 149, 93
	.BYTE 149, 93, 149, 94
	
	; path &
	.BYTE 128, 102, 128, 101
	.BYTE 128, 101, 128, 100
	.BYTE 128, 100, 128, 99
	.BYTE 128, 99, 127, 100
	.BYTE 127, 100, 126, 100
	.BYTE 126, 100, 126, 102
	.BYTE 126, 102, 126, 104
	.BYTE 126, 104, 127, 103
	.BYTE 127, 103, 128, 102
	; path &
	.BYTE 128, 111, 129, 111
	.BYTE 129, 111, 128, 110
	.BYTE 128, 110, 126, 108
	.BYTE 126, 108, 126, 107
	.BYTE 126, 107, 124, 110
	.BYTE 124, 110, 123, 111
	.BYTE 123, 111, 124, 112
	.BYTE 124, 112, 128, 111
	; path &
	.BYTE 132, 114, 131, 113
	.BYTE 131, 113, 130, 112
	.BYTE 130, 112, 129, 113
	.BYTE 129, 113, 127, 113
	.BYTE 127, 113, 126, 114
	.BYTE 126, 114, 124, 113
	.BYTE 124, 113, 122, 112
	.BYTE 122, 112, 122, 111
	.BYTE 122, 111, 122, 110
	.BYTE 122, 110, 123, 108
	.BYTE 123, 108, 124, 107
	.BYTE 124, 107, 125, 105
	.BYTE 125, 105, 124, 103
	.BYTE 124, 103, 125, 99
	.BYTE 125, 99, 126, 98
	.BYTE 126, 98, 127, 98
	.BYTE 127, 98, 129, 98
	.BYTE 129, 98, 130, 100
	.BYTE 130, 100, 130, 102
	.BYTE 130, 102, 128, 104
	.BYTE 128, 104, 127, 106
	.BYTE 127, 106, 128, 107
	.BYTE 128, 107, 129, 109
	.BYTE 129, 109, 130, 110
	.BYTE 130, 110, 131, 110
	.BYTE 131, 110, 132, 109
	.BYTE 132, 109, 133, 108
	.BYTE 133, 108, 134, 108
	.BYTE 134, 108, 134, 109
	.BYTE 134, 109, 133, 110
	.BYTE 133, 110, 132, 111
	.BYTE 132, 111, 133, 112
	.BYTE 133, 112, 134, 113
	.BYTE 134, 113, 134, 114
	.BYTE 134, 114, 133, 114
	.BYTE 133, 114, 132, 114
	; path D
	.BYTE 83, 137, 83, 136
	.BYTE 83, 136, 82, 135
	.BYTE 82, 135, 81, 133
	.BYTE 81, 133, 82, 132
	.BYTE 82, 132, 83, 131
	.BYTE 83, 131, 84, 130
	.BYTE 84, 130, 85, 122
	.BYTE 85, 122, 86, 118
	.BYTE 86, 118, 85, 118
	.BYTE 85, 118, 84, 118
	.BYTE 84, 118, 83, 117
	.BYTE 83, 117, 84, 117
	.BYTE 84, 117, 85, 116
	.BYTE 85, 116, 86, 116
	.BYTE 86, 116, 87, 115
	.BYTE 87, 115, 88, 115
	.BYTE 88, 115, 88, 116
	.BYTE 88, 116, 89, 117
	.BYTE 89, 117, 91, 117
	.BYTE 91, 117, 92, 118
	.BYTE 92, 118, 94, 120
	.BYTE 94, 120, 96, 122
	.BYTE 96, 122, 97, 123
	.BYTE 97, 123, 97, 126
	.BYTE 97, 126, 97, 128
	.BYTE 97, 128, 95, 132
	.BYTE 95, 132, 94, 133
	.BYTE 94, 133, 95, 134
	.BYTE 95, 134, 96, 136
	.BYTE 96, 136, 95, 136
	.BYTE 95, 136, 94, 135
	.BYTE 94, 135, 93, 134
	.BYTE 93, 134, 92, 134
	.BYTE 92, 134, 90, 135
	.BYTE 90, 135, 85, 136
	.BYTE 85, 136, 84, 137
	.BYTE 84, 137, 83, 137
	; path emoparty
	.BYTE 133, 146, 133, 141
	.BYTE 133, 141, 133, 137
	.BYTE 133, 137, 132, 137
	.BYTE 132, 137, 131, 137
	.BYTE 131, 137, 130, 138
	.BYTE 130, 138, 129, 137
	.BYTE 129, 137, 128, 137
	.BYTE 128, 137, 127, 137
	.BYTE 127, 137, 126, 138
	.BYTE 126, 138, 124, 137
	.BYTE 124, 137, 123, 137
	.BYTE 123, 137, 122, 136
	.BYTE 122, 136, 122, 135
	.BYTE 122, 135, 121, 136
	.BYTE 121, 136, 120, 137
	.BYTE 120, 137, 119, 137
	.BYTE 119, 137, 117, 136
	.BYTE 117, 136, 117, 135
	.BYTE 117, 135, 117, 131
	.BYTE 117, 131, 116, 128
	.BYTE 116, 128, 115, 128
	.BYTE 115, 128, 114, 130
	.BYTE 114, 130, 113, 135
	.BYTE 113, 135, 112, 136
	.BYTE 112, 136, 111, 136
	.BYTE 111, 136, 111, 134
	.BYTE 111, 134, 111, 128
	.BYTE 111, 128, 110, 128
	.BYTE 110, 128, 109, 129
	.BYTE 109, 129, 108, 130
	.BYTE 108, 130, 107, 134
	.BYTE 107, 134, 107, 137
	.BYTE 107, 137, 106, 137
	.BYTE 106, 137, 106, 136
	.BYTE 106, 136, 105, 136
	.BYTE 105, 136, 104, 137
	.BYTE 104, 137, 102, 137
	.BYTE 102, 137, 99, 137
	.BYTE 99, 137, 99, 136
	.BYTE 99, 136, 98, 135
	.BYTE 98, 135, 98, 133
	.BYTE 98, 133, 98, 131
	.BYTE 98, 131, 99, 129
	.BYTE 99, 129, 100, 127
	.BYTE 100, 127, 102, 126
	.BYTE 102, 126, 104, 127
	.BYTE 104, 127, 105, 128
	.BYTE 105, 128, 105, 129
	.BYTE 105, 129, 104, 131
	.BYTE 104, 131, 103, 132
	.BYTE 103, 132, 102, 133
	.BYTE 102, 133, 100, 134
	.BYTE 100, 134, 99, 134
	.BYTE 99, 134, 100, 135
	.BYTE 100, 135, 100, 136
	.BYTE 100, 136, 102, 136
	.BYTE 102, 136, 103, 136
	.BYTE 103, 136, 104, 135
	.BYTE 104, 135, 105, 133
	.BYTE 105, 133, 106, 129
	.BYTE 106, 129, 107, 128
	.BYTE 107, 128, 107, 127
	.BYTE 107, 127, 108, 127
	.BYTE 108, 127, 110, 126
	.BYTE 110, 126, 112, 127
	.BYTE 112, 127, 113, 128
	.BYTE 113, 128, 113, 129
	.BYTE 113, 129, 113, 128
	.BYTE 113, 128, 115, 127
	.BYTE 115, 127, 117, 126
	.BYTE 117, 126, 118, 128
	.BYTE 118, 128, 118, 132
	.BYTE 118, 132, 118, 135
	.BYTE 118, 135, 119, 136
	.BYTE 119, 136, 122, 133
	.BYTE 122, 133, 122, 132
	.BYTE 122, 132, 123, 130
	.BYTE 123, 130, 124, 128
	.BYTE 124, 128, 125, 127
	.BYTE 125, 127, 127, 126
	.BYTE 127, 126, 128, 126
	.BYTE 128, 126, 129, 127
	.BYTE 129, 127, 130, 128
	.BYTE 130, 128, 130, 132
	.BYTE 130, 132, 130, 135
	.BYTE 130, 135, 129, 136
	.BYTE 129, 136, 130, 136
	.BYTE 130, 136, 131, 136
	.BYTE 131, 136, 132, 135
	.BYTE 132, 135, 133, 134
	.BYTE 133, 134, 133, 130
	.BYTE 133, 130, 133, 127
	.BYTE 133, 127, 134, 127
	.BYTE 134, 127, 135, 127
	.BYTE 135, 127, 137, 126
	.BYTE 137, 126, 138, 126
	.BYTE 138, 126, 139, 126
	.BYTE 139, 126, 140, 127
	.BYTE 140, 127, 141, 130
	.BYTE 141, 130, 141, 132
	.BYTE 141, 132, 141, 134
	.BYTE 141, 134, 141, 135
	.BYTE 141, 135, 142, 134
	.BYTE 142, 134, 143, 131
	.BYTE 143, 131, 144, 129
	.BYTE 144, 129, 145, 127
	.BYTE 145, 127, 146, 126
	.BYTE 146, 126, 149, 126
	.BYTE 149, 126, 150, 128
	.BYTE 150, 128, 151, 128
	.BYTE 151, 128, 151, 130
	.BYTE 151, 130, 150, 132
	.BYTE 150, 132, 150, 134
	.BYTE 150, 134, 151, 135
	.BYTE 151, 135, 152, 136
	.BYTE 152, 136, 153, 135
	.BYTE 153, 135, 153, 134
	.BYTE 153, 134, 156, 128
	.BYTE 156, 128, 156, 126
	.BYTE 156, 126, 158, 126
	.BYTE 158, 126, 160, 126
	.BYTE 160, 126, 161, 127
	.BYTE 161, 127, 160, 130
	.BYTE 160, 130, 160, 134
	.BYTE 160, 134, 160, 135
	.BYTE 160, 135, 161, 136
	.BYTE 161, 136, 162, 136
	.BYTE 162, 136, 162, 134
	.BYTE 162, 134, 164, 129
	.BYTE 164, 129, 164, 127
	.BYTE 164, 127, 165, 126
	.BYTE 165, 126, 164, 126
	.BYTE 164, 126, 163, 125
	.BYTE 163, 125, 162, 125
	.BYTE 162, 125, 162, 124
	.BYTE 162, 124, 164, 124
	.BYTE 164, 124, 165, 124
	.BYTE 165, 124, 165, 123
	.BYTE 165, 123, 166, 120
	.BYTE 166, 120, 167, 118
	.BYTE 167, 118, 168, 119
	.BYTE 168, 119, 167, 121
	.BYTE 167, 121, 167, 124
	.BYTE 167, 124, 168, 124
	.BYTE 168, 124, 169, 124
	.BYTE 169, 124, 170, 125
	.BYTE 170, 125, 169, 125
	.BYTE 169, 125, 168, 126
	.BYTE 168, 126, 166, 126
	.BYTE 166, 126, 166, 134
	.BYTE 166, 134, 166, 135
	.BYTE 166, 135, 167, 136
	.BYTE 167, 136, 169, 134
	.BYTE 169, 134, 170, 132
	.BYTE 170, 132, 170, 129
	.BYTE 170, 129, 171, 127
	.BYTE 171, 127, 172, 127
	.BYTE 172, 127, 172, 128
	.BYTE 172, 128, 172, 130
	.BYTE 172, 130, 172, 134
	.BYTE 172, 134, 172, 136
	.BYTE 172, 136, 173, 136
	.BYTE 173, 136, 176, 129
	.BYTE 176, 129, 176, 127
	.BYTE 176, 127, 177, 127
	.BYTE 177, 127, 178, 127
	.BYTE 178, 127, 178, 131
	.BYTE 178, 131, 178, 136
	.BYTE 178, 136, 178, 135
	.BYTE 178, 135, 180, 130
	.BYTE 180, 130, 181, 129
	.BYTE 181, 129, 182, 130
	.BYTE 182, 130, 181, 135
	.BYTE 181, 135, 179, 137
	.BYTE 179, 137, 178, 138
	.BYTE 178, 138, 177, 139
	.BYTE 177, 139, 176, 143
	.BYTE 176, 143, 176, 144
	.BYTE 176, 144, 175, 145
	.BYTE 175, 145, 174, 145
	.BYTE 174, 145, 173, 145
	.BYTE 173, 145, 172, 144
	.BYTE 172, 144, 172, 143
	.BYTE 172, 143, 172, 142
	.BYTE 172, 142, 172, 141
	.BYTE 172, 141, 173, 139
	.BYTE 173, 139, 175, 138
	.BYTE 175, 138, 176, 137
	.BYTE 176, 137, 176, 136
	.BYTE 176, 136, 176, 134
	.BYTE 176, 134, 175, 136
	.BYTE 175, 136, 174, 137
	.BYTE 174, 137, 173, 138
	.BYTE 173, 138, 172, 138
	.BYTE 172, 138, 171, 137
	.BYTE 171, 137, 170, 136
	.BYTE 170, 136, 169, 137
	.BYTE 169, 137, 167, 138
	.BYTE 167, 138, 166, 137
	.BYTE 166, 137, 165, 137
	.BYTE 165, 137, 165, 136
	.BYTE 165, 136, 164, 135
	.BYTE 164, 135, 164, 136
	.BYTE 164, 136, 163, 137
	.BYTE 163, 137, 161, 138
	.BYTE 161, 138, 160, 137
	.BYTE 160, 137, 159, 137
	.BYTE 159, 137, 158, 136
	.BYTE 158, 136, 158, 134
	.BYTE 158, 134, 159, 130
	.BYTE 159, 130, 159, 128
	.BYTE 159, 128, 158, 128
	.BYTE 158, 128, 157, 128
	.BYTE 157, 128, 155, 135
	.BYTE 155, 135, 153, 137
	.BYTE 153, 137, 152, 137
	.BYTE 152, 137, 150, 136
	.BYTE 150, 136, 149, 135
	.BYTE 149, 135, 148, 136
	.BYTE 148, 136, 146, 137
	.BYTE 146, 137, 145, 137
	.BYTE 145, 137, 143, 135
	.BYTE 143, 135, 139, 137
	.BYTE 139, 137, 137, 137
	.BYTE 137, 137, 135, 137
	.BYTE 135, 137, 134, 137
	.BYTE 134, 137, 134, 141
	.BYTE 134, 141, 134, 146
	.BYTE 134, 146, 133, 147
	.BYTE 133, 147, 133, 146
	
	; path D
	.BYTE 94, 131, 95, 129
	.BYTE 95, 129, 96, 128
	.BYTE 96, 128, 96, 126
	.BYTE 96, 126, 95, 124
	.BYTE 95, 124, 95, 122
	.BYTE 95, 122, 93, 121
	.BYTE 93, 121, 92, 119
	.BYTE 92, 119, 90, 118
	.BYTE 90, 118, 88, 118
	.BYTE 88, 118, 87, 120
	.BYTE 87, 120, 86, 126
	.BYTE 86, 126, 86, 130
	.BYTE 86, 130, 90, 131
	.BYTE 90, 131, 92, 132
	.BYTE 92, 132, 93, 132
	.BYTE 93, 132, 94, 131
	; path D
	.BYTE 83, 134, 83, 133
	.BYTE 83, 133, 82, 133
	.BYTE 82, 133, 83, 134
	; path D
	.BYTE 88, 134, 91, 133
	.BYTE 91, 133, 89, 132
	.BYTE 89, 132, 86, 132
	.BYTE 86, 132, 85, 132
	.BYTE 85, 132, 85, 133
	.BYTE 85, 133, 85, 134
	.BYTE 85, 134, 86, 134
	.BYTE 86, 134, 88, 134
	
	; path emoparty
	.BYTE 101, 132, 102, 131
	.BYTE 102, 131, 103, 129
	.BYTE 103, 129, 103, 128
	.BYTE 103, 128, 102, 128
	.BYTE 102, 128, 101, 128
	.BYTE 101, 128, 100, 129
	.BYTE 100, 129, 100, 131
	.BYTE 100, 131, 99, 132
	.BYTE 99, 132, 100, 132
	.BYTE 100, 132, 101, 132
	; path emoparty
	.BYTE 128, 134, 129, 131
	.BYTE 129, 131, 128, 129
	.BYTE 128, 129, 128, 128
	.BYTE 128, 128, 127, 129
	.BYTE 127, 129, 126, 131
	.BYTE 126, 131, 127, 132
	.BYTE 127, 132, 128, 135
	.BYTE 128, 135, 128, 134
	; path emoparty
	.BYTE 138, 135, 139, 134
	.BYTE 139, 134, 140, 133
	.BYTE 140, 133, 140, 132
	.BYTE 140, 132, 139, 129
	.BYTE 139, 129, 139, 128
	.BYTE 139, 128, 138, 128
	.BYTE 138, 128, 137, 128
	.BYTE 137, 128, 136, 130
	.BYTE 136, 130, 134, 134
	.BYTE 134, 134, 135, 135
	.BYTE 135, 135, 136, 135
	.BYTE 136, 135, 138, 135
	; path emoparty
	.BYTE 147, 135, 148, 133
	.BYTE 148, 133, 149, 131
	.BYTE 149, 131, 149, 129
	.BYTE 149, 129, 149, 128
	.BYTE 149, 128, 148, 128
	.BYTE 148, 128, 147, 128
	.BYTE 147, 128, 146, 130
	.BYTE 146, 130, 145, 132
	.BYTE 145, 132, 145, 133
	.BYTE 145, 133, 145, 135
	.BYTE 145, 135, 146, 136
	.BYTE 146, 136, 147, 135
	; path emoparty
	.BYTE 126, 136, 127, 136
	.BYTE 127, 136, 126, 135
	.BYTE 126, 135, 125, 133
	.BYTE 125, 133, 125, 132
	.BYTE 125, 132, 125, 131
	.BYTE 125, 131, 124, 131
	.BYTE 124, 131, 124, 132
	.BYTE 124, 132, 124, 134
	.BYTE 124, 134, 124, 136
	.BYTE 124, 136, 126, 136
	; path emoparty
	.BYTE 174, 143, 175, 142
	.BYTE 175, 142, 176, 139
	.BYTE 176, 139, 174, 141
	.BYTE 174, 141, 173, 142
	.BYTE 173, 142, 173, 143
	.BYTE 173, 143, 174, 143
	
	.BYTE 0


starfield_array:
	BYTE 5,20,70,0
	BYTE 4,20,74,0
	BYTE 6,20,77,0
	BYTE 5,20,84,0
	BYTE 0,0,0,0 ; [speed] [x] [y] [prev contents]

player_n_shapes_end:



  EMPTYTAP "undefined_rocks_code.tap"
  SAVETAP "undefined_rocks_code.tap",CODE,"usr40960",code_start,code_end - code_start,code_start
  SAVETAP "undefined_rocks_code.tap",CODE,"ptsplay",player,player_n_shapes_end - player, player
  
  ; basic loader will be concatenated later by make.sh script

	; debug messages to the console of compiler
	DISPLAY "variables free space before $a000: ", /A, $a000 - assembled_sequence_end
	DISPLAY "variables free space on page 4: ", /A, $ffff - shedule_c000_end
	DISPLAY "free space before $c000: ", /A, $c000 - code_end
	DISPLAY "free space before $ffff: ", /A, $ffff - player_n_shapes_end
	IF code_end < $c000
	; DISPLAY "boundary test succeed"
	ELSE
	DISPLAY "*** WARNING the boundary test failed, too much code ***"
	ENDIF

