return function(R)
    R.RGB={}

    -- r,g,b are 0..1
    function R.RGB:new(r,g,b)
		local o={r=r,g=g,b=b}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    -- Returns a new RGB
    -- t: 0 is all of self, 1 is all of toRgb
    function R.RGB:getBlendTo(toRgb,t)
		local tInv=1-t
        return R.RGB:new(
            self.r*tInv+toRgb.r*t,
            self.g*tInv+toRgb.g*t,
            self.b*tInv+toRgb.b*t
        )
	end

    -- index: 0..15
    R.setRGB=function(i,rgb)
        local a=0x3FC0+i*3
        poke(a,(rgb.r*255)//1)
        poke(a+1,(rgb.g*255)//1)
        poke(a+2,(rgb.b*255)//1)
    end

    -- For getting existing colours (to blend)
    R.getRGB=function(i)
        local a=0x3FC0+i*3
        return R.RGB:new(
            peek(a)/255,
            peek(a+1)/255,
            peek(a+2)/255
        )
    end
end