return function(R)
    R.clamp=function(v,min,max)
        return math.min(math.max(v,min),max)
    end

    R.lerp=function(t,v0,v1)
        return (1-t)*v0+t*v1
    end

    -- quadratic Bézier
    R.qBezier=function(t,v0,v1,v2)
        local tInv=1-t
        return (tInv*tInv*v0)+(tInv*t*v1)+(t*t*v2)
    end

    -- cubic Bézier
    R.cBezier=function(t,v0,v1,v2,v3)
        local tInv=1-t
        return (tInv*tInv*tInv*v0)+(3*tInv*tInv*t*v1)+(3*tInv*t*t*v2)+(t*t*t*v3)
    end

    -- smoothstep Easing function
    R.smoothStep=function(t,e0,e1)
        local s = (t-e0)/(e1-e0)
        local x = R.clamp(s,0,1)
        return e0 + (x * x * (3.0 - 2.0 * x))*(e1-e0)
    end

    -- smootherstep Easing function
    R.smootherStep=function(t,e0,e1)
        local s = (t-e0)/(e1-e0)
        local x = R.clamp(s,0,1)
        return e0 + (x * x * x * (3.0 * x * (2.0 * x - 5.0) + 10.0))*(e1-e0)
    end
end