return function(R)
    R.music={}

    R.music.getPos=function()
        return {
            track=peek(0x13FFc),
            pattern=peek(0x13FFd),
            row=peek(0x13ffe),
        }
    end

    R.music.getTrackMeta=function(track)
        local a=0x13E64+51*track+48
        local tempo=peek(a)--/1000 * 60,--150,--peek(a)-106,
        local t1=(peek(a)&128)//128
        if t1 == 1 then
         tempo = 150 + peek(a)&127
        else
         tempo = 150 + tempo
        end
        local rows=64-peek(a+1)
        local speed = 0
        local t2=(peek(a+2)&128)//128
        if t2 == 1 then
         speed = 6 + peek(a+2)&127
        else
         speed = 6 + peek(a+2)
        end
        return {
            -- Why is this not 150+, as per docs?! (https://github.com/nesbox/TIC-80/wiki/RAM#music-tracks)
            -- #TODO: Find out how to fix this!
            
            tempo=tempo,--/1000 * 60,--150,--peek(a)-106,
            rows=rows,--64-peek(a+1),
            speed=speed,--6+peek(a+2),
        }
    end

    --[[
    Looks like it's possible to poke track and pattern, when music is running, but not row?
    R.music.setPos=function(track,pattern,row)
        poke(0x13FFc,track)
        poke(0x13FFd,pattern)
        poke(0x13ffe,row)
    end
    --]]
end