return function(R)
    R.Font={}

	function R.Font:new()
        local o={
            -- this could be useful for compression later
            font={},
        }
        setmetatable(o,self)
        self.__index=self
        return o
	end

    function R.Font:load(font)
        if(font.rle) then
            self:_loadRLE(font) 
        else
            self:_loadRAW(font)
        end
    end

    function R.Font:_loadRLE(font)
        local str=font.rle
        local o=tonumber(str:sub(1,5),16) -- get (o)ffset
        local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
        local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
        local d = "" -- (d)ecoded data
        for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
          d = d .. m .. (m:sub(-1):rep(c))  
        end
        local y=0
        for x = 1,#d,1 do -- write to mem
          local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
          poke4(o+y,c) y=y+1
          if y>w then y=0 o=o+1024 end
        end
        self:_init(font)
    end

    function R.Font:_loadRAW(font)
        local str=font.raw
        local tnb=tonumber
        local o=tnb(str:sub(1,5),16) -- get (o)ffset
        local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
        local d=str:sub(8,str:len()) -- remove header to get (d)ata
        local y=0
        for x = 1,#d,1 do -- write to mem
          local c=tnb(d:sub(x,x),16) -- get (c)olor value
          poke4(o+y,c) y=y+1
          if y>w then y=0 o=o+1024 end
        end
        self:_init(font)
    end

    function R.Font:_init(font)
        for i=1,#font.layout do
            self.font[string.sub(font.chars,i,i)]=font.layout[i]
        end
    end

    -- kx kerning (optional): integer
    function R.Font:width(str,kx)
        kx = kx or 1
        local pcx = 0
        for i=1,string.len(str) do
            local letter = self.font[string.sub(str,i,i)]
            -- update kerning
            pcx = pcx + letter[5] + kx
        end
        return pcx
    end

    -- fprint ("text", x, y, [x kerning = 1],[y kerning = 1], [colour = 15])
    function R.Font:print(str,tx,ty,kx,ky,tc)
        kx = kx or 1
        ky = ky or 1
        tc = tc or 10
        local pcx = 0
        local pcy = 0
        -- set to blit segment (8 = BG-1)
        poke4(2*0x03ffc,8)
        -- set colour
        poke4(2*0x03FF0 + 1, tc)
        -- print each letter
        for i=1,string.len(str) do
            local letter = self.font[string.sub(str,i,i)]
            spr(letter[1],tx+pcx,ty+pcy,0,1,0,0,letter[3],letter[4])

            -- update kerning
            pcx = pcx + letter[5] + kx
        end
    end
end
  