-- Keep track of parts within a scene in a demo
return function(R)
    R.Parts={}

    function R.Parts:new()	
        local o={
            parts={},
            totalDuration=0,
        }
        setmetatable(o,self)
        self.__index=self
        return o
    end

    function R.Parts:addPart(id,duration)
        self.parts[#self.parts+1]={id=id,duration=duration}
        self.totalDuration=self.totalDuration+duration
    end

    -- returns id,unit time into part
    function R.Parts:getPart(unitT)
        local tFind=unitT*self.totalDuration
        local tAcc=0
        for i=1,#self.parts do
            local part=self.parts[i]
            local newTAcc=tAcc+part.duration
            if tFind>=tAcc and tFind<newTAcc then
                return part.id,(tFind-tAcc)/part.duration
            end
            tAcc=newTAcc
        end
        return "",0
    end
end
