return function(R)
    R.Menu={}
    R.MenuItemNumber={}
    R.MenuItemSelect={}

    function R.MenuItemNumber:new(min,max,step,start)
        local o={
            min=min or nil,
            max=max or nil,
            step=step or 1,
            start=start or 0,
        }
        o.v=start
        setmetatable(o,self)
        self.__index=self
        return o
    end
    
    -- 2 or 3
    function R.MenuItemNumber:doBtnp(b)
        if b==2 then
            self.v=self.v-self.step
        elseif b==3 then
            self.v=self.v+self.step
        end

        if self.min~=nil then
            self.v=math.max(self.v,self.min)
        end
        if self.max~=nil then
            self.v=math.min(self.v,self.max)
        end

        return self.v
    end

    function R.MenuItemNumber:getValue()
        return self.v
	end

    function R.MenuItemNumber:getText()
        return self.v
	end

    function R.MenuItemSelect:new()
        local o={
            options={},
            iSelected=0,
        }
        setmetatable(o,self)
        self.__index=self
        return o
	end

    function R.MenuItemSelect:add(key,value)
        self.options[#self.options+1]={
            key=key,
            value=value,
        }
        return self
	end

    function R.MenuItemSelect:getValue()
        return self.options[self.iSelected+1].key
    end

    function R.MenuItemSelect:getText()
        if #self.options==0 then
            return "(no options)"
        end
        return self.options[self.iSelected+1].value
	end

    -- 2 or 3
    function R.MenuItemSelect:doBtnp(b)
        if b==2 then
            self.iSelected=(self.iSelected-1)%#self.options
        elseif b==3 then
            self.iSelected=(self.iSelected+1)%#self.options
        end
        return self.options[self.iSelected+1].key
	end

    function R.Menu:new(fnChange)
        local o={
            item=0,
            items={},
            fnChange=fnChange or nil,
        }
        setmetatable(o,self)
        self.__index=self
        return o
	end

    function R.Menu:addItem(key,title,item)
        self.items[#self.items+1]={
            title=title,
            key=key,
            item=item,
        }
    end

    function R.Menu:update()
        local vChange=nil
        if btnp(0) then
            self.item=(self.item-1)%#self.items
        elseif btnp(1) then
            self.item=(self.item+1)%#self.items
        elseif btnp(2) then
            vChange=self.items[self.item+1].item:doBtnp(2)
        elseif btnp(3) then
            vChange=self.items[self.item+1].item:doBtnp(3)
        end

        if vChange~=nil and self.fnChange then
            local key=self.items[self.item+1].key
            self.fnChange(key,vChange)
        end
    end

    function R.Menu:draw(x,y,c)  
        for i,item in ipairs(self.items) do
            local mark=(i==self.item+1) and ">" or " "
            local str=string.format("%s %s: %s",mark,item.title,item.item:getText())
            print(str,10,10+i*8,c)
        end
    end

    function R.Menu:getValue(key)
        for i,item in ipairs(self.items) do
            if item.key==key then
                return item.item:getValue()
            end
        end
        return nil
    end
end  