-- include like:
-- MODEL=require("./data/model/cone")(12)

return function(segments)
    local fullVerts={
        {0,-1,0},
        {0,1,0},
    }

    local fullTris={}

    for s=0,segments+1 do
        local a=s/segments * math.pi * 2
        local iV=#fullVerts+1
        fullVerts[iV]={math.sin(a),-1,math.cos(a)}
        if s>1 then
            local iT=#fullTris+1
            fullTris[iT]={1,iV-1,iV}
            fullTris[iT+1]={2,iV-1,iV}
        end
    end

    -- Converts full verts and tris into flat format
    flatVerts={}
    flatTris={}
    for i=1,#fullVerts do
        local v=fullVerts[i]
        flatVerts[#flatVerts+1]=v[1]
        flatVerts[#flatVerts+1]=v[2]
        flatVerts[#flatVerts+1]=v[3]
    end

    for i=1,#fullTris do
        local t=fullTris[i]
        flatTris[#flatTris+1]=t[1]
        flatTris[#flatTris+1]=t[2]
        flatTris[#flatTris+1]=t[3]
    end

    return {
        vertices=flatVerts,
        triangles=flatTris,
    }
end
