package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic

local R={}
require("./sys/sys")(R)
require("./sys/math")(R)
require("./3d/geom")(R)
--require("./3d/poly")(R)
--require("./3d/world")(R)
require("./3d/model")(R)
require("./3d/scene")(R)

local SLDATA=require("./data/model/streetlight")
local BDATA=require("./data/model/bollard")
local RSDATA=require("./data/model/roadsign")
local GLASSDATA=require("./data/model/glasscrack")
local VOR1=require("./data/model/vor1")


local vorPolys={}
local BOLLARD=nil
local ROADSIGN=nil
local STREETLIGHT=nil
local CSCENE=nil
local VSCENE=nil
local ACTOR=nil
local shards = {}

function BOOT()
    
    BOLLARD=R.Model:new()
    BOLLARD:load(BDATA)
    BOLLARD:setDrawFn(R.poly.DrawDebug,R.Model.Z_SORT|R.Model.CALC_NORMAL)

    ROADSIGN=R.Model:new()
    ROADSIGN:load(RSDATA)
    ROADSIGN:setDrawFn(R.poly.Draw1Colour(3),R.Model.Z_SORT|R.Model.CALC_NORMAL)

    STREETLIGHT=R.Model:new()
    STREETLIGHT:load(SLDATA)
    STREETLIGHT:setDrawFn(R.poly.DrawDebug,R.Model.Z_SORT|R.Model.CALC_NORMAL)

	CSCENE=R.Scene:new()

    for i=1,10 do
        local scale=.1
        local matModel=R.M44:new(R.M44.ID)
        matModel:mulM44(R.M44:newTrans(-1+i*.2,0,2))
        matModel:mulM44(R.M44:newScale(scale,scale,scale))
        matModel:mulM44(R.M44:newRotX(math.pi))
--	matModel:mulM44(R.M44:newRotZ(time()*.0001))

        ACTOR=R.Actor:new(STREETLIGHT,matModel)
        CSCENE:addActor(ACTOR)
    end
    local scale=.5
    local matModel=R.M44:new(R.M44.ID)
    matModel:mulM44(R.M44:newTrans(0,0,1))
    matModel:mulM44(R.M44:newScale(scale,scale,scale))
    matModel:mulM44(R.M44:newRotX(math.pi))
	matModel:mulM44(R.M44:newRotY(math.pi/1.6))
	matModel:mulM44(R.M44:newRotZ(time()*.0001))

    ACTOR=R.Actor:new(ROADSIGN,matModel)
    CSCENE:addActor(ACTOR)

    for i=1,10 do
        local scale=.4
        local matModel=R.M44:new(R.M44.ID)
        matModel:mulM44(R.M44:newTrans(-2+i*.4,0,2))
        matModel:mulM44(R.M44:newScale(scale,scale,scale))
        matModel:mulM44(R.M44:newRotX(math.pi))
--	matModel:mulM44(R.M44:newRotZ(time()*.0001))

        ACTOR=R.Actor:new(BOLLARD,matModel)
        CSCENE:addActor(ACTOR)
    end

    VSCENE=R.Scene:new()

    for i=1,#VOR1 do
        local shard = VOR1[i]

        shards[i]=R.Model:new()
        shards[i]:load(shard)
        shards[i].origin = shard.origin

        -- set UV values (i hate lua and fking arrays that start from 1)
        for j=1,#shards[i].tris do
            verts = shards[i].tris[j].vx
            shards[i].tris[j].ex.u1 = shard.vertices[1+(verts[1]-1) * 3] - shard.origin[1] + 120
            shards[i].tris[j].ex.v1 = shard.vertices[1+(verts[1]-1) * 3 + 1] - shard.origin[2] + 68
            shards[i].tris[j].ex.u2 = shard.vertices[1+(verts[2]-1) * 3] - shard.origin[1] + 120
            shards[i].tris[j].ex.v2 = shard.vertices[1+(verts[2]-1) * 3 + 1] - shard.origin[2] + 68
            shards[i].tris[j].ex.u3 = shard.vertices[1+(verts[3]-1) * 3] - shard.origin[1] + 120
            shards[i].tris[j].ex.v3 = shard.vertices[1+(verts[3]-1) * 3 + 1] - shard.origin[2] + 68
            
        end

        shards[i]:setDrawFn(DrawVBankTexture,R.Model.Z_SORT|R.Model.CALC_NORMAL)
         
        local scale=1
        local matModel=R.M44:new(R.M44.ID)
        matModel:mulM44(R.M44:newTrans(0,0,-1))
        matModel:mulM44(R.M44:newScale(scale,scale,scale))
        matModel:mulM44(R.M44:newRotX(math.pi*i/#shards))

        ACTOR=R.Actor:new(shards[i],matModel)
        VSCENE:addActor(ACTOR)
        
    end
end

firstIn = true

function DrawVBankTexture(tr)
	if tr.ex.u1 then
		ttri(
			tr.v[1].x,tr.v[1].y,
			tr.v[2].x,tr.v[2].y,
			tr.v[3].x,tr.v[3].y,
			tr.ex.u1,tr.ex.v1,
			tr.ex.u2,tr.ex.v2,
			tr.ex.u3,tr.ex.v3,
			2, -1,
            tr.v[1].z,
            tr.v[2].z,
            tr.v[3].z
		)
	end
end


function TIC()
	R.tryBreak()

    if time() < 1000 then
        vbank(0)
        cls(1)
        firstIn=true


        CSCENE:getCam():setPos(R.V4:new({0,time()*-0.002,0,1}))
        CSCENE:getCam():setAim(R.V4:new({0,0,-2,1}))
    
        CSCENE:draw()
    
        print("TEST",0,0,12,false,8)
    
    else
        -- for texture later
        if firstIn == true then
            memcpy(0x8000,0,120*136)
            firstIn=false
        else
            vbank(0)
            memcpy(0,0x8000,120*136)
            vbank(1)
        end
        --cls()
        --vbank(1)
        cls()
        for i=1,#VSCENE.actors do
            local scale=1
            local matModel=R.M44:new(R.M44.ID)
            local t = time()-1000
            t = (R.smoothStep((t * 0.0001)%1,0,1) * i/60)

            -- attempt at center moves more
            local o=shards[i].origin

            --t = 1/(((o[1])^2+(o[2])^2)^.5) *t*100


            --matModel:mulM44(R.M44:newTrans(0,0,1))
            --matModel:mulM44(R.M44:newRotZ(t))
            matModel:mulM44(R.M44:newScale(scale,scale,scale))
            matModel:mulM44(R.M44:newTrans(0,0,0.65-t/2))
            --matModel:mulM44(R.M44:newRotX(3*t))
            --matModel:mulM44(R.M44:newRotY(8*t))
            VSCENE.actors[i].mat = matModel
        end

        VSCENE:getCam():setPos(R.V4:new({0,0,-1,1}))
        VSCENE:getCam():setAim(R.V4:new({0,0,0,1}))

        VSCENE:draw()
        vbank(0)
        cls()
    end
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>
