--[[
A visual test for the projection matrix
Cursor keys move the cube up/down/left/right, A and Z move in/out
Spacebar switches between orthographic projection and perspective projection
There's no z-sorting
]]--
package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./debug/menu")(R)
require("./3d/geom")(R)
require("./3d/proj")(R)

MENU=nil

function BOOT()
	MENU=R.Menu:new(nil)
	MENU:addItem('projection','Projection',R.MenuItemSelect:new()
		:add('ortho','Orthographic')
		:add('persp','Perspective')
	)
end

T=0
function TIC()
	R.tryBreak()
	cls()

    MENU:update()
    MENU:draw(0,0,12)

	local points={
		{-1,-1,-1},
		{-1,-1,1},
		{-1,1,-1},
		{-1,1,1},
		{1,-1,-1},
		{1,-1,1},
		{1,1,-1},
		{1,1,1},
	}
	
	local projMode=(MENU:getValue('projection')=='ortho') and R.Proj.ORTHOGRAPHIC or R.Proj.PERSPECTIVE
    local proj=R.Proj:new(projMode)
    local matProj=proj:getM44() 
    local matTrans=R.M44:newTrans(0,0,-5):mulM44C(R.M44:newRotX(T*.03)):mulM44C(R.M44:newRotY(T*.04))
	for i=1,#points do
		local p=points[i]
        local p=R.V4:new({p[1],p[2],p[3],1})
        p:mulM44(matTrans,true)
		p:mulM44(matProj,true)
 		if p.e[4]>0 then
			circ(120+p.e[1]*10,68+p.e[2]*10,2,i)
		end
	end

    T=T+1
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

