package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\Matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/viewport")(R)

MODELDATA={{
	name="cube",
	loader=function()
		return require("./data/model/cube")
	end,
},{
	name="anim-test",
	loader=function(m)
		return require("./data/model/anim-test")
	end,
},{
	name="bollard",
	loader=function(m)
		return require("./data/model/bollard")
	end,
},{
	name="chicken",
	loader=function(m)
		return require("./data/model/chicken")
	end,
},{
	name="roadsign",
	loader=function(m)
		return require("./data/model/roadsign")
	end,
},{
	name="streetlight",
	loader=function(m)
		return require("./data/model/streetlight")
	end,
},{
	name="green man walking",
	loader=function()
		return require("./data/model/green-man-walking")
	end,
},{
	name="TIC Man",
	loader=function()
		return require("./data/model/tic80-logo")
	end,
},{
	name="cone 12",
	loader=function()
		return require("./data/model/cone")(12)
	end,
},{
	name="cone 3",
	loader=function()
		return require("./data/model/cone")(3)
	end,
},{
	name="cone 100",
	loader=function()
		return require("./data/model/cone")(100)
	end,
}}

DRAWFNS={{
	name="Debug",
	fn=R.poly.DrawDebug,
}, {
	name="One Colour",
	fn=R.poly.Draw1Colour(6),
}, {
	name="Lit",
	fn=R.poly.DrawLit,
}}

IOPTION=0
OPTIONS={{
	name="Model",
	opts=MODELDATA,
	v=0,
},{
	name="DrawFn",
	opts=DRAWFNS,
	v=0,
}}

local T=0
local ns={}
local VIEWPORT=nil

function BOOT()
	MODEL=R.Model:new()
	loadModel()
--	for i=0,47 do
--		poke(0x3fc0+i,i*5)
--	end

	VIEWPORT=R.Viewport:new(240,136)
end

function TIC()
	R.tryBreak()

	cls()
	local matView=R.M44:new(R.M44.ID)
	local matProj=R.M44:new(R.M44.ID)
	local viewport=R.Viewport:new(240,136)

	local drawFn=DRAWFNS[OPTIONS[2].v+1].fn
	MODEL:setDrawFn(drawFn,R.Model.Z_SORT|R.Model.CALC_NORMAL)
--	MODEL:setDrawFn(R.poly.DrawDebug,0)
--	MODEL:setDrawFn(R.poly.DrawLit,Model.Z_SORT|Model.CALC_NORMAL)
	local mat=R.M44:new(R.M44.ID)

--[[
	local matT=M44:newTrans(0,-.3,.2)
	mat:mulM44(matT)
	local matR=M44:newRotY(time()*.0021)
	mat:mulM44(matR)
--]]

--	z=3+math.sin(time()*.001)*2
	--mat:mulM44(M44:newTrans(0,0,10))

--	mat:mulM44(M44:newRotX(time()*.001))
	local scale=60
--	mat:mulM44(R.M44:newTrans(0,3,0))
	mat:mulM44(R.M44:newScale(scale,scale,scale))
	mat:mulM44(R.M44:newRotY(0.1))
--	mat:mulM44(M44:newRotZ(time()*.0016))

	local animTime=time()*.0005
	MODEL:draw(mat,matView,matProj,viewport,nil,"walk",animTime)

	for i=1,#OPTIONS do
		local opt=OPTIONS[i]
		local cursor=(IOPTION+1==i) and ">" or " "
		print(string.format("%s %s: %s", cursor, opt.name, opt.opts[opt.v+1].name),0,(i-1)*10,12)
	end

	local opt=OPTIONS[IOPTION+1]
	if btnp(0) then
		IOPTION=math.max(IOPTION-1,0)
	elseif btnp(1) then
		IOPTION=math.min(IOPTION+1,#OPTIONS-1)
	elseif btnp(2) then
		opt.v=(opt.v-1)%#opt.opts
		loadModel()
	elseif btnp(3) then
		opt.v=(opt.v+1)%#opt.opts
		loadModel()
	end
end

function loadModel()
	local modeldata=MODELDATA[OPTIONS[1].v+1].loader()
	MODEL:load(modeldata)
end


-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

