--[[
A visual test for some matrix functions
Press left and right to move through the tests
The projection is basic, and there's no z-sorting
--]]

-- If require fails, try adding the
-- path to your TIC code directory
package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

R={}
require("./sys/sys")(R)
require("./3d/geom")(R)

S=math.sin
C=math.cos

ITEST=0  -- Current test (0 indexed)
-- These take in t (time) and mat (the identity matrix) and return a transformed matrix
local TESTS={{
	name="Static",
	fn=function(t,mat)
		return mat
	end,
},{
	name="Rotate",
	fn=function(t,mat)
		local matR=getMatRot(t)
		return mat:mulM44C(matR)
	end,
},{
	name="Translate",
	fn=function(t,mat)
		local matT=getMatTrans(t)
		return mat:mulM44C(matT)
	end,
},{
	name="rotate+translate",
	fn=function(t,mat)
		local matR=getMatRot(t)
		local matT=getMatTrans(t)
		return mat:mulM44C(matR):mulM44C(matT)
	end,
}}

local T=0
function TIC()
	R.tryBreak()
	cls()

	local points={
		{-1,-1,-1},
		{-1,-1,1},
		{-1,1,-1},
		{-1,1,1},
		{1,-1,-1},
		{1,-1,1},
		{1,1,-1},
		{1,1,1},
	}

	local test=TESTS[ITEST+1]
	print(string.format("< Test: %s >", test.name),0,0,12)

	local mat=R.M44:new(R.M44.ID)
	mat=test.fn(T,mat)

	for i=1,#points do
		local p=points[i]
		local v=R.V4:new({p[1],p[2],p[3],1})

		v:mulM44(mat,true)
		pp=proj(v)
 		if pp.z>0 then
			circ(pp.x,pp.y,pp.z*2,i+1)
		end
	end
	
	T=T+1

	-- Change test
	if btnp(2) then
		ITEST=(ITEST-1)%#TESTS
		T=0
	elseif btnp(3) then
		ITEST=(ITEST+1)%#TESTS
		T=0
	end
end

function getMatRot(t)
	local matX=R.M44:newRotX(t*.01)
	local matY=R.M44:newRotY(t*.013)
	local matZ=R.M44:newRotZ(t*.015)
	return matX:mulM44C(matY):mulM44C(matZ)
end

function getMatTrans(t)
	return R.M44:newTrans(
		S(t*.013)*3,
		S(t*.015)*2,
		S(t*.01)*3
	)
end

function proj(v)
	local zEye=10
	local zf=(zEye-v.e[3])/200
	return {
		x=120+v.e[1]/zf,
		y=68+v.e[2]/zf,
		z=(.1/zf),
	}
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

