return function(R)
--	require("./3d/geom")(R)
	require("./3d/cam")(R)
	require("./3d/proj")(R)
--	require("./3d/model")(R)
	require("./3d/viewport")(R)

	R.Scene={}

	function R.Scene:new()	
		local o={
			cam=R.Cam:new(R.V4:new({0,0,0,0}),R.V4:new({0,0,1,0}),R.V4:new({0,-1,0,1})),
			proj=R.Proj:new(R.Proj.PERSPECTIVE),
			viewport=R.Viewport:new(240,136),
			actors={},	-- Table of actors, entries may be nil if an actor was removed
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function R.Scene:getCam()
		return self.cam
	end

	function R.Scene:setCam(cam)
		self.cam=cam:clone()
	end

	function R.Scene:proj()
		return self.proj
	end

	function R.Scene:setProj(proj)
		self.proj=proj:clone()
	end

	--[[
	function R.Scene:addLight(light)
		local i=#self.lights+1
		self.lights[i]=light
		return i
	end
	--]]

--	acrors[i]={alive=true,actor=actor} seems verbose, but hacked in because setting to nil seems to do nasty things to the table
	function R.Scene:clearActors()
		self.actors={}
	end

	-- mat is the World Transform - i.e. where the object is placed in the world
	function R.Scene:registerActor(actor)
		-- Slot this one into a gap if possible
		for i=1,#self.actors do
			local tryActor=self.actors
			if tryActor==nil then
				self.actors[i]={alive=true,actor=actor}
				return
			end
		end

		self.actors[#self.actors+1]={alive=true,actor=actor}
	end

	-- Removes the reference
	-- Not even sure this works #TODO: Thorough test
	function R.Scene:unregisterActor(actor)
		for i=1,#self.actors do
			local tryActor=self.actors[i]
			if tryActor==actor then
				self.actors[i].alive=false
				return
			end
		end
	end

	function R.Scene:draw()
		viewMat=self.cam:getM44()
		projMat=self.proj:getM44()

		for i=1,#self.actors do
			local actor=self.actors[i]
			if actor.alive then
				actor.actor:draw(viewMat,projMat,self.viewport)
			end
		end
	end
end
