# Overview

3D packages that can be `require`d into a TIC program.

## Orientation

Trying to work to:

- Y is positive up
- X is positive right
- Z is positive towards camera

(Right-handed co-ordinate system)

## V4 - Vector 4

### V4:new(e[4]) :V4

Create a new V4, using the values in the first argument (e.g. `{1,2,3,4}`)

You can specify `V4.EMPTY` or `V4.ID` for empty and identity vectors.

### V4:clone() :V4

Returns a clone of this vector.

### V4:add(v4)

Adds the input v4 to self.

### V:addC(v4) :V4

Clone and add. Returns (self + input v4).

### V4:sub(v4)

Subtracts the input v4 from self.

### V4:subC(v4) :V4

Clone and subtract. Returns (self - input v4).

### (internal) V4:mulM44E(m44):e[][]

### V4:mulM44(m44, normalise)

Multiply V4 by input m44.

### V4:mulM44C(m44, normalise) :V4

Returns a copy of V4 x m44

## M44 - Matrix 4x4

### M44:new({...}) :M44

Create a new M44, using the values in the first argument (e.g. `{{1,2,3,4},{1,2,3,4},{1,2,3,4},{1,2,3,4}}`)

You can specify `M44.EMPTY` or `M44.ID` for empty and identity vectors.

### M44:clone() :M44

Returns a clone of this matrix.

### M44:newRotX(a) :M44

Returs a new matrix rotated around X by a

### M44:newRotY(a) :M44

Returs a new matrix rotated around Y by a

### M44:newRotZ(a) :M44

Returs a new matrix rotated around Z by a

### M44:newScale(x,y,z) :M44

Returs a new scale matrix

### M44:newTrans(x,y,z) :M44

Returs a new translation matrix

### M44:mulV4(v4) :V4

Multiplies this matrix by the input v4 and returns a new V4

### (internal) M4:mulM44E(m4):e[][]

### M44:mulM44(m44)

Multiplies this matrix by m44 in place

### M44:mulM44C(m44) :M44

Returns a clone of this matrix multiplied by m44

## (internal) Tri

May change the interface to expose this?

## Model

### Model:new(flags) :Model

Flags = 0|Model.Z_SORT

Z_SORT sorts the tris before making the draw call. This is not necessary for ttri rendering (this has a z-buffer)

### Model:addVtx() :int

Returns the index of this point (for constructing tris)

### Model:addTri(tri)

Adds a triangle made from p1,p2,p3

### Model:draw(m44)

Draws the model
