return function(R)
	require("./3d/geom")(R)
	require("./3d/cam")(R)
	require("./3d/proj")(R)
	require("./3d/model")(R)
	require("./3d/viewport")(R)

	R.Actor={}

    -- Attaches to a reference of the model
    -- So, copy that model if you want multiple, with deformations or whatever
	function R.Actor:new(model)
		local o={
			model=model,
			mat=R.M44:new(R.M44.ID),
            drawFn=nil,
            drawFlags=0,
			geomPrePassFn=nil,
			geomPostPassFn=nil,
			drawPassFns={},	-- {"pass1":fn,...}
            animCycle=nil,
            animTime=nil,
			alive=true,
		}
		setmetatable(o,self)
		self.__index=self
		return o
    end

    function R.Actor:getMat()
        return self.mat
    end

    function R.Actor:setMat(mat)
        self.mat=mat:clone()
    end

    -- fn can be nil, but you won't get anything out!
	function R.Actor:setDrawFn(fn,flags)
		self.drawFn=fn
		self.drawFlags=flags
	end

	function R.Actor:setDrawPassFn(name,fn)
		if self.alive then
			self.drawPassFns[name]=fn
		end
	end

	-- fn can be nil
	function R.Actor:setGeomPrePassFn(fn)
		if self.alive then
			self.geomPrePassFn=fn
		end
	end

    -- fn can be nil
	function R.Actor:setGeomPostPassFn(fn)
		if self.alive then
			self.geomPostPassFn=fn
		end
	end

	function R.Actor:setAnim(cycle,time)
        self.animCycle=cycle
        self.animTime=time
    end

	function R.Actor:clearAnim()
        self.animCycle=nil
    end

    function R.Actor:draw(viewMat,projMat,viewport)
		if self.alive then
			local draw={fn=self.drawFn,passFns=self.drawPassFns,flags=self.drawFlags}
			local anim=(self.animCycle) and {cycle=self.animCycle,time=self.animTime} or {}
			local cbFns={geomPrePassFn=self.geomPrePassFn,geomPostPassFn=self.geomPostPassFn}
			self.model:draw(self.mat,viewMat,projMat,viewport,draw,anim,cbFns)
		end
    end
end
