R=R or {}
require("./sys/sys")(R) 
require("./sys/palette")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/actor")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local PAL_BLACK=nil
local SCENE=nil
local ACTOR_SIGNAL=nil
local ACTOR_GMAN=nil
local ACTOR_RMAN=nil
local GMAN_PIX_Y_LOW=nil
local GMAN_PIX_Y_HIGH=nil
local RMAN_PIX_Y_LOW=nil
local RMAN_PIX_Y_HIGH=nil

lampFilter=require('./screenfilters/lamp')
local palYswitch=0

return {
    musicPatterns=2,
    bdr=function(y,t,unitT)
        local RGB0=R.RGB:new(0,0,0)

        vbank(0)
        local pal0=R.Palette:new()
        pal0:setRGB(0,R.RGB:new(0,0,0))
        local r=y/130+unitT*.2
        pal0:setRGB(1,R.RGB:new(r/2,.1,.2))
        pal0:setRGB(2,R.RGB:new(.2,.2,.2+y/200))
        pal0:setRGB(3,GLOBAL.rgbGMan)
        pal0:setRGB(4,GLOBAL.rgbRMan)

        local inT=1
        if unitT<.3 then
            inT=unitT/.3
        elseif unitT>.85 then
            inT=1-(unitT-.85)/.15
        end
        inT=R.clamp(inT,0,1)
        PAL_BLACK:applyBlend(pal0,inT)

        --[[
        vbank(1)
        local blendTo=y<palYswitch and GLOBAL.rgbRMan or GLOBAL.rgbGMan

        for i=0,15 do
            local rgb=RGB0:getBlendTo(blendTo,i/15)
            R.setRGB(i,rgb)
        end
        --]]
    end,
    musicTic=function(isFirstRun,t,unitT)
        if isFirstRun then
            vbank(1)
            cls()
            
            PAL_BLACK=R.Palette:new()
            PAL_BLACK:setAllRGB(R.RGB:new(0,0,0))
            SCENE=R.Scene:new()

            local model=R.Model:new()
            modeldata=require("./data/model/crossing-signal")
            model:load(modeldata)
            ACTOR_SIGNAL=R.Actor:new(model)
            ACTOR_SIGNAL:setDrawFn(R.poly.Draw1Colour(2),R.Model.Z_SORT)
            SCENE:registerActor(ACTOR_SIGNAL)

            local model=R.Model:new()
            local modeldata=require("./data/model/greenman")
            modeldata.scale=.14
            model:load(modeldata)
            modeldata.scale=1
            ACTOR_GMAN=R.Actor:new(model)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(3),0)
            ACTOR_GMAN:setGeomPostPassFn(function(i,v)
                if i==1 then
                    GMAN_PIX_Y_LOW=v.e[2]
                    GMAN_PIX_Y_HIGH=v.e[2]
                else
                    GMAN_PIX_Y_LOW=math.max(GMAN_PIX_Y_LOW,v.e[2])
                    GMAN_PIX_Y_HIGH=math.min(GMAN_PIX_Y_HIGH,v.e[2])
                end
                return v
            end)
            SCENE:registerActor(ACTOR_GMAN)

            local model=R.Model:new()
            modeldata=require("./data/model/redman")
            modeldata.scale=.14
            model:load(modeldata)
            modeldata.scale=1
            ACTOR_RMAN=R.Actor:new(model)
            ACTOR_RMAN:setDrawFn(R.poly.Draw1Colour(4),0)
            ACTOR_RMAN:setGeomPostPassFn(function(i,v)
                if i==1 then
                    RMAN_PIX_Y_LOW=v.e[2]
                    RMAN_PIX_Y_HIGH=v.e[2]
                else
                    RMAN_PIX_Y_LOW=math.max(RMAN_PIX_Y_LOW,v.e[2])
                    RMAN_PIX_Y_HIGH=math.min(RMAN_PIX_Y_HIGH,v.e[2])
                end
                return v
            end)
            SCENE:registerActor(ACTOR_RMAN)
        end

        local mat=R.M44:newTrans(0,0,0)
        mat:mulM44(R.M44:newRotZ(math.pi))
        if unitT<.8 then
            local inT=unitT/.8
        end
        ACTOR_SIGNAL:setMat(mat)

        vbank(1)
        cls(0)

        local camY=-unitT*1.1-.5
        local cam=SCENE:getCam()
        local rot=0
        if unitT<.5 then
            rot=unitT/.5
        end
        local x=math.sin(rot*math.pi*2)*1
        local z=math.cos(rot*math.pi*2)*1
        cam:setPos(R.V4:new({x,camY,z,1}))
        cam:setAim(R.V4:new({0,camY,0,1}))

        local mat=R.M44:newTrans(0,-1.87,0.05)
        mat:mulM44(R.M44:newRotY(math.pi))
        ACTOR_RMAN:setMat(mat)

        local mat=R.M44:newTrans(0,-1.64,0.05)
        mat:mulM44(R.M44:newRotY(math.pi))
        ACTOR_GMAN:setMat(mat)

        vbank(0)
        cls(1)
        SCENE:draw()

        --[[
        local gManYmid=(GMAN_PIX_Y_LOW+GMAN_PIX_Y_HIGH)/2+68
        local rManYmid=(RMAN_PIX_Y_LOW+RMAN_PIX_Y_HIGH)/2+68
        palYswitch=(gManYmid+rManYmid)/2
        lampFilter(120,gManYmid,14)
        lampFilter(120,rManYmid,14)
--]]
--[[
        vbank(0)
        cls()

        local from,to=math.min(rManYmid,0),math.max(gManYmid+100,136)
        for y=from,to do
            local w=100
            if y<rManYmid-60 then
                w=0
            elseif y>gManYmid+60 then
                w=40
            end
            line(120-w/2,y,120+w/2,y,10)
        end
        --]]
    end,
}
