R=R or {}
require("./font/sysfont")(R)
require("./font/font")(R)
require("./ui/qrint")(R)
require("./sys/palette")(R)
require("./sys/math")(R)

local GLOBAL=require("./global")

local PAL0=nil
local PAL_RED=nil
local PAL_GREEN=nil
local FONT=nil
local TALL=nil

function printBigCentre(text,y)
    local w=FONT:width(text,1)
    x=120-w/2
    FONT:print(text,x-1,y-1,1,1,3)
    FONT:print(text,x+1,y+1,1,1,2)
    FONT:print(text,x,y,1,1,1)
end

function printSmall(text,x,y)
    return R.qrint(text,x,y,1,false,1,false,2,nil)
end

return {
    musicPatterns=4,
    bdr=function(y,t,unitT)
        local inOut=.25
        local colT=1
        if TALL<inOut then
            colT=R.smoothStep((TALL*2)/inOut,0,1)
        elseif TALL>(1-inOut) then
            colT=R.smoothStep((TALL*2)/inOut,0,1)
        end

        vbank(0)
        local pal=PAL_RED:blendC(PAL_GREEN,.5+math.sin(y*.007+TALL*20)*.5)
        PAL0:applyBlend(pal,colT)

        vbank(1)
        local pal1=R.Palette:new()
        pal1:setRGB(0,GLOBAL.rgbGMan)
        pal1:setRGB(1,R.RGB:new(1,1,1))
        pal1:setRGB(2,pal:getRGB(7))
        pal1:setRGB(3,pal:getRGB(11))
        PAL0:applyBlend(pal1,colT)
    end,
    musicTic=function(isFirstRun,t,unitT,donePatterns,tAll)
        TALL=tAll
        tAll=tAll/4
        if isFirstRun then
            PAL0=R.Palette:new()
            PAL0:setAllRGB(R.RGB:new(0,0,0))    

            PAL_RED=R.Palette:new()
            PAL_GREEN=R.Palette:new()
            for i=1,15 do
                local s=i/15
                PAL_RED:setRGB(i,R.RGB:new(s,0,0))
                PAL_GREEN:setRGB(i,R.RGB:new(0,s,0))
            end
    
            vbank(1)
            cls()
            
            vbank(0)

            local data=require("./data/sysfont/informics-7x7/informics-7x7")
            R.sysfontLoad(data)

            local fontdata=require("./data/font/nucampi-8x16/nucampi-8x16")
            FONT=R.Font:new()
            FONT:load(fontdata)        
        end
        vbank(0)

        -- mirrored for speed
        for y=68,136 do
            for x=120,240 do
                local dx,dy=x-120,y-68
                local d=(dx^2+dy^2)^.5
                local c=.5+math.sin(d*.18-tAll*50)*.5
                pix(x,y,1+c*14)
                pix(240-x,y,1+c*14)
            end
            memcpy(120*(135-y),120*y,120)
        end

        vbank(1)
        cls(0)
        printBigCentre("You Better Walk",10)
        local slogan={"MAY ", "THE ", "DEMOLITION ", "BE ", "WITH ", "YOU"}
        local iWords=(#slogan*(tAll-.2)*8)//1
        iWords=R.clamp(iWords,0,#slogan)
        local text=""
        local xText=36
        for i=1,iWords do
            local y=64-math.abs(math.sin(tAll*70-i*.4))*8
            xText=xText+printSmall(slogan[i],xText,y)
        end
        printBigCentre("- RiFT -",34)
        local y=0
        if tAll>.6 then
            printSmall("Look both ways before you cross the road",10,115+y)
        elseif tAll>.4 then
            printSmall("No polygons were harmed",52,111+y)
            printSmall("in the making of this production",35,122+y)
        end
        printSmall("Bossman  -  Decca  -  jtruk",48,78)
        printSmall("Jynx - Mantratronic - T^Bach",44,89)
    end,
}
