R=R or {}
require("./sys/sys")(R)
require("./sys/palette")(R)

local riftlogo=require("./data/gfx/rift-logo")

local SCENE=nil
local MODEL_RECT=nil
local ACTOR_RECT=nil
local PAL_LOGO=nil
local PAL0=nil

return {
    musicPatterns=2,
    bdr=function(y,t,unitT)
        local cBlendLogo,cBlendSwirl=1,1
        if unitT<.2 then
            cBlendLogo=unitT/.2
            cBlendSwirl=unitT/.2
        elseif unitT>.8 then
            cBlendSwirl=1-(unitT-.8)/.2
        end
        cBlendSwirl=R.clamp(cBlendSwirl,0,1)

        vbank(0)

        -- Background swirl
        local rgb0=R.RGB:new(0,0,0)
        R.setRGB(0,rgb0)
        local shiftLine1=(y>>1)%2==0 and unitT/2 or 0
        for i=1,15 do
            local r=.5+.5*math.cos(i*.27+unitT*9+y*.027+shiftLine1)
            local g=.5+.5*math.cos(1+i*.032+unitT*11-y*.023-shiftLine1)
            local b=0
            local rgb=R.RGB:new(r,g,b)
            R.setRGB(i,rgb0:getBlendTo(rgb,cBlendSwirl))
        end

        -- Logo fade in
        vbank(1)
        PAL0:applyBlend(PAL_LOGO,cBlendLogo)
    end,
    musicTic=function(isFirstRun,t,unitT)
        if isFirstRun then
            music(1,-1,-1,false)

            PAL0=R.Palette:new()
            PAL0:setAllRGB(R.RGB:new(0,0,0))

            riftlogo.setup()
            PAL_LOGO=R.Palette:new()
            PAL_LOGO:readSys()

            SCENE=R.Scene:new()

            local w,h=riftlogo.getDims()
            MODEL_RECT=R.Model:new()
            MODEL_RECT:load(require("./data/model/rectangle")(1,h/w))

            ACTOR_RECT=R.Actor:new(MODEL_RECT)
            ACTOR_RECT:setDrawFn(function(tr)
                ttri(
                    tr.v[1].x,tr.v[1].y,
                    tr.v[2].x,tr.v[2].y,
                    tr.v[3].x,tr.v[3].y,
                    tr.ex.u1*w,tr.ex.v1*h,
                    tr.ex.u2*w,tr.ex.v2*h,
                    tr.ex.u3*w,tr.ex.v3*h,
                    2,
                    15,
                    -tr.v[1].z,-tr.v[2].z,-tr.v[3].z
                )
            end,0)
            
            SCENE:registerActor(ACTOR_RECT)
        end

        local inRot=1
        if unitT<.95 then
            inRot=unitT/.95
        end

        vbank(1)
        cls()
        riftlogo.draw(0,0)

        vbank(0)
        cls()
        local mat=R.M44:new(R.M44.ID)
        --mat:mulM44(R.M44:newTrans(0,0,4-inRot))
        mat:mulM44(R.M44:newTrans(math.sin(inRot*math.pi*4),math.sin(inRot*math.pi*5),4+math.cos(inRot*math.pi*3)*1.5))
        mat:mulM44(R.M44:newRotZ(inRot*4*math.pi))
        mat:mulM44(R.M44:newRotY(math.sin(inRot*math.pi*3)*math.pi))
--        mat:mulM44(R.M44:newRotX(inRot*.7*math.pi))
        ACTOR_RECT:setMat(mat)

        SCENE:draw()
        memcpy(0x8000,0,120*136)
        for y=0,136,2 do
            for x=0,240 do
                local ox,oy=x-120,y-68
                local a=math.atan2(oy,ox)
                local d=(ox^2+oy^2)^.5
                local c=d*.1+a+inRot*5
                pix(x,y,8+math.sin(c)*7)
            end
        end

        vbank(1)
        memcpy(0,0x8000,120*136)
    end,
}
