R=R or {}
require("./font/sysfont")(R)
require("./font/font")(R)
require("./ui/qrint")(R)
require("./sys/palette")(R)
require("./sys/math")(R)
require("./demo/parts")(R)

local GLOBAL=require("./global")

local PARTS=nil
local PAL_BLACK=nil
local PAL_CARD=nil
local PAL_WHITE=nil
local FONT=nil
local PART_ID,PART_TIME=0,0

return {
    duration=10000,
    bdr=function(y,t,unitT)
        vbank(0)
        if PART_ID=="fade-in" then
            PAL_BLACK:applyBlend(PAL_CARD,PART_TIME)
        elseif PART_ID=="static" then
            PAL_CARD:apply()
        elseif PART_ID=="fade-white" then
            PAL_CARD:applyBlend(PAL_WHITE,PART_TIME)
        end
    end,
    tic=function(isFirstRun,t,unitT)
        if isFirstRun then
            PARTS=R.Parts:new()
            PARTS:addPart("fade-in",2)
            PARTS:addPart("static",8)
            PARTS:addPart("fade-white",2)
            
            PAL_BLACK=R.Palette:new()
            PAL_BLACK:setAllRGB(R.RGB:new(0,0,0),0,15)
            PAL_CARD=R.Palette:new()
            PAL_CARD:setRGB(1,R.RGB:new(1,1,1))
            PAL_CARD:setRGB(2, GLOBAL.rgbGMan)
            PAL_CARD:setRGB(3,R.RGB:new(.1,.5,.1))
            PAL_CARD:setRGB(4,R.RGB:new(.05,.4,.05))
           
            PAL_WHITE=R.Palette:new()
            PAL_WHITE:setAllRGB(R.RGB:new(1,1,1),1,15)

            local data=require("./data/sysfont/informics-7x7/informics-7x7")
            R.sysfontLoad(data)

            local fontdata=require("./data/font/nucampi-8x16/nucampi-8x16")
            FONT=R.Font:new()
            FONT:load(fontdata)        
        end

        PART_ID,PART_TIME=PARTS:getPart(unitT)
        
        vbank(0)
        cls(2)
        local text="You Better Walk"
        local x,y=55,56
        FONT:print(text,x-1,y-1,1,1,4)
        FONT:print(text,x+1,y+1,1,1,3)
        FONT:print(text,x,y,1,1,1)
        R.qrint("TIC-80 / Nova 23 (wild)",124,125,1,false,1,false,3,nil)
    end,
}
