package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\Matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

R=R or {}
require("./sys/sys")(R)
require("./sys/palette")(R)
require("./sound/music")(R)
require("./3d/scene")(R)
require("./3d/actor")(R)

SCENE=nil
MODEL_GMAN=nil
ACTOR_GMAN=nil

WALK_FN=nil
WALK_FNS={}
I_WALK_FN=0
TIME_MUSIC_START=0
LAST_MUSIC_PATT=0

function BOOT()
	SCENE=R.Scene:new()

	MODEL_GMAN=R.Model:new()
	MODEL_GMAN:load(require("./data/model/green-man-walking-2"))

	ACTOR_GMAN=R.Actor:new(MODEL_GMAN)
	ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(6),0)
	local matModel=ACTOR_GMAN:getMat()
	matModel:mulM44(R.M44:newTrans(0,0,2))
	SCENE:registerActor(ACTOR_GMAN)

	WALK_FNS={walk1}--,walk2,walk3}
	
	I_WALK_FN=0
	WALK_FN=WALK_FNS[I_WALK_FN+1]

	music(0)
	TIME_MUSIC_START=time()
end

function incWalkFn()
	I_WALK_FN=(I_WALK_FN+1)%(#WALK_FNS)
	WALK_FN=WALK_FNS[I_WALK_FN+1]
end

function TIC()
	R.tryBreak()
	local mpos=R.music.getPos()
	local musMeta=R.music.getTrackMeta(mpos.track)

	-- Might need to do T with 60FPS instead...
	local elapsed=(time()-TIME_MUSIC_START)/1000
	local bpm=(6*musMeta.tempo)/musMeta.speed
	local rowsPerSec=(bpm/(60/4))
	local rowsDone=elapsed*rowsPerSec
	local pattern,trackF=math.modf(rowsDone/musMeta.rows)

	-- We can also resync on row=0 if we have to?
	if pattern>LAST_MUSIC_PATT then
		incWalkFn()
	end

	WALK_FN(trackF)

	print(musMeta.tempo,0,100,15)
	print(musMeta.rows,60,100,15)
	print(musMeta.speed,120,100,15)
	print(pattern,220,130,2)

	rect(trackF*240,135,4,1,12)

	LAST_MUSIC_PATT=pattern
end

DOTS={}

function walk1(f)
--[[
	for i=1,15 do
		local g=i/15
		R.palette.setRGBU(i,0,g,0)
	end
--]]
	cls(0)

	SCENE:getCam():setPos(R.V4:new({0,0,0,1}))
	SCENE:getCam():setAim(R.V4:new({0,0,2,1}))

--	matModel:mulM44(R.M44:newTrans(0,0.8-math.abs(math.sin(f*math.pi*8))*.2,2))
--	matModel:mulM44(R.M44:newRotY(f*math.pi*2))
	SCENE:draw()
--[[
	local pixOut={}
	for y=0,136 do
		for x=240,0,-1 do
			local p=pix(x,y)
			if p==0 then
				col=1
			else
				local iPix=y*240+x
				pixOut[iPix]=(col+1)//1
				col=col+math.sin(f*math.pi)*.3
			end
		end
	end

	for i=1,#DOTS do
		pix(DOTS[i].x,DOTS[i].y,12)
		DOTS.alive=DOTS.alive-1
		if DOTS.alive<=0 then
			table.remove(DOTS,i)
		end
	end
	--]]
end

function walk2(f)
	cls(0)
	SCENE=R.Scene:new()

	for i=-2,2 do
	 MODEL:setDrawFn(R.poly.Draw1Colour(12),R.Model.Z_SORT|R.Model.CALC_NORMAL)
	 local matModel=R.M44:new(R.M44.ID)
	 matModel:mulM44(R.M44:newTrans(math.sin(f*math.pi)*i,0.8,2))
	 local actor=R.Actor:new(MODEL,matModel)
	 SCENE:addActor(actor)
	end

	SCENE:draw()
end

function walk3(f)
	cls(0)
	SCENE=R.Scene:new()
	MODEL:setDrawFn(R.poly.Draw1Colour(6),R.Model.Z_SORT|R.Model.CALC_NORMAL)

	for i=-2,2 do
		local matModel=R.M44:new(R.M44.ID)
		matModel:mulM44(R.M44:newTrans(0,0.8,2))
		matModel:mulM44(R.M44:newScale(math.sin(f*math.pi*8)*.75+1,1+math.sin(f*math.pi*4)*.5,2))
		local actor=R.Actor:new(MODEL,matModel)
		
		ACTOR=R.Actor:new(MODEL,matModel)
		SCENE:addActor(ACTOR)
	end

	SCENE:draw()
end

-- <WAVES>
-- 000:00045500600800000000000000000000
-- </WAVES>

-- <SFX>
-- 000:000000000000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000004000000000
-- </SFX>

-- <PATTERNS>
-- 000:400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000000000000000000000000000400006000000000000000000400006000000000000000000
-- </PATTERNS>

-- <TRACKS>
-- 000:100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000f00000
-- </TRACKS>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

