-- title:  rift-logo-16.png
-- author: TicMcTile
-- script: lua

-- set the palette
function tovram(str)
  local o=0
  for c=1,#str,2 do -- walk colors
    local v=tonumber(str:sub(c,c+1),16) -- get color (v)alue
    poke(0x3fc0+o,v) o=o+1 -- set color
  end
end

-- the rle-decoder
function tomem(str)
  local o=tonumber(str:sub(1,2),16)*256 -- get (o)ffset
  local w=tonumber(str:sub(3,4),16)*8-1 -- get (w)idth
  local e=str:sub(5,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end

return {
  getDims=function()
    return 128,85
  end,
  setup=function()
    local pal = "10ff20b66520ba4424de30ee000000ae34c2857d1c79304c813485380c75aa857d75dece4420109dbe99b681ce000000"
    local gfx = "8080A86EA4E2A3EEGFA2EENFFAE2GF2E2IF3A3E14KO2KGF5GFFIF3KFFIF2IF2GF2KF2GF2KFA7EEA5GE2A3FOGEEA2F2NEEAAF2KGEEAF2NGGEAFFNMDOEEA126EA22EA3E3AAE3MGAE2HKGGE2KCCGGEMBC3GA3E3AE10GGE2GNGGE2G4E2G4E2G4E2G3E3A14EA3E3AAE3CNAE2GNCCE2KLBCCEMLKBC2MLC5AAE14CKNNBLLBC3BLLC4BLLC5LLC5LLC5LLE3A3E5AANLLGHEEANL3EEANL3NEAL5EAL4NEAL4GEA71EA5EEA5EEA5EEA5EEA5EMA5EEA5EJEEA5E2A4GGEA4GGNEA3G2MEA2G2NEEAAHG2NEEAI2GGNEEA142EA5EEA4EEMA4EEFA3EEIFA3EMFGA2EEIGGEEIF2IFEIFFINLFGFFGGLLF2GLNLLIFGL4G3LLGLKG3LNLNG3NLNNFFGF6IF6IFFIF3IFFGF8NF5KMF3IFKDF5GDFIGKDDGEFNGD2NEKMD3OEGD5MGD5KD4KDKD3KDDKD2KD2KA15EA6EA6EA6EA6EEA5EEA12EA5EEA5EEA5EMA4EEGA4EEGA4EEGA4EMGEKC4GHC4BGGC5BGC2BC2GC2GC2GC2GBCCGC2G4C3GMEG3E3G2KE3BG2E2GBGGME2NBGGE2MG2HE2GGME4GGE5GGNNC5NGC5GGC3BBG2BBCCG5CCBGC2GBBGBC2BG3C2G3C4BLLC4L2C2BGGNNG11BG26L4EEAL3GEEAL3MEEAL2NE2ANLLME2AGGNE3AG2E3AGNME2A71EJA5EJA5EGA5EGA5EGA4EEGA4EEGA4EEGI2G2NEI2G4IHHG3NGGIG2BG15MG6MG5KMEA6EA6GEA5NMEA3EME11MKKE2CNBCCEKKC4A13EEAAE8MGKEEMKKBGGEEBGCCNE2CGCBGE2CGGNE3A2EMIGGAAEEIG2AAEEIB2AAEHGB2AEEIB3AEEB4AEMB4EECB4G4LGLG5LLB5LHB5MEB4MEEB4E2BIIBE3BIIHE3F4HDDIIFIIMDDE2HMDDKE3HDKDE4CDDE4CDKE4CDDE4HD3KD3KD6KD6KD4GKGDDKKD2MD5OED5KEDDKKDDKE2A5EA6EA6EA6EA6EA6EA6EA11EHGA3EEGGA3EEGHA3E3A3E3A2E4A2E4AAE2MBOG3ME2CCE19JBE3MNOBEEHOF2JGOF3OEF5KE6GGE5GBE5BBE5BBE5BBE5BBEEAAEEBBEEAAEEBBGBBG8BCBG3BC2BG2BC2BG3C2G6BCB6CB7G39BG6B15GNE3AAGGE3AEGE4AENE3AAEKE3AEEKE2AAEEKE2AAEEKMEEAAE5A3E8COKGHM2D2CFFCED2CF2EBD2IFFEED2CFFEECD2IFA4EEGE6GE3M2GICCGNNBBF2NLLBBF2NLLBBCFFNLLBBIFFNLLBBG5NNG4K2G6KB2G4B2G3B3G3B5GBGB2CBGBGKBC5GC6GBC12BC3G3C3G3C2BG10NCG2E3CGNE4BGGE3AGNE4AGGE3AANE4AACE3A2E4A2EECB4EEB5EEB5EEB5EEB5EEB5EEB3IIEEB2I2BIIJE3I2E4I2E4I2E3AI2E2AAKBIMEA2KI2EA2I2KEA2E4B2EAE2B2A2EEB2A2EMB2A2EB3AAEEB3AEEB4AEMB8KDMEB3KOEEB3DKEEB3OE2B3ME2B2CE3B2ME3BBCE5A5EEA5EEA5EEA5EA5EEA5EEA5EEA5EME2HKF2ECKF4MIF5CF6CF2KBFFCFIBF3BCF19GEF3IBHEFFBCFDMEBIF2OEEF4KEEF4BEEFFIKOCEEDCFFOME3AAEEHBEEAAE2BEA2E2BEA2E2BEA3EECEA3EEMA4E2A4E2B9IB6I3KIBI5BI23CI5BBCB5KCB14NB5IBMB6HHB5KEMHEEBBKE3BBKEEAAEEBKME4BBNCMCBEB2KKBBMB2HE3HE3HE2MBOFFKEOFFCF2NEEMD2CFE2CD2FE2HD2CE3CD2E3CDDBE15ME6F2NLLBBF2GL2NFIFBCCDDCD4CDBCME2CDE5DDE5DDE5DDB7NB5MNB5MNB5MNB5MNB5MNB5HNB5HCME54A6E3A3E3A3E2A4E2A4EEA5EEA5EA14EECBBI2E2BBI2E2B2CIE2B2IIAEECBCIIAE2BBIIAE2B3AE2CB2ICIKEEAAIB2MEAEB3KE2B2NNEELIB2LNLKB3NLNB3KLNLB3LBKBNEEKB4EKB5KB6KB5MB5EEB5KB6CCB5CCBBE4ABME4AHE15MCK2OOBC3D2C4D2C3D2CA4EEHA4EECEEA2EEIE3AEEFOBE3MBDKOE2CBCFDCEEBBF2KEECCF5DDF3BKOLFFICBBOLCBCCBBOLBBCCBBFLBCCB2FLBCCB2FLBBCB2FLOOFIBE2FFBME3FFKE4FFKE3AFFKE3AFFKE3AFFKE3AFFKE2A6E2A4E2A5EEA5EEA5EEA5EEA5EEA6EBCI3HBCBBCI3HB2I3MB2I2HEB3CCBEC6EHC5EMCI3CBBKMBODFB4DDIB4CDCB4CDDB4D2C2BKD2CCNDDCCFCCGDIF6CF7IF3IF10BF3CF2CCF4BCF2CCE2CCME4KBE5FDE5FFIE4F2E4DBME34DDE5DDE5DDE2AEEDDEA2EEDDEA2EEDDEA2EEDDEA2EMDDNB5CN2KB2GB2CCB2D4CBBD4CBKD5CKD5CKD6KEA6EA6EA6EA6EEA5EEA5EEA5EEA71EECB2AAE2B2AAE2C2AAE2C2A2EEHDDA2E2DDA2E2DDA2E2CDBBNB6CB4C15D12CCED4CCMD3C2KB5C25D5FFE23C2D2CFC2DDIFFCCDDIF2CDDF3IF3IF2EHIF4EHFIIF2EL6F2KE3F2BE3FIFHE3F2ME2MFFDE3MFFOE3MFFOE3HLLBE3HB2CBBFLC2B2FLC2B2FLC3BBFLC2B2FLC5FLC2DDFFLCD3FFLFFKE2AAFFKEEA2FFKEA3OFKEEA2OFKEEA2OFOEEA2OFOEEA2OFOMEA9EA6EA6EA39EECI2CCEECHIHCCEEHC2HCEEMC4E2C4E2C4E2HC3E2MH3C3ICCMC2KCCEEC2NDOEEC2KDFMEC4ICEC3KCOEC3NDOEH3BDFME53AAE3A3E22AE4A2EEA29EA2EMDDA3EMCCA3EKLOA3ECFFA3ECDDA3ECBIA3ECCIA3EC2D6KC2H4O7F6CIF10IC2F7CF6EEA5EEA5EEA5EEA5EEA5MEA5MEA5HEA73EEHDA3E2DA3E2DA3E2IA4EEHA4E2A4E2A4E2D3C2KD3C2BD3C3D2CCH2DDH5DH22E15CE6KE5HHME4HHKE4H2E3JH2KE2H2NK4NH3KNLLH47NLHE3HLLME3HHKE2AEHHNE4HHOE4HHIEEAEEIHJEEAEEHHE2AEEHD4FFLD3CFFOD4FFOD4OLKD2NNLKCDDFKNLKCD2KNLNHD2KLLNHNFFMEA2LFFCEA2LCCKEEAAC2KEEAAC2KEEAAC3ME2H4E2H3KCKHA47EA6EA6E3H3E3H3AE2H3AE2H3AE2H3AE2H3AEEHN3AEEID3H4IICH4KHOH4NFFH4KDFH5IIH5KIN6FDF3IIFEEA5EEA5EEA5MEA5IEEA4OEEA4FEEA4FJEEA71EC2A2EEC2A2EEC2A2EEC2A2EECCIA2EEI2A2EEI2A2EEI2CFIIF3CF3IIFCCFFIF2HKNF4ICLKF3IIL2HFFIIKILLKFIHIIKL2BEA5BEEA4OEEA4OEEA4DEEA4FEEA4FEEA4FMEA74EEA5EEA5EEA5EEA6EA6EA6EA6EEH6EJ6EJ3HCHEJ4CJEEJ5EEJ4HEEJ4HEEJ2HCJHHJKEEHHJ3MEHHJ3HEHHJ4IEHJ5OECCJ3HOCCHC2HHJJC4H20IH2IHHI4EHI5EEHHI3KEHHI4EMHI3KE2AEEIKEEAAEEHKEEAE2HHEEAEMDDHEEAEHDDE2AEHDDEEAAEHDDEEAAEMD4KLLNHD2KL2HD2KL2JD2KLNLJD2KNNLLD23H6KH7J15L4NKIDDF2I2D15EEA5HEEA4OEEA4JIEEA3JKEEA3JJIEEA2DJIEEA2DFJIEEA2EEHD3AEEMIHHDAE2FDDFAE2ID2AE2HFIDAE2MF2AE3F2AE3HFFD15HHIFD7I2FD7IID5F2IFD2F4IIDIOEEA3IOEEA3DFHEA3DIKEEA2FIOEEA2DFOEEA2DDFHEA2DDIKEEA68EEI2A2EEI2A2EEIIHA2EEJ2A2EEJIIA2EEJ2A2EEJDJA2EJFDFH2KL3H3NL2H4LLNJH4LLHCCH2KLHC5NJJHC4IJC5IKEEA3HKEEA3HOEEA3NOEEA3LFEEA3LFHEA3LFIEEA2IFIEEA130E2JJHCHE2C4E2C4E2HC3AE2C3AE2C3AE2C3AE2HC2JHC4HC6HC5HIC2HHJ2C2HJJEEC3JJEJC3E2JCCME3JHMEHI4NHIHI2CHEH2JJEEJ5EJ30EEAEEMDDHE3MDDJJIEEMDDJJKEEJIIJJE3DDJJE3DDJKE3DDJOE3D21F2IIF2D51IJ3IIFD41JIJEAADDFJKEEAFFD2EEAD4EEAD4EEAD4EEAD3OEEAFIJ2EEAAE4MFAAE5AAE5AAE5AAE5A2E4A3E3A4E2F6IHF6EJF5E2IF3E3HF2E5IFE6JE7HIIOEEAAFFIOEEAAF3HEAAF3OEAAF3OEEAF4JEAF4IEAEIF2OEA67EJDDIA2EJDDIA2EJDDFAAEEJD2AAEEJD2AAEEJD2AAEEJD2AAEEJD3JC5DJC5DFJC3HDDJH3IDDIJ2IFFDDJJIIEIDDJFIEEIDDIJE2HFHEEA2HOE2A2FOE2A2FE3A2E4A2E4A2E3A3E3A133E2C2AAE2CCHAAE2CMEAAE5A2E4A2E4A2E4A2E4CE43AE4A3E2A5J7EJ6E3J3E5JJE31JIE3DDJJE3DDJE4DDKE17AE6AE6AE3D12FJJFJE45DDFIJ2E63AE6AE6AE6AE6AE6AE6AE5A8EA55E15AE6A2E4A3E3A5EEA6EA7EEJFFOE4JIFE6JE7JE32A65EEJD2AAEEJD2AAEEJDFJAAEEJJEEAAE5AAE5AAE5AAE5FDFJE3FJE43AAE3A3E3A3E2A4E2A4EEA5EA162E3A3E2A4EEA41EA63E6A2E4A4E2A39E2AE5AAE5AAE5AAE2A32E19A43E9A247E5A2E4A4E2A5EEA97E5AAE5AAE4A2E2A4EEA27E2A4EA182"
    tovram(pal)
    tomem(gfx)
  end,
  draw=function(xofs,yofs)
    m=2 -- mode
    t=0 -- tiles/sprites
    r=0 -- range
    if m==2 and r>0 then r=0 end
    if m==4 and r>16 then r=16 end
    if t==0 then s=r else s=r+(128*m) end
    poke4(2*0x03ffc,m)
    for y = 0,128-8,8 do
      for x = 0,(m*64)-8,8 do
        spr(s,xofs+x,yofs+y) s=s+1
      end
    end
  end
}
