-- title:  INFORMICS 7x7
-- author: Decca / RiFT
-- script: lua

-- init vars
tab=0

-- font data and info
nfo = "INFORMICS 7x7"
rle = "28E0880A15DADADADA2DA4LBLBJA10KAPBKAKAPBKA4EAOBHAMBPAEA4NAMAGAGADALA4MAGBODLBLBOCA3DADABA10GADADADADAGA4DAGAGAGAGADA6OAPBPBPBOA8CAHACA12DADABA10HA16DADA4MAMAGAGADADA4OALBNBLBLBOA4GAHAGAGAGAPA4HAMAGADADAOA4HAMAOAMAMAHA4BANANAOBMAMA4PABAHAMAMAHA4OBDAPALBLBOA4PBIBMAGAGAGA4OALBOALBLBOA4OALBLBOBIBPA6DADA2DADA6DA2DADABA6EAOBPBOBEA8HA2HA8EAPAPBPAEA4PAIBOAGA2GA4OABBFBNABAOA4OALBLBPBLBLBA3PALBPALBLBPA4OBDADADADAOBA3PALBLBLBLBPA4OBDAHADADAOBA3OBDAHADADADA4OBDADALBDBOBA3LBLBPBLBLBLBA3DADADADADADA4PAMAMAMAMAHA4LBLAPALBLBLBA3DADADADADAOBA3OBLCLCLCDCDCA3PALBLBLBLBLBA3OALBLBLBLBOA4PALBLBPADADA4GALALALALAOBA3PALBLBPALBLBA3OBDAOAIBIBPA4PAGAGAGAGAGA4LBLBLBLBLBOA4LBLBLBLBKAEA4BDBDFDFDFDOBA3LBLBLBOALBLBA3LBLBLBOAGAGA4PBIBOADADAPBA83"
raw = "28E088000000000000000003030303000300000b1b1900000000000a0f1a0a0f1a0000040e170c1f0400000d0c0606030b00000c061e3b1b1e2000030301000000000006030303030600000306060606030000000e0f1f1f1e000000000207020000000000000303010000000000070000000000000000030300000c0c0606030300000e0b1d1b1b1e000006070606060f0000070c0603030e0000070c0e0c0c070000010d0d0e1c0c00000f01070c0c0700000e130f0b1b1e00000f181c06060600000e0b1e0b1b1e00000e0b1b1e181f00000003030003030000000300030301000000040e1f1e140000000007000700000000040f0f1f0400000f081e06000600000e01151d010e00000e0b1b1f1b1b10000f0b1f0b1b1f00000e130303030e10000f0b1b1b1b1f00000e130703030e10000e130703030300000e13030b131e10000b1b1f1b1b1b100003030303030300000f0c0c0c0c0700000b1b0f0b1b1b100003030303030e10000e1b2b2b232320000f0b1b1b1b1b10000e0b1b1b1b1e00000f0b1b1f03030000060b0b0b0b0e10000f0b1b1f0b1b10000e130e08181f00000f060606060600000b1b1b1b1b1e00000b1b1b1b1a04000001313535353e10000b1b1b1e0b1b10000b1b1b1e060600000f181e03030f1000000000000000000000000000000000000000000000000000000000000000000000000000000000000"

-- the rle-decoder
function tomemrle(str)
  local o=tonumber(str:sub(1,5),16) -- get (o)ffset
  local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
  local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end

-- the raw decoder
function tomemraw(str)
  local tnb=tonumber
  local o=tnb(str:sub(1,5),16) -- get (o)ffset
  local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
  local d=str:sub(8,str:len()) -- remove header to get (d)ata
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=tnb(d:sub(x,x),16) -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end

-- show font alone
function alone()
  tomemrle(rle)
  cls()
  print("THE QUICK BROWN FOX JUMPED OVER THE",24,16,03)
  print("LAZY DOGS BACK IN 1 / 2 / 3 SECONDS",28,32,07)
  print("7-0-9 SHOW ME SOME MORE COOL TRICKS",24,48,10)
  
  print("THE ANSWER IS '42' (BUT IS IT REAL)",34,64,05) 
  print("#TIC80 - LETS SMASH SOME PURE BITS!",28,80,11)
  if tab==0 then
    print("BRING ME COFFEE & TEA + SOFT-DRINK$",26,96,02)
  else
    print("BRING ME COFFEE & TEA + SOFT-DRINK$\n   SKILL IS NEEDED, ARE YOU BORED?",26,96,02)
  end
  print(nfo,0,130,15,false,1,true)
  print("TAB - newline",194,130,15,false,1,true)
end

-- main loop
alone()
function TIC()
  if keyp(49,60,6) then tab=1-tab alone() end
end
