-- title:  All Fonts (rle / compressed)
-- author: Mantratronic / RiFT
-- artist: Decca / RiFT
-- desc:   font writer@demo framework
-- script: lua

-- init vars
part = 0 -- part time lover

-- informics 7x7
local inf_rle = "28E0880A15DADADADA2DA4LBLBJA10KAPBKAKAPBKA4EAOBHAMBPAEA4NAMAGAGADALA4MAGBODLBLBOCA3DADABA10GADADADADAGA4DAGAGAGAGADA6OAPBPBPBOA8CAHACA12DADABA10HA16DADA4MAMAGAGADADA4OALBNBLBLBOA4GAHAGAGAGAPA4HAMAGADADAOA4HAMAOAMAMAHA4BANANAOBMAMA4PABAHAMAMAHA4OBDAPALBLBOA4PBIBMAGAGAGA4OALBOALBLBOA4OALBLBOBIBPA6DADA2DADA6DA2DADABA6EAOBPBOBEA8HA2HA8EAPAPBPAEA4PAIBOAGA2GA4OABBFBNABAOA4OALBLBPBLBLBA3PALBPALBLBPA4OBDADADADAOBA3PALBLBLBLBPA4OBDAHADADAOBA3OBDAHADADADA4OBDADALBDBOBA3LBLBPBLBLBLBA3DADADADADADA4PAMAMAMAMAHA4LBLAPALBLBLBA3DADADADADAOBA3OBLCLCLCDCDCA3PALBLBLBLBLBA3OALBLBLBLBOA4PALBLBPADADA4GALALALALAOBA3PALBLBPALBLBA3OBDAOAIBIBPA4PAGAGAGAGAGA4LBLBLBLBLBOA4LBLBLBLBKAEA4BDBDFDFDFDOBA3LBLBLBOALBLBA3LBLBLBOAGAGA4PBIBOADADAPBA83"

-- nucampi 8x16 (ToBach edition)
local nuc_rle = "0800020OHPHOHPHP7HOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOPPHAHOP2HHAHOPPOPOHHOP5HOHAHAHOHOHAHAHOHOHAHAHOHOHAHAHOHOPDPDHAP2DPDHP2HAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBPHHAHAMBPDHAP2AHOOHP2BHOPPHOMBHOHOHOMBPOHOHOMBPOHOHOMBPPHOHOMBPPHOHOMBPPHOPPHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOP5HOPHOHPHA7HAHAHPHOHAHAHOHOHAHAHOHOHAHAHOHOHAHAHOHOPPHAPPHOPPHAOPHOA7HAMBPHHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAPBHOPHHAPAHOOHA7HOMBHPHOHOMBHPHOHOMBHOHOHOMBHOHOHOMBHOHOHOMBHOPPHOMBHOOHA7PHOHPHOHP7HOHOHOHOHOHOHOHOHOHOHOHAHOHOHOPAHOHOHOODPPHOPHMHPPBAHOHOPPBAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOHOMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBOHPHHOMBMDODPPAAHA2PPAAHA3OAAHA3OOHPHOHAOP5APHOHOHOMHHOHOHOODHOHOHAPHHOPPAPHAHOHOAOHAHOHOHOHAHOHOHOHAHGHOHOHAPPHOPPHAOPHOOHA7IDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHHIDAAP2DIDAAOHOBA7HOMBOHMBHOMBHOMBHOMBHOMBHOMBHOMBHOMBHOMBP2BHOMBOPPAHOMBA7PAIPHOHAHAOPHOHAHAHOHOHOHAHOHOHOHAHOHOHOP9OPPHOHA8OAAMDA2OAAODA2OAAOA2OPOHPDOP5DPPHOHOOAHOHOHOOAHOHOPPOAHOHAHAOAHAHAHAOAHAHA4HAPHHAOAHOPPHAOAHOHOHAOAHOHOHAOAHOHOHAOAPHHA6HA6HA6HAP2APHHAP2BPPHAHOMBHOHAHOMBHOHAHOMBHOA23OHPHOPPDP6HHOHOHOH2OHOHOH2OHOHOHAHOPPOAHOHOHAOAHOHOHOOAHOHOHOOAHOHOHOOAHOP3OAPPOPOHOAOPA6OHOHAOAPDHOHAOAPHHOHAOAHOHOHAOAHOHOHAOAHOHOHAOAHOHOHAOAHOA3OA2HAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOA7HOHOHOHAHOHOHOHAHOHOHOHAHOHOHOHAHOHOHOHAP5HAOHPHOPHA2HAAOA7HOA5PPA5OHA43PA6PA6HA108HAAOA3HAAOA3HAAOA43OA6OA6OA4OHPDHOHOP2DHOHOHOOAHOHOHAOAHOHOPAOAHOHOA23HOMBHOHOHOMBHOHOHOMBHOHOHOMBHOHOHOMBHOHOAAHAOA4HAOA4HAHA2PPHA4PPHA2MAAOHA2MAAOHA2PDAPHA2PDA5OHA5PPA5HOA5HOA6OA6PAAPDAAIHAAPDAAMDODOAHOHOMHOAHOHOAPOAHOHOAOOAHOHOHOOAHOHGPPOBP2HOHMBOPODA7HOMBOHHOHOMBMDHOHOMBOHHOHOMBHOHOHOMBHOP4BHOOPOPPAHOAOA6OMHHA2MAODHA2MAPAHA4HAHA4HA6PPHA4PPHA18OBA5OA6OA8OA2HAOAOA2HAOAHA2HAOA78HOA5PPA5OHA167OHIHOHOHPPMHP3HOOHHOHOHOPHHOHOHOHHAOAOHOAHAPAOHOAHMHIHHOAHODIPHA2PPOHHA2P3HA2HOHOHOAAHOHOHOAAHAHAHOAAHAHAHOAAPHPDPPBAP2HPPOHOHAAP5AAHOHOHOAAHOHOHOA2OHOHOA2PHOHOAAIHOHHOHAMDP3HAIBMPDAAOMDOPHAAOGGHAOAAPAADAMAAHOHDLNAAHPPLPNAIHHOLJNAIDHOLJNAMDHOAHPAAOHOAHHAAOHOAHHAHOHOAHHAHOHOAHHAHOPPAHP3OHAHPPOHA7OPBAAOHOAOA2OHOAOAAHOHOAOAAHOHOAOAAHOHOAOAAP3AOAAOHOHA7OBHOOPHAOAHOAOAAOAHOAOAAOAHOHOAAOAHOHOHAOAP3HAOAOHOHHA8HOLJNAMBHOLPNAMBHODLPAOAHODAHAOAHOHA2PAPPOPBAHAOHMPBAHA1032"

-- font data {"A", sprite number, page?, num sprites x, y, width (px), height}
fontd={	{0,0,1,2,8,16},{1,0,1,2,8,16},{2,0,1,2,8,16},{3,0,1,2,8,16},{4,0,1,2,8,16},{5,0,1,2,8,16},{6,0,1,2,8,16},{7,0,1,2,8,16},{8,0,1,2,3,16},{9,0,1,2,5,16},{10,0,1,2,8,16},{11,0,1,2,7,16},{12,0,2,2,13,16},{14,0,1,2,8,16},{15,0,1,2,8,16},
		{128,0,1,2,8,16},{129,0,1,2,8,16},{130,0,1,2,8,16},{131,0,1,2,8,16},{132,0,2,2,9,16},{134,0,1,2,8,16},{135,0,1,2,8,16},{136,0,2,2,13,16},{138,0,1,2,8,16},{139,0,1,2,7,16},{140,0,1,2,8,16},{141,0,1,2,8,16},{142,0,1,2,8,16},{143,0,1,2,8,16},
		{256,0,1,2,8,16},{257,0,1,2,8,16},{258,0,1,2,6,19},{259,0,1,3,8,16},{260,0,1,2,8,16},{261,0,1,2,3,19},{262,0,1,3,4,16},{263,0,1,2,8,16},{264,0,1,2,3,16},{265,0,2,2,13,16},{267,0,1,2,8,16},{268,0,1,3,8,19},{269,0,1,3,8,19},{270,0,1,3,8,16},{271,0,1,2,7,16},
		{448,0,1,2,8,16},{449,0,1,2,6,16},{450,0,1,2,8,16},{451,0,1,2,8,16},{452,0,2,2,13,16},{454,0,1,2,8,19},{455,0,1,3,8,16},{456,0,1,2,8,16},{457,0,1,2,3,16},{458,0,1,2,4,16},{459,0,1,2,6,16},{460,0,1,2,4,16},{461,0,1,2,6,16},{462,0,1,2,3,16},{463,0,1,2,8,16},
		{640,0,1,2,8,16},{641,0,1,2,7,16},{642,0,1,2,8,16},{643,0,1,2,8,16},{644,0,2,2,9,16},{646,0,1,2,8,16},{647,0,1,2,8,16},{648,0,1,2,8,16},{649,0,1,2,8,16},{650,0,1,2,8,16},{651,0,1,2,3,16},{652,0,1,2,8,16},{653,0,2,2,12,16},{655,0,1,2,8,16},
		{768,0,1,2,8,16}
	}

-- this could be useful for compression later
font = {}
chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!'+,-.?0123456789:=@/ "

-- the rle decoder
function tomem(str)
  local o=tonumber(str:sub(1,5),16) -- get (o)ffset
  local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
  local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end

function font_init()
	for i=1,#fontd do
		font[string.sub(chars,i,i)] = fontd[i]
	end
end

function flength(txt,kx)
	kx = kx or 1
	pcx = 0
	letter ={}
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		-- update kerning
		pcx = pcx + letter[5] + kx
	end
	return pcx
end

-- fprint ("text", x, y, [x kerning = 1],[y kerning = 1], [colour = 15])
function fprint(txt,tx,ty,kx,ky,tc)
	kx = kx or 1
	ky = ky or 1
	tc = tc or 10
	pcx = 0
	pcy = 0
	letter ={}
	-- set to blit segment (8 = BG-1)
	poke4(2*0x03ffc,8)
	-- set colour
	poke4(2*0x03FF0 + 1, tc)
	-- print each letter
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		spr(letter[1],tx+pcx,ty+pcy,0,1,0,0,letter[3],letter[4])

		-- update kerning
		pcx = pcx + letter[5] + kx
	end
end

function drawtext(text,ypos)
    local tl = text
    local tlg
    for i=1,#tl do
	    -- get length
	    tlg = flength(tl[i])
	    -- draw line of text
	    fprint(tl[i],120-(tlg/2),ypos+(20*(i-#tl/2)))
    end
end

-- OPTIONAL STUFF - NOT NEEDED FOR DEMO!

function viewer()
	if m==2 and r>0 then r=0 end
	if m==4 and r>16 then r=16 end
	if t==0 then s=r else s=r+(128*m) end
	poke4(2*0x03ffc,m)
	cls(0)
	for y = 0,128-8,8 do
	  for x = 0,(m*64)-8,8 do
		spr(s,x+56,y+4) s=s+1
	  end
	end
	rect(184,2,56,132,00)
	rectb(54,2,132,132,10)
	print(" bg  fg",4,8,15)
	print("(   )",4+(t*20),8,15)
	print("page: "..(r//16),4,16,15)
	print("mode: "..m,4,24,15)
	print("CTRL\n toggle\n Tiles or\n Sprites",4,40,15,false,1,true)
	print("Up/Down\n switch\n color\n mode",4,70,15,false,1,true)
	print("Left/Right\n switch\n pages",4,100,15,false,1,true)
end

function parts()
	if part > 5 then part = 0 end
	if part < 0 then part = 5 end
	if part == 0 then
	 cls(0)
	 drawtext({"This is some", "TIC-80 Stuff", "at Nova..."},50)
	end
	if part == 1 then
	 cls(0)
	 print("WE SEND SOME GREETINGS TO:",49,30,6)
	 print("* FIELD-FX CREW",68,48,9)
	 print("* NOVA ORGAS",68,60,10)
	 print("* BRITISH LIFE GUARD",68,72,12)
	 print("* BEER SUPPLIERS",68,84,13)
	 print("* ALL PARTICIPANTS",68,96,14)
	end
	if part == 2 then
	 cls(0)
	 print("CODING BY:",69,20,12)
	 drawtext({"Mantratronic", "T=Bach", "Jtruk", "Jynx"},50)
	end
	if part == 3 then
	 cls(0)
	 print("PIXELS BY:",81,40,12)
	 drawtext({"Bossmann", "Decca"},50)
	end
	if part == 4 then
		cls(0)
		print("MUSIC BY:",92,50,12)
		drawtext({"T=Bach"},50)
	end
	if part == 5 then
	 cls(0)
	 drawtext({"RiFT IN 2023"},40)
	 print("MAY THE DEMOLITION",70,72,13)
	 print("BE WITH YOU.",70,80,14)	
	end
end

-- initialize
cls(0)
tomem(inf_rle)
tomem(nuc_rle)
font_init()
parts()

function TIC()
	-- switch screens
	if keyp(48,60,6) then part=part+1 parts() end
	if keyp(51,60,6) then part=part-1 parts() end
end
