-- title:  All Fonts (raw / unpacked)
-- author: Mantratronic / RiFT
-- artist: Decca / RiFT
-- desc:   font writer@demo framework
-- script: lua

-- init vars
part = 0 -- part time lover

-- informics 7x7
local inf_raw = "28E088000000000000000003030303000300000b1b1900000000000a0f1a0a0f1a0000040e170c1f0400000d0c0606030b00000c061e3b1b1e2000030301000000000006030303030600000306060606030000000e0f1f1f1e000000000207020000000000000303010000000000070000000000000000030300000c0c0606030300000e0b1d1b1b1e000006070606060f0000070c0603030e0000070c0e0c0c070000010d0d0e1c0c00000f01070c0c0700000e130f0b1b1e00000f181c06060600000e0b1e0b1b1e00000e0b1b1e181f00000003030003030000000300030301000000040e1f1e140000000007000700000000040f0f1f0400000f081e06000600000e01151d010e00000e0b1b1f1b1b10000f0b1f0b1b1f00000e130303030e10000f0b1b1b1b1f00000e130703030e10000e130703030300000e13030b131e10000b1b1f1b1b1b100003030303030300000f0c0c0c0c0700000b1b0f0b1b1b100003030303030e10000e1b2b2b232320000f0b1b1b1b1b10000e0b1b1b1b1e00000f0b1b1f03030000060b0b0b0b0e10000f0b1b1f0b1b10000e130e08181f00000f060606060600000b1b1b1b1b1e00000b1b1b1b1a04000001313535353e10000b1b1b1e0b1b10000b1b1b1e060600000f181e03030f1000000000000000000000000000000000000000000000000000000000000000000000000000000000000"

-- nucampi 8x16 (ToBach edition)
local nuc_raw = "0800020e7f7e7f7ffffffff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7eff707efff7707effefe77effffff7e70707e7e70707e7e70707e7e70707e7ef3f370fff3f37fff70c17e7070c17e7070c17e7070c17e7070c17e7070c17e7070c1f77070c1f370fff07ee7fff17eff7ec17e7e7ec1fe7e7ec1fe7e7ec1ff7e7ec1ff7e7ec1ff7eff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7effffff7ef7e7f70000000070707f7e70707e7e70707e7e70707e7e70707e7eff70ff7eff70ef7e0000000070c1f77070c17e7070c17e7070c17e7070c17e7070f17ef770f07ee7000000007ec17f7e7ec17f7e7ec17e7e7ec17e7e7ec17e7e7ec17eff7ec17ee700000000f7e7f7e7ffffffff7e7e7e7e7e7e7e7e7e7e7e707e7e7ef07e7e7ee3ff7ef7c7ff107e7eff107e7e83007e7e83007e7e83007e7e83007e7e83007e7e83007e7e7ec17e777ec17e777ec17e777ec17e777ec17e777ec17e777ec1e7f77ec1c3e3ff007000ff0070000e0070000ee7f7e70effffff0f7e7e7ec77e7e7ee37e7e70f77eff0f707e7e0e707e7e7e707e7e7e70767e7e70ff7eff70ef7ee70000000083007e7e83007e7e83007e7e83007e7e83007e778300fff38300e7e1000000007ec1e7c17ec17ec17ec17ec17ec17ec17ec17ec1fff17ec1eff07ec100000000f08f7e7070ef7e70707e7e7e707e7e7e707e7e7effffffffffeff7e7000000000e00c3000e00e3000e00e000efe7f3effffff3ff7e7ee07e7e7ee07e7effe07e7070e0707070e07070000070f770e07eff70e07e7e70e07e7e70e07e7e70e0f770000000700000007000000070fff0f770fff1ff707ec17e707ec17e707ec17e000000000000000000000000e7f7eff3fffffff77e7e7e777e7e7e777e7e7e707effe07e7e70e07e7e7ee07e7e7ee07e7e7ee07effffe0ffefe7e0ef0000000e7e70e0f37e70e0f77e70e07e7e70e07e7e70e07e7e70e07e7e70e07e0000e000707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e000000007e7e7e707e7e7e707e7e7e707e7e7e707e7e7e70ffffff70e7f7ef7000700e000000007e000000ff000000e700000000000000000000000000000000000000000000f0000000f000000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700e0000700e0000700e00000000000000000000000000000000000000000000e0000000e0000000e00000e7f37e7efff37e7e7ee07e7e70e07e7ef0e07e7e0000000000000000000000007ec17e7e7ec17e7e7ec17e7e7ec17e7e7ec17e7e0070e0000070e00000707000ff700000ff7000c00e7000c00e7000f30f7000f3000000e7000000ff0000007e0000007e0000000e0000000f00f3008700f300c3e3e07e7ec7e07e7e0fe07e7e0ee07e7e7ee07e76ffe1fff7e7c1efe3000000007ec1e77e7ec1c37e7ec1e77e7ec17e7e7ec17efffff17eefeff07e0e0000000ec77000c0e37000c0f07000007070000070000000ff700000ff70000000000000000000e1000000e0000000e000000000e00070e0e00070e0700070e00000000000000000000000000000000000000000000000000000000000000000000000000000007e000000ff000000e7000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e787e7e7ffc7ffff7ee77e7e7ef77e7e7e770e0e7e070f0e7e07c7877e07e38f7000ffe77000ffff70007e7e7e007e7e7e0070707e0070707e00f7f3ff10fff7ffe7e700ffffff007e7e7e007e7e7e000e7e7e000f7e7e0087e77e70c3ffff7081cf300ec3ef700e6670e00f0030c007e73bd007ffbfd0877eb9d0837eb9d0c37e07f00e7e07700e7e07707e7e07707e7e07707eff07ffffe707ffe700000000ef100e7e0e000e7e0e007e7e0e007e7e0e007e7e0e00ffff0e00e7e700000000e17eef70e07e0e00e07e0e00e07e7e00e07e7e70e0ffff70e0e7e770000000007eb9d0c17ebfd0c17e3bf0e07e3070e07e7000f0ffef1070e7cf1070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"

-- font data {"A", sprite number, page?, num sprites x, y, width (px), height}
fontd={	{0,0,1,2,8,16},{1,0,1,2,8,16},{2,0,1,2,8,16},{3,0,1,2,8,16},{4,0,1,2,8,16},{5,0,1,2,8,16},{6,0,1,2,8,16},{7,0,1,2,8,16},{8,0,1,2,3,16},{9,0,1,2,5,16},{10,0,1,2,8,16},{11,0,1,2,7,16},{12,0,2,2,13,16},{14,0,1,2,8,16},{15,0,1,2,8,16},
		{128,0,1,2,8,16},{129,0,1,2,8,16},{130,0,1,2,8,16},{131,0,1,2,8,16},{132,0,2,2,9,16},{134,0,1,2,8,16},{135,0,1,2,8,16},{136,0,2,2,13,16},{138,0,1,2,8,16},{139,0,1,2,7,16},{140,0,1,2,8,16},{141,0,1,2,8,16},{142,0,1,2,8,16},{143,0,1,2,8,16},
		{256,0,1,2,8,16},{257,0,1,2,8,16},{258,0,1,2,6,19},{259,0,1,3,8,16},{260,0,1,2,8,16},{261,0,1,2,3,19},{262,0,1,3,4,16},{263,0,1,2,8,16},{264,0,1,2,3,16},{265,0,2,2,13,16},{267,0,1,2,8,16},{268,0,1,3,8,19},{269,0,1,3,8,19},{270,0,1,3,8,16},{271,0,1,2,7,16},
		{448,0,1,2,8,16},{449,0,1,2,6,16},{450,0,1,2,8,16},{451,0,1,2,8,16},{452,0,2,2,13,16},{454,0,1,2,8,19},{455,0,1,3,8,16},{456,0,1,2,8,16},{457,0,1,2,3,16},{458,0,1,2,4,16},{459,0,1,2,6,16},{460,0,1,2,4,16},{461,0,1,2,6,16},{462,0,1,2,3,16},{463,0,1,2,8,16},
		{640,0,1,2,8,16},{641,0,1,2,7,16},{642,0,1,2,8,16},{643,0,1,2,8,16},{644,0,2,2,9,16},{646,0,1,2,8,16},{647,0,1,2,8,16},{648,0,1,2,8,16},{649,0,1,2,8,16},{650,0,1,2,8,16},{651,0,1,2,3,16},{652,0,1,2,8,16},{653,0,2,2,12,16},{655,0,1,2,8,16},
		{768,0,1,2,8,16}
	}

-- this could be useful for compression later
font = {}
chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!'+,-.?0123456789:=@/ "

-- the raw decoder
function tomem(str)
	local tnb=tonumber
	local o=tnb(str:sub(1,5),16) -- get (o)ffset
	local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
	local d=str:sub(8,str:len()) -- remove header to get (d)ata
	local y=0
	for x = 1,#d,1 do -- write to mem
	  local c=tnb(d:sub(x,x),16) -- get (c)olor value
	  poke4(o+y,c) y=y+1
	  if y>w then y=0 o=o+1024 end
	end
  end

function font_init()
	for i=1,#fontd do
		font[string.sub(chars,i,i)] = fontd[i]
	end
end

function flength(txt,kx)
	kx = kx or 1
	pcx = 0
	letter ={}
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		-- update kerning
		pcx = pcx + letter[5] + kx
	end
	return pcx
end

-- fprint ("text", x, y, [x kerning = 1],[y kerning = 1], [colour = 15])
function fprint(txt,tx,ty,kx,ky,tc)
	kx = kx or 1
	ky = ky or 1
	tc = tc or 10
	pcx = 0
	pcy = 0
	letter ={}
	-- set to blit segment (8 = BG-1)
	poke4(2*0x03ffc,8)
	-- set colour
	poke4(2*0x03FF0 + 1, tc)
	-- print each letter
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		spr(letter[1],tx+pcx,ty+pcy,0,1,0,0,letter[3],letter[4])

		-- update kerning
		pcx = pcx + letter[5] + kx
	end
end

function drawtext(text,ypos)
    local tl = text
    local tlg
    for i=1,#tl do
	    -- get length
	    tlg = flength(tl[i])
	    -- draw line of text
	    fprint(tl[i],120-(tlg/2),ypos+(20*(i-#tl/2)))
    end
end

-- OPTIONAL STUFF - NOT NEEDED FOR DEMO!

function parts()
	if part > 5 then part = 0 end
	if part < 0 then part = 5 end
	if part == 0 then
	 cls(0)
	 drawtext({"This is some", "TIC-80 Stuff", "at Nova..."},50)
	end
	if part == 1 then
	 cls(0)
	 print("WE SEND SOME GREETINGS TO:",49,30,6)
	 print("* FIELD-FX CREW",68,48,9)
	 print("* NOVA ORGAS",68,60,10)
	 print("* BRITISH LIFE GUARD",68,72,12)
	 print("* BEER SUPPLIERS",68,84,13)
	 print("* ALL PARTICIPANTS",68,96,14)
	end
	if part == 2 then
	 cls(0)
	 print("CODING BY:",69,20,12)
	 drawtext({"Mantratronic", "T=Bach", "Jtruk", "Jynx"},50)
	end
	if part == 3 then
	 cls(0)
	 print("PIXELS BY:",81,40,12)
	 drawtext({"Bossmann", "Decca"},50)
	end
	if part == 4 then
		cls(0)
		print("MUSIC BY:",92,50,12)
		drawtext({"T=Bach"},50)
	end
	if part == 5 then
	 cls(0)
	 drawtext({"RiFT IN 2023"},40)
	 print("MAY THE DEMOLITION",70,72,13)
	 print("BE WITH YOU.",70,80,14)	
	end
end

-- initialize
cls(0)
tomem(inf_raw)
tomem(nuc_raw)
font_init()
parts()

function TIC()
	if keyp(48,60,6) then part=part+1 parts() end
	if keyp(51,60,6) then part=part-1 parts() end
end
