-- title: Christmas Tree
-- author: Wojciech Graj
-- desc: Lovebyte 2023 256B submission
-- website: https://github.com/wojciech-graj/lovebyte2023
-- license: BSL-1.0 License
-- script: lua

--          Copyright Wojciech Graj 2022-2023.
-- Distributed under the Boost Software License, Version 1.0.
--    (See accompanying file LICENSE or copy at
--          https://www.boost.org/LICENSE_1_0.txt)

frame = 0
lamps = {}
cls()

-- draw pot
rect(112, 112, 16, 24, 9)

function TIC()
   frame = frame + 1
   if frame < 120 then
      for z = 3, 23 do
--{
         -- set green palette
         poke(16320 + z, #{ [z % 3] = 0 } * z * 9)

         -- draw tree
         y = math.random(16, 112)
--}
--{
         x = math.random(16 - y, y - 16) * .3
         yf = y + math.random(0, 23)
--}
--{
         lamps[frame + z] = {x * 1.5 + 120, yf}
         line(x + 120, y, x * 1.5 + 120, yf, math.random(1, 7))
--}
      end
   else
      if frame % 4 == 0 then
         -- draw lamps
         for i, lamp in pairs(lamps) do
            pix(lamp[1], lamp[2], math.random(7, 16))
         end

         -- draw star
         line(120 + 4 * math.tan(math.sin(frame)),
            16 + 4 * math.tan(math.cos(frame)),
            120 - 4 * math.tan(math.sin(frame)),
            16 - 4 * math.tan(math.cos(frame)),
            math.random(14,16))
      end
   end
end

-- <PALETTE>
-- 000:140c1c44243430346d4e4a4f854c30346524d04648757161597dced27d2c8595a16daa2cd2aa996dc2cadad45edeeed6
-- </PALETTE>
