-- title: Bobbing Spheres
-- author: Wojciech Graj
-- desc: Lovebyte 2023 256B submission
-- website: https://github.com/wojciech-graj/lovebyte2023
-- license: BSL-1.0 License
-- script: lua

--          Copyright Wojciech Graj 2022-2023.
-- Distributed under the Boost Software License, Version 1.0.
--    (See accompanying file LICENSE or copy at
--          https://www.boost.org/LICENSE_1_0.txt)

function TIC()
   cls()
   t = time() / 499
   points = {}

   i = 0
   for x = -25, 25, 4 do
      for y = -25, 25, 4 do
         for z = -25, 25, 4 do
            table.insert(points, {x * math.cos(t / 2) + z * math.sin(t / 2),
               ({
                  y + x * math.sin(t) / 9 * z,
                  y * math.sin(t + x * z % 3),
                  y + (x + z) * math.sin(t),
                  y + 9 * math.sin(x + t),
                  25 * math.sin(y + t),
                  y + x * math.sin(t) / 9 * y,
                  y * math.sin(t + x + z),
                  y + math.tan(t + y)
               })[t // 6.28 % 8 + 1],
               z * math.cos(t / 2) - x * math.sin(t / 2) + 400,
               i})
            i = i + 1
         end
      end
   end

   table.sort(points,
      function (a, b) return a[3] > b[3] end)

   for _, point in ipairs(points) do
      circ(120 + 600 * point[1] / point[3],
           68 + 600 * point[2] / point[3],
           2,
           point[4])
   end
end

-- <PALETTE>
-- 000:140c1c44243430346d4e4a4f854c30346524d04648757161597dced27d2c8595a16daa2cd2aa996dc2cadad45edeeed6
-- </PALETTE>
