-- Actions
-- immediate actions execute and don't block
-- duration actions execute and block for the duration
-- p=platform (t, p, or omitted)
-- a='omake' (immediate) c=class k=key t=type x,z=position
-- a='cset' (immediate) x=position
-- a='cmove' (duration) x=position (ts=tstamp, d=duration, or default)
-- a='tstamp' (immediate) id (must be unique)
-- a='wait' (duration) t=time
-- a='speak' (duration) c=character t=text (ts=tstamp, d=duration, or default)
-- a='chyron' (immediate) t=text
-- a='effect' (immediate) e=effect
SCRIPT = {    
    {a='omake',k='mick',c=ObjActor,t='mick',x=-50,z=1},
    {a='omake',k='katie',c=ObjActor,t='katie',x=50,z=1},
    {a='omake',k='scientist',c=ObjActor,t='scientist',x=300,z=1},
    {a='omake',k='screen',c=ObjScreen,e='blank',w=OBJSCREEN_W,h=OBJSCREEN_H,x=225,z=.9},
    {a='wait',d=60},
    {a='speak',c='katie',t="Hello!"},
    {a='speak',c='mick',t="HELLO!"},
    {a='speak',c='katie',t="And welcome to Fantasy Console News"},
    {a='aanim',c='mick',m={ela=0,eld=1,era=0,erd=1}},
    {a='speak',c='katie',t="I'm your host"},
    {a='chyron',t=HOST_F},
    {a='speak',c='katie',t=HOST_Fs,d=100},
    {a='aanim',c='mick',m={ela=0,eld=0,era=0,erd=0}},
    {a='aanim',c='katie',m={ela=0.5,eld=1,era=0.5,erd=1}},
    {a='speak',c='mick',t="And I'm your other host"},
    {a='chyron',t=HOST_M},
    {a='speak',c='mick',t=HOST_Ms,d=100},
    {a='aanim',c='katie',m={ela=0.5,eld=0,era=0.5,erd=0}},
    {a='speak',c='mick',t="Today we've got an exciting feature"},
    {a='speak',c='katie',t="It's technology"},
    {a='speak',c='mick',t="It's community"},
    {a='speak',c='katie',t="It's an opportunity to get involved"},
    {a='speak',c='mick',t="To be creative"},
    {a='speak',c='katie',t="To learn"},
    {a='speak',c='mick',t="And it'll be a lot of fun!"},
    {a='speak',c='mick',t="First, something you might know about"},
    {a='speak',c='mick',t="...but if not..."},
    {a='speak',c='mick',t="...hold onto your seat!"},
    {a='speak',c='mick',t="THE DEMOSCENE!"},
    {a='speak',c='katie',t="Way back when the internet was a pixel in Tim Berners-Lee's eye."},
    {a='speak',c='katie',t="Smart folks would make things to show off their skills."},
    {a='speak',c='katie',t="Trying to create amazing effects, for satisfaction, and glory."},
    {a='speak',c='mick',t="One challenge would be squeezing lots into a tiny program."},
    {a='speak',c='mick',t="We now call this 'sizecoding'"},
    {a='speak',c='katie',t="Oh, that'd be fun to try!"},
    {a='speak',c='mick',t="It sure would!"},
    {a='speak',c='katie',t="And you can learn how, with..."},
    {a='speak',c='katie',t="TINY"},
    {a='speak',c='katie',t="CODE"},
    {a='speak',c='katie',t="CHRISTMAS"},
    {a='speak',c='mick',t="Oooooh!"},
    {a='speak',c='mick',t="So... How?"},
    {a='speak',c='katie',t="We ought to introduce Fantasy Consoles..."},
    {a='speak',c='katie',t="These are cute, pretend machines which run inside your computer."},
    {p='p',a='speak',c='katie',t="One of these is called PICO-8 and our hexpert will tell us more.",p=120},
    {p='t',a='speak',c='katie',t="One of these is called TIC-80 and our hexpert will tell us more.",p=120},
    {a='cmove',x=250},
    {a='speak',c='scientist',t="Oh, heh, hello."},
    {a='omake',k='fireplace',c=ObjDecor,t='fireplace',x=0,z=.8},
    {a='chyron',t=HOST_S},
    {p='p',a='speak',c='scientist',t="Yes, yes. Let me tell you about PICO-8",d=120},
    {p='p',a='speak',c='scientist',t="It has a feisty 128x128 screen with 16 colours.",d=120},
    {p='p',a='speak',c='scientist',t="4 channel beepy-boop sound.",d=120},
    {p='p',a='speak',c='scientist',t="Built-in code editor, graphics and music tools.",d=120},
    {p='p',a='speak',c='scientist',t="And it runs on Lua, a friendly programming language.",d=120},
    {p='p',a='speak',c='scientist',t="There's also a Fantasy Console called TIC-80",d=120},
    {p='t',a='speak',c='scientist',t="Yes, yes. Let me tell you about TIC-80",d=120},
    {p='t',a='speak',c='scientist',t="It has a bubbly 240x136 screen with 16 colours.",d=120},
    {p='t',a='speak',c='scientist',t="4 channel bloopy-beep sound.",d=120},
    {p='t',a='speak',c='scientist',t="Built-in code editor, graphics and music tools.",d=120},
    {p='t',a='speak',c='scientist',t="And it can run Lua, a friendly programming language.",d=120},
    {p='t',a='speak',c='scientist',t="There's also a Fantasy Console called PICO-8",d=120},
    {a='speak',c='scientist',t="They're free and easy to get started with."},
    {a='speak',c='scientist',t="(Though the developers like donations!)"},
    {a='speak',c='scientist',t="And they're a lot of fun!"},
    {a='cmove',x=0},
    {a='speak',c='katie',t="So... what's Tiny Code Christmas?"},
    {a='speak',c='mick',t="Great question!"},
    {a='speak',c='mick',t="It's a series of twelve tutorials, to make pretty things on a screen."},
    {a='speak',c='mick',t="Each day, you'll learn something new, and make something new."},
    {a='speak',c='mick',t="And by the end of the twelve days, you'll be inspired to make your own things."},
    {a='speak',c='katie',t="What sort of things will I be making?"},
    {a='cmove',x=250},
    {a='omake',k='candles',c=ObjDecor,t='candles',x=0,z=.801},
    {a='aanim',c='scientist',m={ela=0.5,eld=1,era=0.5,erd=1}},
    {a='speak',c='scientist',t="here's one - it's called a plasma."},
    {a='effect',k='screen',e='plasma'},
    {a='wait',d=100},
    {a='aanim',c='scientist',m={ela=0.5,eld=0,era=0.5,erd=0}},
    {a='cmove',x=100},
    {a='speak',c='katie',t="Neat!"},
    {a='cmove',x=250},
    {a='omake',k='leftstocking',c=ObjDecor,t='leftstocking',x=0,z=.802},
    {a='speak',c='scientist',t="Yes! And you'll learn how to make your own!"},
    {a='speak',c='scientist',t="And the best thing is sharing your creations on social networks."},
    {a='speak',c='scientist',t="And seeing everyone else's"},
    {a='speak',c='scientist',t="Last year's participants made such a great community!"},
    --[[
    {a='speak',c='scientist',t="(a: sends tweet)"},
    {a='speak',c='scientist',t="(b: looks at phone)"},
    {a='speak',c='scientist',t="(a: beat)"},
    {a='speak',c='scientist',t="(b: tweet beeps/ read)"},
    {a='speak',c='scientist',t="(a: beat)"},
    {a='speak',c='scientist',t="(b: writes something nice)"},
    {a='speak',c='scientist',t="(a: tweet beeps/ read)"},
    {a='speak',c='scientist',t="(b: beat)"},
    --]]
    {a='cmove',x=0},
    {a='speak',c='mick',t="So, what else will we make?"},
    {a='cmove',x=250},
    {a='effect',k='screen',e='tunnel'},
    {a='aanim',c='scientist',m={ela=0.5,eld=1,era=0.5,erd=1}},
    {a='speak',c='scientist',t="There are lots of effects, like this tunnel."},
    {a='wait',d=100},
    {a='aanim',c='scientist',m={ela=0.5,eld=0,era=0.5,erd=0}},
    {a='cmove',x=0},
    {a='speak',c='katie',t="Ooh, that's trippy!"},
    {a='speak',c='mick',t="And I can take part with PICO-8 or TIC-80?"},
    {a='effect',k='screen',e='blank'},
    {a='speak',c='mick',t="How do I choose between them?"},
    {a='cmove',x=250},
    {a='omake',k='rightstocking',c=ObjDecor,t='rightstocking',x=0,z=.803},
    {a='speak',c='scientist',t="It's personal preference. TIC might be easier, but PICO is cuter."},
    {a='cmove',x=0},
    {a='speak',c='mick',t="And if I really can't choose?"},
    {a='omake',k='ps',c=ObjActor,t='ps',x=-150,z=1},
    {a='cmove',x=-100},
    {a='speak',c='ps',t="Why not both"},
    {a='omake',k='tree',c=ObjDecor,t='tree',x=135,z=.8},
    {a='wait',d=20},
    {a='aanim',c='mick',m={ela=0.5,eld=1,era=0.5,erd=1}},
    {a='wait',d=80},
    {a='aanim',c='mick',m={ela=0,eld=1,era=0,erd=1}},
    {a='cmove',x=250},
    {a='aanim',c='scientist',m={ela=0.25,eld=1,era=0.25,erd=1}},
    {a='speak',c='scientist',t="That's how they get you!"},
    {a='aanim',c='mick',m={ela=0,eld=0,era=0,erd=0}},
    {a='cmove',x=100},
    {a='aanim',c='scientist',m={ela=0.25,eld=0,era=0.25,erd=0}},
    {a='speak',c='katie',t="But what if I took part last year, or I already know some of this stuff?"},
    {a='cmove',x=250},
    {a='speak',c='scientist',t="The TCC Elves already thought of that!"},
    {a='speak',c='scientist',t="You can still take part, and there are advanced challenges"},
    {a='cmove',x=0},
    {a='speak',c='katie',t="So I can stretch my skills?"},
    {a='speak',c='katie',t="Nice!"},
    {a='speak',c='mick',t="So. If this sounds good, then make sure you're ready to take notes..."},
    {a='cmove',x=250},
    {a='speak',c='scientist',t="Yes, yes! Pen, pencil, or pixel."},
    {a='cmove',x=0},
    {a='omake',k='baubles',c=ObjDecor,t='baubles',x=135,z=.801},
    {a='speak',c='katie',t="In summary:"},
    {a='speak',c='mick',t="The demoscene is a community of people creating things on computers."},
    {a='speak',c='katie',t="PICO-8 and TIC-80 are Fantasy Consoles, which are cute, pretend computers."},
    {a='speak',c='mick',t="Tiny Code Christmas is a lovely, warm set of tutorials."},
    {a='speak',c='katie',t="There's a big, friendly group of people, keen to help you play!"},
    {a='speak',c='mick',t="That all sounds good."},
    {a='speak',c='katie',t="Very good indeed."},
    {a='speak',c='mick',t="Where do I find out more?"},
    {a='speak',c='katie',t="There's a website..."},
    {a='cmove',x=250},
    {a='speak',c='scientist',t="(Are you ready to take those notes?)"},
    {a='cmove',x=0},
    {a='speak',c='katie',t="tcc.lovebyte.party"},
    {a='speak',c='mick',t="Tiny Code Christmas runs from 11th-22nd December"},
    {a='speak',c='katie',t="And you can share on the LOVEBYTETCC hashtag"},
    {a='speak',c='mick',t="That's all for now!"},
    {a='speak',c='katie',t="Hope you have a lovely, maybe Tiny, Christmas!"},
    {a='cmove',x=250},
    {a='speak',c='scientist',t="Bye!"},
    {a='speak',c='scientist',t="Yes, yes. Bye!"},
    {a='cmove',x=-120},
    {a='speak',c='ps',t="Thanks for watching"},
    {a='speak',c='ps',t="Bye bye everybody"},
    {a='speak',c='ps',t="Have a great day!"},
    {a='wait',d=50},
}