StageSync = {}
StageSync.__index = StageSync

-- aTime: initial time, and time when A is pressed
-- bTime: time when b is pressed
function StageSync:new(aTime, bTime)
    local o = {}
    setmetatable(o, StageSync)
    -- Set a little in the future, on a 10s boundary, with 10s leeway
    o.startTime = flrdiv(getTSync(),10)*10+20
    o.timeShifted = 0
    o.lastSecond = nil
    o.microAdjust = 0
    o.adjustedTime = nil
    o.flash = false
    return o
end

function StageSync:update()
    if dBtnP(0) then
        self.microAdjust = self.microAdjust - 1
    elseif dBtnP(1) then
        self.microAdjust = self.microAdjust + 1
    elseif dBtnP(4) then
        self.startTime = self.startTime + 10
    end
    
    local thisSecond = getTSync()
    -- Find the microtime adjustment
    self.flash=false
    self.timeF=dTime()
    if(self.lastSecond ~= thisSecond) then
        self.flash=true
        self.timeShifted = dModfr(self.timeF)
    end
    self.lastSecond = thisSecond
    self.adjustedTime = thisSecond + self.timeShifted - self.microAdjust/60
    return SKIP_STAGE_SYNC or (self.adjustedTime >= self.startTime)
end

function StageSync:draw()
    dCls(0)
    local d=SCRHH*.8
    local a=self.timeF-self.microAdjust/60
    local x,y=-cos(a)*d,sin(a)*d
    local cSize = 60
    dElliF(dPMake(SCRWH,SCRHH),dPMake(cSize,cSize),3)
    line(SCRWH,SCRHH,SCRWH+x,SCRHH+y,7)
    local count=flrdiv(self.startTime-self.adjustedTime,1)
    local w=dPrintW(count)
    dPrint(count,dPMake(0,0),12)
    local drawP=dPMake(SCRWH-w*5/2,SCRHH-5*5/2)
    for y=0,5 do
        for x=0,w do
            local c=dPixGet(dPMakeS(x,y),0)
            if c>0 then
                dRectF(dPAdd(drawP, x*5,y*5),dPMake(4,4),c)
            end
        end
    end
    dRectF(dPMake(SCRWH,SCRH-10),dPMake(self.microAdjust*2,4),2)

    if self.flash then
        dRectF(dPMake(0,0), dPMake(SCRW,16), 7)
    end
end
