Scene = {}
Scene.__index = Scene

function Scene:new()
    local o = {}
    setmetatable(o, Scene)
    o.cam = Camera:new(0)
    o.objs={}
    o.chyron = nil
    return o
end

-- t: type
function Scene:objMake(o)
    self.objs[o.k] = o.c:new(nil,o)
end

function Scene:camSet(x)
    self.cam:set(x)
end

-- in: d = tick duration or nil (default)
-- return the tick duration
function Scene:camMove(x, d)
    d = (d ~= nil) and d or abs(x - self.cam:get().x)/8
    self.cam:move(x, d)
    return d
end

-- in: d = tick duration or nil (default)
-- Can only be used on actors :)
-- return the tick duration
function Scene:speak(char, text, d)
    d = (d ~= nil) and d or (40 + #text * 3.5)
    self.objs[char]:speak(text, d)
    return d
end

function Scene:anim(char, a)
    self.objs[char]:anim(a)
end

function Scene:doChyron(text)
    self.chyron = {text=text,time=200}
end

function Scene:effectSet(k,e)
    self.objs[k]:setEffectKey(e)
end

function Scene:update()
    self.cam:update()
    
    for k,o in pairs(self.objs) do
        o:update()
    end

    if self.chyron then
        self.chyron.time = self.chyron.time - 1
        if self.chyron.time < 0 then
            self.chyron = nil
        end
    end
end

function Scene:draw()
    local camXScr=-self.cam:get().x
    drawBG(camXScr)

    zSort={}
    for k,o in pairs(self.objs) do
        tblAdd(zSort, {k=k, z=self.objs[k].pos.z})
    end
    tblSort(zSort, function(a,b) return a.z < b.z end)

    for _,zObj in pairs(zSort) do
        self.objs[zObj.k]:draw(camXScr*zObj.z)
    end
    for k,v in pairs(self.objs) do
        if v.postDraw then
            v:postDraw()
        end
    end

    if self.chyron then
        local h=dPrintH({self.chyron.text}, 0)
        local yText=SCRH-h-7
        local textP=dPMake(10,yText)
        dRectF(dPMake(0,yText-2),dPMake(SCRW,h+5),3)
        dPrint(self.chyron.text, dPAdd(textP,1,1), 0)
        dPrint(self.chyron.text, textP, 12)
    end
end

function drawBG(shiftX)
    local rw,rh=32,32
    local bgShiftX=flrdiv(shiftX*BG_Z, 1)
    xSqShift=flrdiv(bgShiftX, rw)

    xofs,yofs=bgShiftX%rw,0
    for y=0,4 do
        for x=0,8 do
            local c=(x+xSqShift+y)%2==0 and BG_COL or 2
            local x0,y0=xofs+x*rw-rw,yofs+y*rh
            dRectF(dPMakeS(x0,y0),dPMakeS(rw,rh),c)
        end
    end
end
