import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;

void setup() {
  // Uncomment the following lines for the final submission:
  noCursor();
  pixelDensity(1);
  fullScreen(P3D);

  frameRate(60);

  // This sets the screen size and 2D- or 3D mode
  

  // Parameters:
  // - PApplet
  // - soundtrack filename (relative to sketch's folder)
  // - beats per minute in the song
  // - how many rows in Rocket correspond to one beat (4 or 8 is recommended)
  
  // "Raving Energy" Kevin MacLeod (incompetech.com)
  // Licensed under Creative Commons: By Attribution 4.0 License
  // http://creativecommons.org/licenses/by/4.0/
  moonlander = Moonlander.initWithSoundtrack(this, "data/Raving Energy.mp3", 122, 4);

  // Last thing in setup; start Moonlander. This either
  // connects to Rocket (development mode) or loads data
  // from 'syncdata.rocket' (player mode).
  // Also, in player mode the music playback starts immediately.
  moonlander.start("localhost", 1338, "data/syncdata.rocket");

  background(0);
  noStroke();

}

long lastTime = -1;
// Make an empty array for the dots
ArrayList<Float> dots = new ArrayList<Float>();

void draw() {
  moonlander.update();

  // Drawing goes here

  // Get values from Rocket using
  // float my_value = (float) moonlander.getValue("track_name");
  // or
  // int my_value = moonlander.getIntValue("track_name");

  // Draw a line that extends from the left edge of the screen to the right edge

  // Get current time
  long time = Math.round(moonlander.getCurrentTime() * 1000);
  // Get current scene name from Rocket
  int scene = moonlander.getIntValue("scene");
  // Get x and y values from Rocket
  float x = (float) moonlander.getValue("x") / 1280 * width;
  float y = (float) moonlander.getValue("y") / 720 * height;

  if (time < lastTime) {
    // Rewind, clear screen
    background(0);
  }
  lastTime = time;

  if(scene == 1){
    noStroke();
    // Draw a dot at the current position
    fill(255);
    // Generate a random float between -2 and 2
    float random = random(-2, 2);
    ellipse(x, y + random, 20, 20);
    ellipse(width - x, height - y + random, 20, 20);
    // Add the dot to the array
    dots.add(x);
    dots.add(y + random);
  } else if(scene == 2){
    noStroke();
    // Duplicate the dots below the previous ones
    fill(255 - x % 80);
    // Iterate through the dots
    for(int i = 0; i < dots.size(); i += 2){
      // Draw the dots above
      ellipse(dots.get(i), dots.get(i + 1) + y, 20, 20);
      ellipse(width - dots.get(i), height - dots.get(i + 1) - y, 20, 20);
    }
  } else if(scene == 3){
    noStroke();
    // Draw expanding circles
    for(int i = 0; i < 10; i += 1){
      fill(0);
      ellipse(width / 2, height / 2, x/i, x/i);
      fill(255);
      ellipse(width / 2, height / 2, y/i, y/i);
    }
  } else if(scene == 4){
    background(255);
    // Draw weird lines from the center
    for(int i = 0; i < 100; i += 1){
      float angle = i * TWO_PI / 100 + time / 10000.0;
      float diff = angle + PI / 2;
      float x1 = width / 2 + x * cos(angle) * width;
      float y1 = height / 2 + x * sin(angle) * height;
      float x2 = width / 2 + y * cos(angle + diff) * width;
      float y2 = height / 2 + y * sin(angle + diff) * height;
      strokeWeight(5);
      stroke(0);
      line(x1, y1, x2, y2);
      line(x1, y1, width/2, height/2);
    }
  } else if(scene == 5){
    exit();
  }
}
