;
; LOD Player Version 2
;
F1LO	= $FF0E
F1HI	= $FF12
F2LO	= $FF0F
F2HI	= $FF10

OFF	= $47
	
; COMMAND BYTES

END_MARK	= $FE
SET_VOLTAB	= $FF
ARP		= $FD
STOP_MARK	= $FC
SETINS		= $F0
LEN		= $50

; Constants
base_note = 0 ; shift to C0
C0	= base_note + 0
Ci0	= base_note + 1
D0	= base_note + 2
Di0	= base_note + 3
E0	= base_note + 4
F0	= base_note + 5
Fi0	= base_note + 6
G0	= base_note + 7
Gi0	= base_note + 8
A0	= base_note + 9
Ai0	= base_note + 10
B0	= base_note + 11

C1	= base_note + 12
Ci1	= base_note + 13
D1	= base_note + 14
Di1	= base_note + 15
E1	= base_note + 16
F1	= base_note + 17
Fi1	= base_note + 18
G1	= base_note + 19
Gi1	= base_note + 20
A1	= base_note + 21
Ai1	= base_note + 22
B1	= base_note + 23

C2	= base_note + 24
Ci2	= base_note + 25
D2	= base_note + 26
Di2	= base_note + 27
E2	= base_note + 28
F2	= base_note + 29
Fi2	= base_note + 30
G2	= base_note + 31
Gi2	= base_note + 32
A2	= base_note + 33
Ai2	= base_note + 34
B2	= base_note + 35

C3	= base_note + 36
Ci3	= base_note + 37
D3	= base_note + 38
Di3	= base_note + 39
E3	= base_note + 40
F3	= base_note + 41
Fi3	= base_note + 42
G3	= base_note + 43
Gi3	= base_note + 44
A3	= base_note + 45
Ai3	= base_note + 46
B3	= base_note + 47

C4	= base_note + 48
Ci4	= base_note + 49
D4	= base_note + 50
Di4	= base_note + 51
E4	= base_note + 52
F4	= base_note + 53
Fi4	= base_note + 54
G4	= base_note + 55
Gi4	= base_note + 56
A4	= base_note + 57
Ai4	= base_note + 58
B4	= base_note + 59

C5	= base_note + 60
Ci5	= base_note + 61
D5	= base_note + 62

;-----
          
	;ALIGN 256         
PLAYER_INIT
	;rts
	;         
	; *** Freq init
	;
	ldx #(Channel1) & 255
	ldy #(Channel1) >> 8
	stx PCH1_LO
	sty PCH1_HI
	;
	ldx #(Channel2) & 255
	ldy #(Channel2) >> 8
	stx PCH2_LO
	sty PCH2_HI
	;
	ldx #(Channel3) & 255
	ldy #(Channel3) >> 8
	stx PCH3_LO
	sty PCH3_HI
	;
	ldx #$FF
	stx VOLTAB_CNT
	inx       
	stx NOTE1
	stx NOTE2
	stx NOTE3
	stx VOLUME  
	stx ARP_CNT
	jsr res
	inx
	stx NOTELEN1
	stx NOTELEN2
	stx NOTELEN3
	jsr res
	inx
	;
res	ldy #$00
	db $2C
	
advance	ldy PCH1,x
	;      
	lda PCH1_LO,x
	sta PCH_TEMP
	lda PCH1_HI,x
	sta PCH_TEMP+1
	;
	lda (PCH_TEMP),y	; LO byte
	sta CH1_LO,x
	iny
	lda (PCH_TEMP),y	; HI byte
	beq res
	sta CH1_HI,x
	iny
	sty PCH1,x
	rts
	
	;
	;##################
	;

PLAYER      
	ldx #$02
channel_loop
	inc NOTE1,x
	;
	lda NOTE1,x
	cmp NOTELEN1,x
	beq next_note
	jmp channel_loop_end
	;
next_note 
	lda CH1_LO,x
	sta CH_TEMP
	lda CH1_HI,x
	sta CH_TEMP+1
	;
	ldy #$00
	sty NOTE1,x		; reset note counter
	;   
	lda (CH_TEMP),y		; get byte
	iny
	;
	cmp #END_MARK		; $FF goes to new pattern
	bne pl_10
	;
	jsr advance
	bne next_note		; should never be zero
	;
pl_10	
	cmp #SET_VOLTAB
	bne pl_12
	;
	;LDA #$FF		; reset voltab counter
	sta VOLTAB_CNT
	;STA VOLUME		; disable SET volume
	;
	lda (CH_TEMP),y		; get lo byte
	iny
	sta VOL_TAB+1
	;
	lda (CH_TEMP),y		; get hi byte
	iny
	sta VOL_TAB+2
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_12	
	cmp #ARP		; instrument change?
	bne pl_13
	;
	lda (CH_TEMP),y		; get arpeggio byte
	and #$0F
	sta arpeggio_data+0
	;
	lda (CH_TEMP),y		; get same byte again
	lsr a
	lsr a
	lsr a
	lsr a
	sta arpeggio_data+1
	;
	lda #$05		; switch to arp
	sta INS_TYPE1,x   	; store instrument type
	;
	iny
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_13
	cmp #STOP_MARK
	beq channel_loop_end	
	;
	cmp #$FA
	bne pl_11
	;
	bit $FF19
	bit $FF15
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_11	
	cmp #SETINS		; instrument change?
	bcc pl_01
	;
	and #$0F		; keep lower 4 bits
	sta INS_TYPE1,x   	; store instrument type
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_01	cmp #LEN		; set note length?
	bcc pl_02
	;
	;SEC			; we know carry is always set
	sbc #LEN
	sta NOTELEN1,x
	;
	lda (CH_TEMP),y
	iny
	;
pl_02	; - store note!
	;
	sta TONE1,x
	;
	; --- advance pointer
	;
	tya
	clc
	adc CH1_LO,x
	sta CH1_LO,x
	bcc noi_1
	inc CH1_HI,x
noi_1	;
	;
	; -----------------------------------------------------------------
	;
channel_loop_end
	dex
	bmi pl_50
	jmp channel_loop
	;    
pl_50	
	;
	; --- SOUND PROCESSING
	;
PLAYER_SOUND
	lda #$20
	sta NOISE
	;
	ldx #$02
	jsr sound
	;
	cmp #$FE
	bne pl_v3
	cpy #$03
	bne pl_v3
	;
	ldx #$01		; channel 2
	jsr sound
	;
pl_v3	sta F1LO_store+1
	sty F1HI_x+1
	;
	lda F1HI
	and #$FC
F1HI_x	ora #$00
	sta F1HI_store+1
	;
F1LO_store
	lda #$00
	sta F1LO
F1HI_store
	lda #$00
	sta F1HI
	;
	; ---
	;
;	lda FX
;	beq nofx
;	;
;	and #$0F
;	tax
;	lda fx_vol,x
;	sta $FF11
;	;
;	lda fx_freq,x
;	ldy #$03
;	;
;	cpx #$03
;	beq fxover
;	;
;	inc FX
;	bne fxdone
;	;
;fxover	ldy #$00
;	sty FX
;fxdone	sta F2LO
;	sty F2HI
;	rts
;	;
;nofx	
	ldx #$00		; channel 1
	jsr sound
	sta F2LO
	sty F2HI
	;
	; ---
	;    
	;INC TICK1
	;INC TICK2
	;
	; ---
	;
	ldy VOLTAB_CNT
	iny
res_v	
VOL_TAB
	lda vol_default,y
	bpl noi_v		; check for $FF
	ldy #$00		; reached, so warp
	beq res_v
noi_v	sty VOLTAB_CNT
	clc
	adc VOLUME
	tay
	lda volume_map,y
	ora NOISE
	;
	ldy F1LO
	cpy #$FE
	bne setvol		; not silent
	ldy F2LO
	cpy #$FE
	beq sil			; silent: skip setting $FF11 to avoid clicks
	;
setvol	sta $FF11		; self-mod
	;
sil	rts     
	;
inst_table
	dw normal, bassdrum, snare, snare2, hihat, arpeggio, vibrato, vibrato2, blipp
	;
sound	lda TONE1,x
	cmp #OFF
	beq lookup
	;
	lda INS_TYPE1,x
	asl a
	tay
	lda inst_table,y
	sta inst_jump+1
	lda inst_table+1,y
	sta inst_jump+2
	;
inst_jump
	jmp $0000
	
	;
	; ---
	;
normal	lda TONE1,x		; normal note
lookup	tax
	lda freqs_lo,x
	ldy freqs_hi,x
	rts
	;
	; ---
	;
blipp	lda TONE1,x
	ldy NOTE1,x
	cpy #$03
	bcs blipp_off
	cpy #$02
	bcc lookup
	clc
	adc #$0C
	bne lookup
	
blipp_off
	lda #OFF
	bne lookup
	;
	; ---
	;
arpeggio
	lda ARP_CNT		; load current arp counter
	clc
	adc #$01
	cmp #$06		; auto reset every 6 frames (n1,n1,n2,n2,n3,n3)
	bne *+4
	lda #$00
	sta ARP_CNT
	lsr a
	tay
	lda arpeggio_data,y	; for channel 2 (self-mod)
	clc
	adc TONE1,x
	bne lookup
	;
	; ---
	;
vibrato2
	lda NOTE1,x
	and #$0F
	tay
	lda vibrato2_data,y
	bmi vib_sub1
	bpl vib_add
	
vibrato	lda NOTE1,x
	and #$0F
	tay
	lda vibrato_data,y
	bmi vib_sub1
	;
vib_add
	sta vib2+1
	;
	lda TONE1,x
	tax
	ldy freqs_hi,x
	lda freqs_lo,x
	clc
vib2	adc #$01
	bcc *+3
	iny
	rts
	;
vib_sub1
	and #$7F
	;      
	sta vib4+1
	;
	lda TONE1,x
	tax
	ldy freqs_hi,x
	lda freqs_lo,x
	sec
vib4	sbc #$01
	bcs *+3
	dey
	rts
	;
	; ---
	;
hihat
	lda #$40
	sta NOISE
	lda NOTE1,x
	tax
	lda hihat_freq,x
	ldy #$03
	rts
	;
	; ---
	;
snare	
	lda #$40
	sta NOISE
	;
	lda NOTE1,x
	tax
	lda snare_data,x	; load snare freq
	ldy #$03
	rts
	
snare2	
	lda #$40
	sta NOISE
	;
	lda TONE1,x
	tax
	lda freqs_lo,x
	ldy #$03
	rts
	;
	; ---
	;
bassdrum
	lda NOTE1,x
	asl a
	tax
	lda bass_freq,x
	ldy bass_freq+1,x
	rts

vibrato_data
	db $00,$01,$01,$02,$02,$02,$01,$01
	db $00,$81,$81,$82,$82,$82,$81,$81
	
vibrato2_data
	db $00,$02,$04,$05,$05,$05,$04,$02
	db $00,$82,$84,$85,$85,$85,$84,$82
;[eof]