#pragma once
#include <iostream>
#include "CGengine.hpp"

using namespace cg_engine;

#define ROBOTCUBENUM 58

Hierarchy3D *parsehierfile(string filename, Mesh3D *mesh);
void hiertoindividual(Node *root, Matrix t);

class GroupTitle: public Scene{
	public:
		GroupTitle(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix         pmatrix;
		ShaderProgram *drawshader;
		ShaderProgram *postprocessing;
		Mesh3D        *background;
		Mesh3D        *creators;
		GLuint         bgtex;
		RenderBuffer  *rb;
};

class MarchingCubes: public Scene{
	public:
		MarchingCubes(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix         pm;
		ShaderProgram *drawshader;
		ShaderProgram *postprocessing;
		Mesh3D        *background;
		Mesh3D        *cube;
		float          x[28];
		float          z[28];
		float          t[28];
		GLuint         bgtex;
		GLuint         cubetex;
		RenderBuffer  *rb;
};

class BouncingCubes: public Scene{
	public:
		BouncingCubes(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix          pm;
		ShaderProgram  *drawshader;
		ShaderProgram  *postprocessing;
		Mesh3D         *tunnel;
		Mesh3D         *cube;
		GLuint          tunneltex;
		GLuint          cubetex;
		float           x[120];
		float           y[120];
		float           z[120];
		float           ro[120];
		RenderBuffer   *rb;
};

class BouncingCubes2: public Scene{
	public:
		BouncingCubes2(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix          pm;
		ShaderProgram  *drawshader;
		Mesh3D         *tunnel;
		Mesh3D         *cube;
		GLuint          tunneltex;
		GLuint          cubetex;
		float           x[50];
		float           y[50];
		float           z[50];
		float           ro[50];
};

class Sinkhole: public Scene{
	public:
		Sinkhole(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix          pm;
		Matrix          camera;
		ShaderProgram  *drawshader;
		ShaderProgram  *postprocessing;
		Mesh3D         *sinkhole;
		Mesh3D         *cube;
		GLuint          cubetex;
		GLuint          sinktex;
		double          pos[3] = {0.0, 8.0, 1.0};
		double          target[3] = {0.0, 0.0, 0.0};
		double          up[3] = {0.0, 1.0, 0.0};
		double          delay[120];
		Path           *path[4];
		RenderBuffer   *rb;
};

class RobotCave: public Scene{
	public:
		RobotCave(int w, int h, Config *c);
		void show(double time);
	private:
		GLuint          floortex;
		GLuint          cavetex;
		GLuint          cubetex;
		ShaderProgram  *drawshader;
		Mesh3D         *cave;
		Mesh3D         *floor;
		Mesh3D         *cube;
		Matrix          pmatrix;
		Hierarchy3D    *robot;
		double          starttime[ROBOTCUBENUM];
};

class RobotIntro: public Scene{
	public:
		RobotIntro(int w, int h, Config *c);
		void show(double time);
	private:
		GLuint floortex;
		GLuint cavetex;
		GLuint cubetex;
		ShaderProgram *drawshader;
		Mesh3D *cave;
		Mesh3D *cube;
		Mesh3D *floor;
		Matrix pmatrix;
		Hierarchy3D *robot;
};

class RobotRunning: public Scene{
	public:
		RobotRunning(int w, int h, Config *c);
		void show(double time);
	private:
		GLuint floortex;
		GLuint cavetex;
		Hierarchy3D *robot;
		ShaderProgram *drawshader;
		GLuint  cubetex;
		Mesh3D *cube;
		Mesh3D *cave;
		Mesh3D *floor;
		Matrix pmatrix;
};

class Greetings: public Scene{
	public:
		Greetings(int w, int h, Config *c);
		void show(double time);
	private:
		Mesh3D *glasstube;
		Mesh3D *groups;
		Mesh3D *cube;
		GLuint  groupstex;
		GLuint  cubetex;
		GLuint glasstex;
		ShaderProgram *drawshader;
		ShaderProgram *glassshader;
		Matrix pmatrix;
		float cpos[36];
};

class FallingApart: public Scene{
	public:
		FallingApart(int w, int h, Config *c);
		void show(double time);
	private:
		Matrix pmatrix;
		Mesh3D *cube;
		Mesh3D *cave;
		Mesh3D *floor;
		Hierarchy3D *robot;
		Hierarchy3D *bounchofcubes; 
		ShaderProgram *drawshader;
		ShaderProgram *layershader;
		GLuint floortex;
		GLuint cavetex;
		GLuint cubetex;
		GLuint titletex;
		Sprite *layer;
		float direction[ROBOTCUBENUM * 2];
};

class MyDemo: public Demo{
	public:
		MyDemo(int w, int h);
		void init();
};
