#include "ShaderProgram.hpp"
#include <stdio.h>
#include "ShaderError.hpp"

using namespace cg_engine;

ShaderProgram::ShaderProgram()
{
	programid = glCreateProgram();
}

ShaderProgram::~ShaderProgram()
{
	glDeleteProgram(programid);
}

void ShaderProgram::addShader(const char *filename, GLenum shadertype)
{
	Shader *shader = new Shader(filename, shadertype);
	glAttachShader(programid, shader->getShaderId());
}

void ShaderProgram::compile()
{
	int error;
	glLinkProgram(programid);
	glGetProgramiv(programid, GL_LINK_STATUS, &error);
	if (error == GL_FALSE) {
		printf("Link error\n");
		ShaderError::errorStr(programid, PROGRAM_ERROR);

	}
	glValidateProgram(programid);
	glGetProgramiv(programid, GL_VALIDATE_STATUS, &error);
	if (error == GL_FALSE) {
		printf("Validate error\n");
		ShaderError::errorStr(programid, PROGRAM_ERROR);
	}
}

GLuint ShaderProgram::getProgramID()
{
	return(programid);
}

void ShaderProgram::use()
{
	glUseProgram(programid);
	texturecount = 0;
}

void ShaderProgram::setParam(const char *varname, float value)
{
	GLint loc = glGetUniformLocation(programid, varname);
	glUniform1f(loc, value);
}

void ShaderProgram::setParam(const char *varname, Matrix value)
{
	GLint loc = glGetUniformLocation(programid, varname);
	glUniformMatrix4fv(loc, 1, GL_FALSE, value.matrix());
}

void ShaderProgram::setParam(const char *varname, int value)
{
	GLint loc = glGetUniformLocation(programid, varname);
	glUniform1i(loc, value);
}

void ShaderProgram::addTexture(const char *varname, GLuint texnum)
{
	glActiveTexture(GL_TEXTURE0 + texturecount);
	glBindTexture(GL_TEXTURE_2D, texnum);
	setParam(varname, texturecount);
	texturecount++;
}

void ShaderProgram::addTexture(const char *varname, Texture *texture)
{
	addTexture(varname, texture->getTexID());
}
