#pragma once
#include <GL/glew.h>
#include "CGengine.hpp"

namespace cg_engine {
	class RenderBuffer
	{
	public:
		RenderBuffer(int w, int h, int sy, int texnum, bool adddepth);
		~RenderBuffer();
		GLuint getFramebuffer();
		GLuint getRenderTexture(int index);
		GLuint getDepth();
		void firstPass();
		void secondPass();
		void draw();
		void addShader(ShaderProgram *prg);
		bool getError();
	private:
		GLuint framebuffer = 0;
		GLuint *renderTexture;
		GLuint depthbuffer = 0;
		int width;
		int height;
		int starty;
		bool isError;
		int maxtexture;
		ShaderProgram *postprocessing;
		Sprite *outsprite;
		char **texnames;
	};

}
