#pragma once
#include <GL/glew.h>
#include <vector>
#include "Point3D.hpp"

namespace cg_engine {
	class Particle {
		private:
			GLfloat startx;
			GLfloat starty;
			GLfloat startz;
			int count;
			GLuint vao;
			GLuint buffers[4];
			std::vector<GLfloat> pos;
			std::vector<GLfloat> direction;
			std::vector<GLfloat> birth;
			std::vector<GLfloat> life;
			std::vector<GLfloat> constrait;
			void createOpenGLBinding();
			bool collision(int pi, int ci);
			double volume(Point3D p1, Point3D p2, Point3D p3, Point3D p4);
		public:
			Particle(int nump, GLfloat x, GLfloat y, GLfloat z);
			Particle(int num, GLfloat x1, GLfloat x2, GLfloat y1, GLfloat y2, GLfloat z1, GLfloat z2);
			~Particle();
			void draw();
			void addConstrait(GLfloat x1, GLfloat y1, GLfloat z1, GLfloat x2, GLfloat y2, GLfloat z2, GLfloat x3, GLfloat y3, GLfloat z3);
			void update(double time);
			void update(double time, double newx, double newy, double newz);
	};
}
