#include "Particle.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

using namespace cg_engine;
using namespace std;

void Particle::createOpenGLBinding(){

	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	glGenBuffers(4, buffers);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * 3 * count, &pos[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(0);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[1]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * 3 * count, &direction[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(1);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[2]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * count, &birth[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(2, 1, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(2);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[3]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * count, &life[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(3, 1, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(3);

	glBindVertexArray(0);
}

Particle::Particle(int num, GLfloat x, GLfloat y, GLfloat z)
{
	startx = x;
	starty = y;
	startz = z;
	count  = num;

	for(int i = 0; i < count; i++) {
		// Every particle came from the same point
		pos.push_back(startx);
		pos.push_back(starty);
		pos.push_back(startz);

		// what is the destination?
		direction.push_back(drand48()/100.0);
		direction.push_back(drand48()/100.0);
		direction.push_back(drand48()/100.0);

		// Life of the particle
		birth.push_back(0.0);
		life.push_back(drand48() * 12.0);
	}
	createOpenGLBinding();
}

Particle::Particle(int num, GLfloat x1, GLfloat y1, GLfloat z1, GLfloat x2, GLfloat y2, GLfloat z2)
{
	count = num;
	for(int i = 0; i < num; i++){
		pos.push_back(x1 + (x2 - x1) * drand48());
		pos.push_back(y1 + (y2 - y1) * drand48());
		pos.push_back(z1 + (z2 - z1) * drand48());

		direction.push_back(0.0);
		direction.push_back(0.0);
		direction.push_back(0.0);

		birth.push_back(0.0);
		life.push_back(120.0); // long life
	}
	createOpenGLBinding();
}

Particle::~Particle()
{
}

void Particle::draw()
{
	glBindVertexArray(vao);
	glDrawArrays(GL_POINTS, 0, count);
}

void Particle::addConstrait(GLfloat x1, GLfloat y1, GLfloat z1, GLfloat x2, GLfloat y2, GLfloat z2, GLfloat x3, GLfloat y3, GLfloat z3)
{
	constrait.push_back(x1);
	constrait.push_back(y1);
	constrait.push_back(z1);
	constrait.push_back(x2);
	constrait.push_back(y2);
	constrait.push_back(z2);
	constrait.push_back(x3);
	constrait.push_back(y3);
	constrait.push_back(z3);
}

void Particle::update(double time)
{
	for(int i = 0; i < count; i++){
		int index = i * 3;
		if( time > life.at(i)){
			pos.at(index + 0) = startx;
			pos.at(index + 1) = starty;
			pos.at(index + 2) = startz;

			direction.at(index + 0) = drand48() / 100.0;
			direction.at(index + 1) = drand48() / 100.0;
			direction.at(index + 2) = drand48() / 100.0;

			birth.at(i) = time;
			life.at(i) = time + drand48() * 12.0;
		} else {
			//Collision detection
			for(unsigned int j = 0; j < constrait.size() / 9; j++){
				if(collision(i, j)){
					//TODO need to calculate the angle
					//printf("Collision! %d\n", i);
					direction.at(index + 0) = direction.at(index + 0) * -1.0;
					direction.at(index + 1) = direction.at(index + 1) * -1.0;
					direction.at(index + 2) = direction.at(index + 2) * -1.0;
				}
			}
			pos.at(index + 0) = pos.at(index + 0) + direction.at(index + 0);
			pos.at(index + 1) = pos.at(index + 1) + direction.at(index + 1);
			pos.at(index + 2) = pos.at(index + 2) + direction.at(index + 2);
		}
	}

	glBindVertexArray(vao);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[0]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count * 3, &pos[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[1]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count * 3, &direction[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[2]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count, &birth[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[3]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count, &life[0]);

	glBindVertexArray(0);
}

void Particle::update(double time, double newx, double newy, double newz)
{
	startx = newx;
	starty = newy;
	startz = newz;
	update(time);
}

double Particle::volume(Point3D p1, Point3D p2, Point3D p3, Point3D p4)
{
	return 1.0 / 0.6 * Point3D::dot(Point3D::cross(p2 - p1, p3 - p1), p4 - p1);
}

bool Particle::collision(int pi, int ci)
{
	Point3D particle(pos.at(pi * 3), pos.at(pi * 3 + 1), pos.at(pi * 3 + 2));
	Point3D targetpos(pos.at(pi * 3) + direction.at(pi * 3), pos.at(pi * 3 + 1) + direction.at(pi * 3 + 1), pos.at(pi * 3 + 2) + direction.at(pi * 3 + 2));

	Point3D c1(constrait.at(ci * 9 + 0), constrait.at(ci * 9 + 1), constrait.at(ci * 9 + 2));
	Point3D c2(constrait.at(ci * 9 + 3), constrait.at(ci * 9 + 4), constrait.at(ci * 9 + 5));
	Point3D c3(constrait.at(ci * 9 + 6), constrait.at(ci * 9 + 7), constrait.at(ci * 9 + 8));

        double r1 = copysign(1.0, volume(particle, c1, c2, c3));
        double r2 = copysign(1.0, volume(targetpos, c1, c2, c3));
        double r3 = copysign(1.0, volume(particle, targetpos, c1, c2));
        double r4 = copysign(1.0, volume(particle, targetpos, c2, c3));
        double r5 = copysign(1.0, volume(particle, targetpos, c3, c1));

        if (r1 != r2 && (r3 == r4 && r4 == r5)) {
                return true;
        }

        return false;
}
