#pragma once

#include <vector>
#include <unordered_map>
#include <string>
#include "Matrix.hpp"
#include "Mesh3D.hpp"

namespace cg_engine {
	class Node {
		private:
			Matrix statematrix;
			Matrix drawmatrix;
			Mesh3D *mesh;
		public:
			Node();
			~Node();
			void setMesh(Mesh3D *m);
			void updateMatrix(Matrix m, bool childs);
			void updateStateMatrix(Matrix m);
			void addChild(Node *h);
			void draw();
			Matrix getMatrix();
			std::vector<Node*> childs;
	};

	class Hierarchy3D {
		private:
			Node *root;
		public:
			Hierarchy3D();
			~Hierarchy3D();
			void addNode(std::string id, Node *n);
			Node* getNode(std::string id);
			std::unordered_map<std::string, Node*> all_nodes;
	};
}
