#pragma once

#include <unordered_map>
#include <GL/glew.h>
#include "ShaderProgram.hpp"
#include "Mesh3D.hpp"
#include <string>

using namespace std;

namespace cg_engine {
	class Config {
		private:
			unordered_map<string, ShaderProgram*> shaders;
			unordered_map<string, GLuint> textures;
			unordered_map<string, string> files;
			unordered_map<string, Mesh3D*> models;
			string music;
		public:
			Config(const char *filename);
			~Config();
			string getMusic();
			ShaderProgram* getShader(string shadername);
			Mesh3D* getModel(string modelname);
			GLuint getTexture(string texturename);
			string getFile(string filename);
	};
}
