#include <fstream>
#include <iostream>
#include <string.h>
#include "CGengine.hpp"

using namespace std;
using namespace cg_engine;

Config::Config(const char *filename) {
	// open file, parse file
	ifstream cfg(filename, ios::in);
	string line;

	while(std::getline(cfg, line)){
		size_t pos = line.find(" ");
		string token = line.substr(0, pos);
		// load texture
		if(token == "Texture"){
			size_t pos2 = line.find(" ", pos+1);
			string name = line.substr(pos + 1, pos2 - pos - 1);
			string filename = line.substr(pos2 + 1);
			ImgType t = PNGType;
			if(filename.substr(filename.length()-3) == "jpg"){
				t = JPEGType;
			}
			Texture *img = new Texture(filename.c_str(), t);
			textures[name] = img->getTexID();
		}
		// load shader
		if(token == "Shader"){
			size_t pos2 = line.find(" ", pos + 1);
			string name = line.substr(pos + 1, pos2 - pos - 1);
			size_t pos3 = line.find(" ", pos2 + 1);
			string fn   = line.substr(pos2 + 1, pos3 - pos2 - 1);
			string vn   = line.substr(pos3 + 1);

			ShaderProgram *prg = new ShaderProgram();
			prg->addShader(fn.c_str(), GL_FRAGMENT_SHADER);
			prg->addShader(vn.c_str(), GL_VERTEX_SHADER);
			prg->compile();

			shaders[name] = prg;
		}
		if(token == "Mesh"){
			size_t pos2 = line.find(" ", pos + 1);
			string name = line.substr(pos + 1, pos2 - pos - 1);
			string filename = line.substr(pos2 + 1);
			Mesh3D *mesh = new Mesh3D(filename.c_str());
			models[name] = mesh;
		}
		if(token == "File"){
			size_t pos2 = line.find(" ", pos+1);
			string name = line.substr(pos + 1, pos2 - pos - 1);
			string filename = line.substr(pos2 + 1);
			files[name] = filename;
		}
	}
}

Config::~Config() {
	// release resources
}

string Config::getMusic() {
	return music;
}

ShaderProgram* Config::getShader(string shadername) {
	return shaders.at(shadername);
}

GLuint Config::getTexture(string texturename) {
	return textures.at(texturename);
}

string Config::getFile(string filename) {
	return files.at(filename);
}

Mesh3D* Config::getModel(string modelname) {
	return models[modelname];
}
