#version 450

#define KERNELSIZE 21

layout (location = 0) out vec4 FragColor;

uniform sampler2D color0;
uniform sampler2D color1;
in vec2 texcoord;

float gausscoef(float sigma, int x, int y) {
   float e = exp( -1.0 * (x*x + y*y) / (2.0 * sigma*sigma) );
   return 1.0 / (2.0 * 3.14 * sigma*sigma) * e;
}

vec4 blur(float sigma, sampler2D img, vec2 tc, vec2 screen){
   int dc = (KERNELSIZE - 1) / 2;
   vec4 sum = vec4(0.0);
   vec4 blurcolor = vec4(0.0);
   float tmp[KERNELSIZE][KERNELSIZE];

   for(int i = 0; i < KERNELSIZE; i++){
      for(int j = 0; j < KERNELSIZE; j++){
         tmp[i][j] = gausscoef(sigma, i - dc, j - dc);
         sum += tmp[i][j];
      }
   }

   for(int i = 0; i < KERNELSIZE; i++){
      for(int j = 0; j < KERNELSIZE; j++){
         vec2 t = tc + screen * vec2(float(i - dc), float(j - dc));
         blurcolor += (tmp[i][j] / sum) * texture(img, t);
      }
   }

   return blurcolor;
}

void main(void){
   vec2 screensize = 1.0 / textureSize(color1, 0);
   vec4 white = vec4(1.0);

   vec4 diff = texture(color0, texcoord);
   vec4 bright = blur(18.0, color1, texcoord, screensize);

   FragColor = mix(diff, white, bright.r);
}
